/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.common.model;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.view.util.ShapeUtils;
import edu.colorado.phet.geneexpressionbasics.common.model.AttachmentSite;
import edu.colorado.phet.geneexpressionbasics.common.model.GeneExpressionModel;
import edu.colorado.phet.geneexpressionbasics.common.model.MessengerRna;
import edu.colorado.phet.geneexpressionbasics.common.model.MobileBiomolecule;
import edu.colorado.phet.geneexpressionbasics.common.model.attachmentstatemachines.AttachmentStateMachine;
import edu.colorado.phet.geneexpressionbasics.common.model.attachmentstatemachines.RibosomeAttachmentStateMachine;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public class Ribosome
extends MobileBiomolecule {
    public static final Vector2D OFFSET_TO_TRANSLATION_CHANNEL_ENTRANCE = new Vector2D(215.0, -90.0);
    private static final Vector2D OFFSET_TO_PROTEIN_OUTPUT_CHANNEL = new Vector2D(172.0, 247.50000000000003);
    private MessengerRna messengerRnaBeingTranslated;

    public Ribosome(GeneExpressionModel geneExpressionModel) {
        this(geneExpressionModel, new Vector2D(0.0, 0.0));
    }

    public Ribosome(GeneExpressionModel geneExpressionModel, Vector2D vector2D) {
        super(geneExpressionModel, Ribosome.createShape(), new Color(205, 155, 29));
        this.setPosition(vector2D);
    }

    public MessengerRna getMessengerRnaBeingTranslated() {
        return this.messengerRnaBeingTranslated;
    }

    public AttachmentSite proposeAttachments() {
        AttachmentSite attachmentSite = null;
        List<MessengerRna> list = this.model.getMessengerRnaList();
        for (MessengerRna messengerRna : list) {
            attachmentSite = messengerRna.considerProposalFrom(this);
            if (attachmentSite == null) continue;
            this.messengerRnaBeingTranslated = messengerRna;
            break;
        }
        return attachmentSite;
    }

    public void releaseMessengerRna() {
        this.messengerRnaBeingTranslated.releaseFromRibosome(this);
        this.messengerRnaBeingTranslated = null;
    }

    protected AttachmentStateMachine createAttachmentStateMachine() {
        return new RibosomeAttachmentStateMachine(this);
    }

    private static Shape createShape() {
        ArrayList<Point2D> arrayList = new ArrayList<Point2D>(){
            {
                this.add(new Point2D.Double(-129.0, 243.0));
                this.add(new Point2D.Double(129.0, 270.0));
                this.add(new Point2D.Double(215.0, 0.0));
                this.add(new Point2D.Double(129.0, -108.0));
                this.add(new Point2D.Double(0.0, -135.0));
                this.add(new Point2D.Double(-129.0, -108.0));
                this.add(new Point2D.Double(-215.0, 0.0));
            }
        };
        Shape shape = AffineTransform.getTranslateInstance(0.0, 112.5).createTransformedShape(ShapeUtils.createRoundedShapeFromPoints((List<Point2D>)arrayList));
        ArrayList<Point2D> arrayList2 = new ArrayList<Point2D>(){
            {
                this.add(new Point2D.Double(-193.5, 90.0));
                this.add(new Point2D.Double(0.0, 81.0));
                this.add(new Point2D.Double(193.5, 90.0));
                this.add(new Point2D.Double(193.5, -90.0));
                this.add(new Point2D.Double(0.0, -81.0));
                this.add(new Point2D.Double(-193.5, -90.0));
            }
        };
        Shape shape2 = AffineTransform.getTranslateInstance(0.0, -112.5).createTransformedShape(ShapeUtils.createRoundedShapeFromPoints((List<Point2D>)arrayList2));
        Area area = new Area(shape);
        area.add(new Area(shape2));
        return area;
    }

    public Vector2D getEntranceOfRnaChannelPos() {
        return new Vector2D(this.getPosition()).plus(OFFSET_TO_TRANSLATION_CHANNEL_ENTRANCE);
    }

    public double getTranslationChannelLength() {
        return 430.0;
    }

    public boolean advanceMessengerRnaTranslation(double d) {
        assert (this.messengerRnaBeingTranslated != null);
        return this.messengerRnaBeingTranslated != null && this.messengerRnaBeingTranslated.advanceTranslation(this, d);
    }

    public Vector2D getProteinAttachmentPoint() {
        return this.getPosition().plus(OFFSET_TO_PROTEIN_OUTPUT_CHANNEL);
    }

    public void initiateTranslation() {
        assert (this.messengerRnaBeingTranslated != null);
        if (this.messengerRnaBeingTranslated != null) {
            this.messengerRnaBeingTranslated.initiateTranslation(this);
        }
    }
}

