/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.common.model;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.common.phetcommon.view.util.ShapeUtils;
import edu.colorado.phet.geneexpressionbasics.common.model.AttachmentSite;
import edu.colorado.phet.geneexpressionbasics.common.model.BioShapeUtils;
import edu.colorado.phet.geneexpressionbasics.common.model.GeneExpressionModel;
import edu.colorado.phet.geneexpressionbasics.common.model.MobileBiomolecule;
import edu.colorado.phet.geneexpressionbasics.common.model.attachmentstatemachines.AttachmentStateMachine;
import edu.colorado.phet.geneexpressionbasics.common.model.attachmentstatemachines.RnaPolymeraseAttachmentStateMachine;
import edu.colorado.phet.geneexpressionbasics.manualgeneexpression.model.StubGeneExpressionModel;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class RnaPolymerase
extends MobileBiomolecule {
    public static final Vector2D MESSENGER_RNA_GENERATION_OFFSET = new Vector2D(-136.0, 192.0);
    private static final List<Point2D> shapePoints = new ArrayList<Point2D>(){
        {
            this.add(new Point2D.Double(0.0, 240.0));
            this.add(new Point2D.Double(170.0, 120.0));
            this.add(new Point2D.Double(118.99999999999999, -120.0));
            this.add(new Point2D.Double(0.0, -240.0));
            this.add(new Point2D.Double(-118.99999999999999, -120.0));
            this.add(new Point2D.Double(-170.0, 120.0));
        }
    };
    private static final Color NOMINAL_COLOR = new Color(0, 153, 210);
    private static final Color CONFORMED_COLOR = Color.CYAN;
    private static final Random RAND = new Random(System.currentTimeMillis() + 2L);
    private final RnaPolymeraseAttachmentStateMachine rnaPolymeraseAttachmentStateMachine;

    public RnaPolymerase() {
        this(new StubGeneExpressionModel(), new Vector2D(0.0, 0.0));
    }

    public RnaPolymerase(GeneExpressionModel geneExpressionModel, Vector2D vector2D) {
        super(geneExpressionModel, RnaPolymerase.createShape(), NOMINAL_COLOR);
        this.rnaPolymeraseAttachmentStateMachine = (RnaPolymeraseAttachmentStateMachine)this.attachmentStateMachine;
        this.setPosition(vector2D);
    }

    protected AttachmentStateMachine createAttachmentStateMachine() {
        return new RnaPolymeraseAttachmentStateMachine(this);
    }

    public void changeConformation(double d) {
        Shape shape = BioShapeUtils.createdDistortedRoundedShapeFromPoints(shapePoints, d, 259L);
        Shape shape2 = AffineTransform.getTranslateInstance(this.getPosition().getX(), this.getPosition().getY()).createTransformedShape(shape);
        this.shapeProperty.set(shape2);
        this.colorProperty.set(ColorUtils.interpolateRBGA(NOMINAL_COLOR, CONFORMED_COLOR, d));
    }

    public AttachmentSite proposeAttachments() {
        return this.model.getDnaMolecule().considerProposalFrom(this);
    }

    public Vector2D getDetachDirection() {
        return RAND.nextBoolean() ? new Vector2D(0.0, 1.0) : new Vector2D(0.0, -1.0);
    }

    public void setRecycleMode(boolean bl) {
        this.rnaPolymeraseAttachmentStateMachine.setRecycleMode(bl);
    }

    public void addRecycleReturnZone(Rectangle2D rectangle2D) {
        this.rnaPolymeraseAttachmentStateMachine.addRecycleReturnZone(rectangle2D);
    }

    private static Shape createShape() {
        return ShapeUtils.createRoundedShapeFromPoints(shapePoints);
    }
}

