/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.common.model;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.geneexpressionbasics.common.model.AttachmentSite;
import edu.colorado.phet.geneexpressionbasics.common.model.WindingBiomolecule;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ShapeSegment {
    public final Property<Rectangle2D> bounds = new Property<Rectangle2D.Double>(new Rectangle2D.Double());
    public final AttachmentSite attachmentSite = new AttachmentSite(new Vector2D(), 1.0);
    public double capacity = Double.POSITIVE_INFINITY;

    public void setCapacity(double d) {
        this.capacity = d;
    }

    public double getRemainingCapacity() {
        return this.capacity - this.getContainedLength();
    }

    public Vector2D getLowerRightCornerPos() {
        return new Vector2D(this.bounds.get().getMaxX(), this.bounds.get().getMinY());
    }

    public void setLowerRightCornerPos(Vector2D vector2D) {
        Vector2D vector2D2 = new Vector2D(this.getLowerRightCornerPos());
        Vector2D vector2D3 = new Vector2D(vector2D).minus(vector2D2);
        Rectangle2D rectangle2D = AffineTransform.getTranslateInstance(vector2D3.getX(), vector2D3.getY()).createTransformedShape(this.bounds.get()).getBounds2D();
        this.bounds.set(rectangle2D);
        this.updateAttachmentSiteLocation();
    }

    public Vector2D getUpperLeftCornerPos() {
        return new Vector2D(this.bounds.get().getMinX(), this.bounds.get().getMaxY());
    }

    public void setUpperLeftCornerPosition(Vector2D vector2D) {
        this.bounds.set(new Rectangle2D.Double(vector2D.getX(), vector2D.getY() - this.bounds.get().getHeight(), this.bounds.get().getWidth(), this.bounds.get().getHeight()));
        this.updateAttachmentSiteLocation();
    }

    public void translate(Vector2D vector2D) {
        this.bounds.set(new Rectangle2D.Double(this.bounds.get().getX() + vector2D.getX(), this.bounds.get().getY() + vector2D.getY(), this.bounds.get().getWidth(), this.bounds.get().getHeight()));
        this.updateAttachmentSiteLocation();
    }

    public Rectangle2D getBounds() {
        return new Rectangle2D.Double(this.bounds.get().getX(), this.bounds.get().getY(), this.bounds.get().getWidth(), this.bounds.get().getHeight());
    }

    public boolean isFlat() {
        return this.getBounds().getHeight() == 0.0;
    }

    protected void updateAttachmentSiteLocation() {
        this.attachmentSite.locationProperty.set(this.getUpperLeftCornerPos());
    }

    public abstract double getContainedLength();

    public abstract void add(double var1, WindingBiomolecule.EnhancedObservableList<ShapeSegment> var3);

    protected abstract void remove(double var1, WindingBiomolecule.EnhancedObservableList<ShapeSegment> var3);

    public abstract void advance(double var1, WindingBiomolecule.EnhancedObservableList<ShapeSegment> var3);

    public abstract void advanceAndRemove(double var1, WindingBiomolecule.EnhancedObservableList<ShapeSegment> var3);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FlatSegment
    extends ShapeSegment {
        public FlatSegment(Vector2D vector2D) {
            this.bounds.set(new Rectangle2D.Double(vector2D.getX(), vector2D.getY(), 0.0, 0.0));
            this.updateAttachmentSiteLocation();
        }

        @Override
        public double getContainedLength() {
            return ((Rectangle2D)this.bounds.get()).getWidth();
        }

        @Override
        public void add(double d, WindingBiomolecule.EnhancedObservableList<ShapeSegment> enhancedObservableList) {
            assert (this.getContainedLength() <= this.capacity);
            double d2 = d;
            if (this.getContainedLength() + d > this.capacity) {
                SquareSegment squareSegment = new SquareSegment(this.getLowerRightCornerPos());
                d2 = this.capacity - this.getContainedLength();
                ((ShapeSegment)squareSegment).add(d - d2, enhancedObservableList);
                enhancedObservableList.insertAfter(this, squareSegment);
            }
            this.bounds.set(new Rectangle2D.Double(((Rectangle2D)this.bounds.get()).getX() - d2, ((Rectangle2D)this.bounds.get()).getY(), ((Rectangle2D)this.bounds.get()).getWidth() + d2, 0.0));
            this.updateAttachmentSiteLocation();
        }

        @Override
        public void remove(double d, WindingBiomolecule.EnhancedObservableList<ShapeSegment> enhancedObservableList) {
            this.bounds.set(new Rectangle2D.Double(((Rectangle2D)this.bounds.get()).getX(), ((Rectangle2D)this.bounds.get()).getY(), ((Rectangle2D)this.bounds.get()).getWidth() - d, 0.0));
            if (this.getContainedLength() < 1.0E-7) {
                enhancedObservableList.remove(this);
            }
            this.updateAttachmentSiteLocation();
        }

        @Override
        public void advance(double d, WindingBiomolecule.EnhancedObservableList<ShapeSegment> enhancedObservableList) {
            ShapeSegment shapeSegment = enhancedObservableList.getPreviousItem(this);
            ShapeSegment shapeSegment2 = enhancedObservableList.getNextItem(this);
            if (shapeSegment2 == null) {
                double d2 = Math.min(d, this.getContainedLength());
                this.remove(d2, enhancedObservableList);
                shapeSegment.add(d2, enhancedObservableList);
            } else if (shapeSegment2.getContainedLength() > d) {
                if (this.getContainedLength() + d <= this.capacity) {
                    this.add(d, enhancedObservableList);
                } else {
                    double d3 = this.getRemainingCapacity();
                    if (d3 > 1.0E-7) {
                        this.maxOutLength();
                        assert (shapeSegment == null);
                        FlatSegment flatSegment = new FlatSegment(this.getUpperLeftCornerPos()){
                            {
                                this.setCapacity(100.0);
                            }
                        };
                        enhancedObservableList.insertBefore(this, flatSegment);
                        shapeSegment = flatSegment;
                    }
                    shapeSegment.add(d - d3, enhancedObservableList);
                }
                shapeSegment2.remove(d, enhancedObservableList);
            } else {
                this.remove(d - shapeSegment2.getContainedLength(), enhancedObservableList);
                shapeSegment2.remove(shapeSegment2.getContainedLength(), enhancedObservableList);
                shapeSegment.add(d, enhancedObservableList);
            }
            this.updateAttachmentSiteLocation();
        }

        @Override
        public void advanceAndRemove(double d, WindingBiomolecule.EnhancedObservableList<ShapeSegment> enhancedObservableList) {
            ShapeSegment shapeSegment = enhancedObservableList.getNextItem(this);
            if (shapeSegment == null) {
                double d2 = Math.min(d, this.getContainedLength());
                this.remove(d2, enhancedObservableList);
            } else if (shapeSegment.getContainedLength() > d) {
                shapeSegment.remove(d, enhancedObservableList);
            } else {
                this.remove(d - shapeSegment.getContainedLength(), enhancedObservableList);
                shapeSegment.remove(shapeSegment.getContainedLength(), enhancedObservableList);
            }
            this.updateAttachmentSiteLocation();
        }

        private void maxOutLength() {
            double d = this.getRemainingCapacity();
            this.bounds.set(new Rectangle2D.Double(((Rectangle2D)this.bounds.get()).getX() - d, ((Rectangle2D)this.bounds.get()).getY(), this.capacity, 0.0));
            this.updateAttachmentSiteLocation();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SquareSegment
    extends ShapeSegment {
        private double containedLength = 0.0;

        public SquareSegment(Vector2D vector2D) {
            this.bounds.set(new Rectangle2D.Double(vector2D.getX(), vector2D.getY(), 0.0, 0.0));
            this.updateAttachmentSiteLocation();
        }

        @Override
        public double getContainedLength() {
            return this.containedLength;
        }

        @Override
        public void add(double d, WindingBiomolecule.EnhancedObservableList<ShapeSegment> enhancedObservableList) {
            this.add(d);
        }

        public void add(double d) {
            this.containedLength += d;
            double d2 = this.calculateSideLength() - ((Rectangle2D)this.bounds.get()).getWidth();
            assert (d >= 0.0 && d2 >= 0.0);
            this.bounds.set(new Rectangle2D.Double(((Rectangle2D)this.bounds.get()).getX() - d2, ((Rectangle2D)this.bounds.get()).getY(), ((Rectangle2D)this.bounds.get()).getWidth() + d2, ((Rectangle2D)this.bounds.get()).getHeight() + d2));
            this.updateAttachmentSiteLocation();
        }

        @Override
        public void remove(double d, WindingBiomolecule.EnhancedObservableList<ShapeSegment> enhancedObservableList) {
            this.containedLength -= d;
            double d2 = ((Rectangle2D)this.bounds.get()).getWidth() - this.calculateSideLength();
            assert (d >= 0.0 && d2 >= 0.0);
            this.bounds.set(new Rectangle2D.Double(((Rectangle2D)this.bounds.get()).getX(), ((Rectangle2D)this.bounds.get()).getY() + d2, ((Rectangle2D)this.bounds.get()).getWidth() - d2, ((Rectangle2D)this.bounds.get()).getHeight() - d2));
            if (this.getContainedLength() <= 1.0E-7) {
                enhancedObservableList.remove(this);
            }
            this.updateAttachmentSiteLocation();
        }

        @Override
        public void advance(double d, WindingBiomolecule.EnhancedObservableList<ShapeSegment> enhancedObservableList) {
            assert (false);
        }

        @Override
        public void advanceAndRemove(double d, WindingBiomolecule.EnhancedObservableList<ShapeSegment> enhancedObservableList) {
            System.out.println(this.getClass().getName() + "Unimplemented method called on square shape segment.");
            assert (false);
        }

        private double calculateSideLength() {
            double d = Math.pow(this.containedLength, 0.7);
            return Math.sqrt(2.0 * d * d);
        }
    }
}

