/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.common.model;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.geneexpressionbasics.common.model.AttachmentSite;
import edu.colorado.phet.geneexpressionbasics.common.model.BioShapeUtils;
import edu.colorado.phet.geneexpressionbasics.common.model.GeneExpressionModel;
import edu.colorado.phet.geneexpressionbasics.common.model.MobileBiomolecule;
import edu.colorado.phet.geneexpressionbasics.common.model.attachmentstatemachines.AttachmentStateMachine;
import edu.colorado.phet.geneexpressionbasics.common.model.attachmentstatemachines.TranscriptionFactorAttachmentStateMachine;
import edu.colorado.phet.geneexpressionbasics.manualgeneexpression.model.StubGeneExpressionModel;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Dimension2D;
import java.util.Random;

public class TranscriptionFactor
extends MobileBiomolecule {
    private static final Dimension2D SIZE = new PDimension(325.0, 240.0);
    public static final TranscriptionFactorConfig TRANSCRIPTION_FACTOR_CONFIG_GENE_1_POS = new TranscriptionFactorConfig(BioShapeUtils.createRandomShape(SIZE, 1000), true, Color.yellow);
    public static final TranscriptionFactorConfig TRANSCRIPTION_FACTOR_CONFIG_GENE_1_NEG = new TranscriptionFactorConfig(BioShapeUtils.createRandomShape(SIZE, 2000), false, Color.red);
    public static final TranscriptionFactorConfig TRANSCRIPTION_FACTOR_CONFIG_GENE_2_POS_1 = new TranscriptionFactorConfig(BioShapeUtils.createRandomShape(SIZE, 3001), true, Color.orange);
    public static final TranscriptionFactorConfig TRANSCRIPTION_FACTOR_CONFIG_GENE_2_POS_2 = new TranscriptionFactorConfig(BioShapeUtils.createRandomShape(SIZE, 125), true, new Color(0, 255, 127));
    public static final TranscriptionFactorConfig TRANSCRIPTION_FACTOR_CONFIG_GENE_2_NEG = new TranscriptionFactorConfig(BioShapeUtils.createRandomShape(SIZE, 4000), false, new Color(255, 255, 255));
    public static final TranscriptionFactorConfig TRANSCRIPTION_FACTOR_CONFIG_GENE_3_POS_1 = new TranscriptionFactorConfig(BioShapeUtils.createRandomShape(SIZE, 57), true, new Color(255, 127, 0));
    public static final TranscriptionFactorConfig TRANSCRIPTION_FACTOR_CONFIG_GENE_3_POS_2 = new TranscriptionFactorConfig(BioShapeUtils.createRandomShape(SIZE, 88), true, new Color(255, 99, 71));
    public static final TranscriptionFactorConfig TRANSCRIPTION_FACTOR_CONFIG_GENE_3_NEG = new TranscriptionFactorConfig(BioShapeUtils.createRandomShape(SIZE, 40), false, Color.magenta);
    private static final Random RAND = new Random(System.currentTimeMillis() - 8L);
    private final TranscriptionFactorConfig config;

    public TranscriptionFactor(TranscriptionFactorConfig transcriptionFactorConfig) {
        this(new StubGeneExpressionModel(), transcriptionFactorConfig);
    }

    public TranscriptionFactor(GeneExpressionModel geneExpressionModel, TranscriptionFactorConfig transcriptionFactorConfig) {
        this(geneExpressionModel, transcriptionFactorConfig, new Vector2D(0.0, 0.0));
    }

    public TranscriptionFactor(GeneExpressionModel geneExpressionModel, TranscriptionFactorConfig transcriptionFactorConfig, Vector2D vector2D) {
        super(geneExpressionModel, transcriptionFactorConfig.shape, transcriptionFactorConfig.baseColor);
        this.config = transcriptionFactorConfig;
        this.setPosition(vector2D);
    }

    public boolean isPositive() {
        return this.config.isPositive;
    }

    protected AttachmentStateMachine createAttachmentStateMachine() {
        return new TranscriptionFactorAttachmentStateMachine(this);
    }

    protected void handleReleasedByUser() {
        super.handleReleasedByUser();
        for (MobileBiomolecule mobileBiomolecule : this.model.getOverlappingBiomolecules(this.getShape())) {
            if (mobileBiomolecule == this || !((Boolean)mobileBiomolecule.attachedToDna.get()).booleanValue()) continue;
            this.attachmentStateMachine.forceImmediateUnattachedButUnavailable();
            break;
        }
    }

    public Vector2D getDetachDirection() {
        return RAND.nextBoolean() ? new Vector2D(0.0, 1.0) : new Vector2D(0.0, -1.0);
    }

    public AttachmentSite proposeAttachments() {
        return this.model.getDnaMolecule().considerProposalFrom(this);
    }

    public TranscriptionFactorConfig getConfig() {
        return this.config;
    }

    public static class TranscriptionFactorConfig {
        public final Shape shape;
        public final Color baseColor;
        public final boolean isPositive;

        TranscriptionFactorConfig(Shape shape, boolean bl, Color color) {
            this.shape = shape;
            this.baseColor = color;
            this.isPositive = bl;
        }
    }
}

