/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.common.model.attachmentstatemachines;

import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.geneexpressionbasics.common.model.MessengerRnaDestroyer;
import edu.colorado.phet.geneexpressionbasics.common.model.MessengerRnaFragment;
import edu.colorado.phet.geneexpressionbasics.common.model.MobileBiomolecule;
import edu.colorado.phet.geneexpressionbasics.common.model.attachmentstatemachines.AttachmentState;
import edu.colorado.phet.geneexpressionbasics.common.model.attachmentstatemachines.AttachmentStateMachine;
import edu.colorado.phet.geneexpressionbasics.common.model.attachmentstatemachines.GenericAttachmentStateMachine;
import edu.colorado.phet.geneexpressionbasics.common.model.motionstrategies.DestroyerTrackingRnaMotionStrategy;
import java.util.Random;

public class RnaDestroyerAttachmentStateMachine
extends GenericAttachmentStateMachine {
    private static final DoubleRange MRNA_FRAGMENT_LENGTH_RANGE = new DoubleRange(100.0, 400.0);
    private static final Random RAND = new Random();
    private final MessengerRnaDestroyer mRnaDestroyer;

    public RnaDestroyerAttachmentStateMachine(MobileBiomolecule mobileBiomolecule) {
        super(mobileBiomolecule);
        this.mRnaDestroyer = (MessengerRnaDestroyer)mobileBiomolecule;
        this.attachedState = new MRnaDestroyerAttachedState();
        this.movingTowardsAttachmentState = new MRnaDestroyerMovingTowardAttachmentState();
    }

    public void forceImmediateUnattachedAndAvailable() {
        if (this.mRnaDestroyer.getMessengerRnaBeingDestroyed() != null) {
            this.mRnaDestroyer.getMessengerRnaBeingDestroyed().abortDestruction();
            this.mRnaDestroyer.clearMessengerRnaBeingDestroyed();
        }
        super.forceImmediateUnattachedAndAvailable();
    }

    protected class MRnaDestroyerAttachedState
    extends AttachmentState {
        private MessengerRnaFragment messengerRnaFragment = null;
        private double targetFragmentLength = 0.0;

        protected MRnaDestroyerAttachedState() {
        }

        public void stepInTime(AttachmentStateMachine attachmentStateMachine, double d) {
            boolean bl;
            assert (attachmentStateMachine.attachmentSite != null);
            assert (attachmentStateMachine.attachmentSite.attachedOrAttachingMolecule.get() == attachmentStateMachine.biomolecule);
            if (this.messengerRnaFragment == null) {
                this.messengerRnaFragment = new MessengerRnaFragment(RnaDestroyerAttachmentStateMachine.this.biomolecule.getModel(), RnaDestroyerAttachmentStateMachine.this.biomolecule.getPosition());
                RnaDestroyerAttachmentStateMachine.this.biomolecule.getModel().addMobileBiomolecule(this.messengerRnaFragment);
                this.targetFragmentLength = MRNA_FRAGMENT_LENGTH_RANGE.getMin() + RAND.nextDouble() * MRNA_FRAGMENT_LENGTH_RANGE.getLength();
            }
            this.messengerRnaFragment.addLength(750.0 * d);
            if (this.messengerRnaFragment.getLength() >= this.targetFragmentLength) {
                this.messengerRnaFragment.releaseFromDestroyer();
                this.messengerRnaFragment = null;
            }
            if (bl = RnaDestroyerAttachmentStateMachine.this.mRnaDestroyer.advanceMessengerRnaDestruction(750.0 * d)) {
                if (this.messengerRnaFragment != null) {
                    this.messengerRnaFragment.releaseFromDestroyer();
                    this.messengerRnaFragment = null;
                }
                RnaDestroyerAttachmentStateMachine.this.biomolecule.getModel().removeMessengerRna(RnaDestroyerAttachmentStateMachine.this.mRnaDestroyer.getMessengerRnaBeingDestroyed());
                RnaDestroyerAttachmentStateMachine.this.mRnaDestroyer.clearMessengerRnaBeingDestroyed();
                attachmentStateMachine.detach();
            }
        }

        public void entered(AttachmentStateMachine attachmentStateMachine) {
            RnaDestroyerAttachmentStateMachine.this.mRnaDestroyer.initiateMessengerRnaDestruction();
            RnaDestroyerAttachmentStateMachine.this.mRnaDestroyer.setMotionStrategy(new DestroyerTrackingRnaMotionStrategy(RnaDestroyerAttachmentStateMachine.this.mRnaDestroyer));
            attachmentStateMachine.biomolecule.movableByUser.set(false);
        }
    }

    protected class MRnaDestroyerMovingTowardAttachmentState
    extends AttachmentState.GenericMovingTowardsAttachmentState {
        protected MRnaDestroyerMovingTowardAttachmentState() {
        }

        public void entered(AttachmentStateMachine attachmentStateMachine) {
            super.entered(attachmentStateMachine);
            attachmentStateMachine.biomolecule.movableByUser.set(false);
        }
    }
}

