/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.common.model.attachmentstatemachines;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.geneexpressionbasics.common.model.AttachmentSite;
import edu.colorado.phet.geneexpressionbasics.common.model.MobileBiomolecule;
import edu.colorado.phet.geneexpressionbasics.common.model.TranscriptionFactor;
import edu.colorado.phet.geneexpressionbasics.common.model.attachmentstatemachines.AttachmentState;
import edu.colorado.phet.geneexpressionbasics.common.model.attachmentstatemachines.AttachmentStateMachine;
import edu.colorado.phet.geneexpressionbasics.common.model.attachmentstatemachines.GenericAttachmentStateMachine;
import edu.colorado.phet.geneexpressionbasics.common.model.motionstrategies.FollowAttachmentSite;
import edu.colorado.phet.geneexpressionbasics.common.model.motionstrategies.MoveDirectlyToDestinationMotionStrategy;
import edu.colorado.phet.geneexpressionbasics.common.model.motionstrategies.WanderInGeneralDirectionMotionStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class TranscriptionFactorAttachmentStateMachine
extends GenericAttachmentStateMachine {
    private static final Random RAND = new Random();
    private double detachFromDnaThreshold = 1.0;

    public TranscriptionFactorAttachmentStateMachine(MobileBiomolecule mobileBiomolecule) {
        super(mobileBiomolecule);
        this.attachedState = new TranscriptionFactorAttachedState();
    }

    protected class TranscriptionFactorAttachedState
    extends AttachmentState.GenericAttachedState {
        protected TranscriptionFactorAttachedState() {
        }

        public void stepInTime(AttachmentStateMachine attachmentStateMachine, double d) {
            assert (attachmentStateMachine.attachmentSite != null);
            assert (attachmentStateMachine.attachmentSite.attachedOrAttachingMolecule.get() == TranscriptionFactorAttachmentStateMachine.this.biomolecule);
            if (RAND.nextDouble() > 1.0 - this.calculateProbabilityOfDetachment(TranscriptionFactorAttachmentStateMachine.this.attachmentSite.getAffinity(), d)) {
                if (RAND.nextDouble() > TranscriptionFactorAttachmentStateMachine.this.detachFromDnaThreshold) {
                    this.detachFromDnaMolecule(attachmentStateMachine);
                } else {
                    List<AttachmentSite> list = TranscriptionFactorAttachmentStateMachine.this.biomolecule.getModel().getDnaMolecule().getAdjacentAttachmentSites((TranscriptionFactor)TranscriptionFactorAttachmentStateMachine.this.biomolecule, attachmentStateMachine.attachmentSite);
                    for (AttachmentSite attachmentSite : new ArrayList<AttachmentSite>(list)) {
                        if (TranscriptionFactorAttachmentStateMachine.this.biomolecule.motionBoundsProperty.get().testIfInMotionBounds(TranscriptionFactorAttachmentStateMachine.this.biomolecule.getShape(), attachmentSite.locationProperty.get())) continue;
                        list.remove(attachmentSite);
                    }
                    Collections.shuffle(list);
                    if (list.size() == 0) {
                        this.detachFromDnaMolecule(attachmentStateMachine);
                    } else {
                        TranscriptionFactorAttachmentStateMachine.this.attachmentSite.attachedOrAttachingMolecule.set(null);
                        TranscriptionFactorAttachmentStateMachine.this.attachmentSite = list.get(0);
                        assert (TranscriptionFactorAttachmentStateMachine.this.attachmentSite.attachedOrAttachingMolecule.get() == null);
                        TranscriptionFactorAttachmentStateMachine.this.attachmentSite.attachedOrAttachingMolecule.set(TranscriptionFactorAttachmentStateMachine.this.biomolecule);
                        TranscriptionFactorAttachmentStateMachine.this.setState(TranscriptionFactorAttachmentStateMachine.this.movingTowardsAttachmentState);
                        TranscriptionFactorAttachmentStateMachine.this.biomolecule.setMotionStrategy(new MoveDirectlyToDestinationMotionStrategy(TranscriptionFactorAttachmentStateMachine.this.attachmentSite.locationProperty, TranscriptionFactorAttachmentStateMachine.this.biomolecule.motionBoundsProperty, new Vector2D(0.0, 0.0), 200.0));
                        TranscriptionFactorAttachmentStateMachine.this.detachFromDnaThreshold = TranscriptionFactorAttachmentStateMachine.this.detachFromDnaThreshold * Math.pow(0.5, 0.15);
                    }
                }
            }
        }

        public void entered(AttachmentStateMachine attachmentStateMachine) {
            attachmentStateMachine.biomolecule.setMotionStrategy(new FollowAttachmentSite(attachmentStateMachine.attachmentSite));
            attachmentStateMachine.biomolecule.attachedToDna.set(true);
        }

        private void detachFromDnaMolecule(AttachmentStateMachine attachmentStateMachine) {
            attachmentStateMachine.attachmentSite.attachedOrAttachingMolecule.set(null);
            attachmentStateMachine.attachmentSite = null;
            attachmentStateMachine.setState(TranscriptionFactorAttachmentStateMachine.this.unattachedButUnavailableState);
            TranscriptionFactorAttachmentStateMachine.this.biomolecule.setMotionStrategy(new WanderInGeneralDirectionMotionStrategy(TranscriptionFactorAttachmentStateMachine.this.biomolecule.getDetachDirection(), TranscriptionFactorAttachmentStateMachine.this.biomolecule.motionBoundsProperty));
            TranscriptionFactorAttachmentStateMachine.this.detachFromDnaThreshold = 1.0;
            attachmentStateMachine.biomolecule.attachedToDna.set(false);
        }

        private double calculateProbabilityOfDetachment(double d, double d2) {
            double d3 = 1.5 * (d / (1.0 - d));
            return 1.0 - Math.exp(-0.693 * d2 / d3);
        }
    }
}

