/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.common.view;

import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.geneexpressionbasics.common.model.MobileBiomolecule;
import edu.colorado.phet.geneexpressionbasics.common.model.RnaPolymerase;
import edu.colorado.phet.geneexpressionbasics.common.view.BiomoleculeDragHandler;
import edu.colorado.phet.geneexpressionbasics.multiplecells.view.ColorChangingCellNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;

public class MobileBiomoleculeNode
extends PPath {
    public MobileBiomoleculeNode(ModelViewTransform modelViewTransform, MobileBiomolecule mobileBiomolecule) {
        this(modelViewTransform, mobileBiomolecule, new BasicStroke(1.0f));
    }

    public MobileBiomoleculeNode(final ModelViewTransform modelViewTransform, final MobileBiomolecule mobileBiomolecule, Stroke stroke) {
        this.addChild(new PhetPPath(stroke, Color.BLACK){
            {
                super(stroke, paint);
                mobileBiomolecule.addShapeChangeObserver(new VoidFunction1<Shape>(){

                    @Override
                    public void apply(Shape shape) {
                        Shape shape2 = MobileBiomoleculeNode.getCenteredShape(modelViewTransform.modelToView(shape));
                        this.setPathTo(shape2);
                        this.setOffset(modelViewTransform.modelToView(mobileBiomolecule.getPosition()).toPoint2D());
                        this.setPaint(MobileBiomoleculeNode.createGradientPaint(shape2, mobileBiomolecule.colorProperty.get()));
                    }
                });
                mobileBiomolecule.colorProperty.addObserver(new VoidFunction1<Color>(){

                    @Override
                    public void apply(Color color) {
                        this.setPaint(MobileBiomoleculeNode.createGradientPaint(MobileBiomoleculeNode.getCenteredShape(modelViewTransform.modelToView(mobileBiomolecule.getShape())), mobileBiomolecule.colorProperty.get()));
                    }
                });
                mobileBiomolecule.existenceStrength.addObserver(new VoidFunction1<Double>(){

                    @Override
                    public void apply(Double d) {
                        assert (d >= 0.0 && d <= 1.0);
                        this.setTransparency((float)Math.min((double)d.floatValue(), 1.0 + mobileBiomolecule.zPosition.get()));
                    }
                });
                mobileBiomolecule.zPosition.addObserver(new VoidFunction1<Double>(){

                    @Override
                    public void apply(Double d) {
                        assert (d >= -1.0 && d <= 0.0);
                        this.setTransparency((float)Math.min(1.0 + d, mobileBiomolecule.existenceStrength.get()));
                        this.setScale(1.0);
                        this.setScale(1.0 + 0.15 * d);
                    }
                });
                mobileBiomolecule.attachedToDna.addObserver(new VoidFunction1<Boolean>(){

                    @Override
                    public void apply(Boolean bl) {
                        if (mobileBiomolecule instanceof RnaPolymerase && bl.booleanValue()) {
                            this.moveToBack();
                        }
                    }
                });
                this.addInputEventListener(new CursorHandler());
                this.addInputEventListener(new BiomoleculeDragHandler(mobileBiomolecule, this, modelViewTransform));
                mobileBiomolecule.movableByUser.addObserver(new VoidFunction1<Boolean>(){

                    @Override
                    public void apply(Boolean bl) {
                        this.setPickable(bl);
                        this.setChildrenPickable(bl);
                    }
                });
            }
        });
        mobileBiomolecule.userControlled.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                MobileBiomoleculeNode.this.moveToFront();
            }
        });
    }

    private static Shape getCenteredShape(Shape shape) {
        double d = shape.getBounds2D().getCenterX();
        double d2 = shape.getBounds2D().getCenterY();
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(-d, -d2);
        return affineTransform.createTransformedShape(shape);
    }

    public static Paint createGradientPaint(Shape shape, Color color) {
        Paint paint = color != ColorChangingCellNode.FLORESCENT_FILL_COLOR ? new GradientPaint((float)shape.getBounds2D().getMinX(), (float)shape.getBounds2D().getCenterY(), ColorUtils.brighterColor(color, 0.8), (float)shape.getBounds2D().getMaxX(), (float)shape.getBounds2D().getCenterY(), ColorUtils.darkerColor(color, 0.3)) : color;
        return paint;
    }
}

