/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.manualgeneexpression.model;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.geneexpressionbasics.common.model.GeneExpressionModel;
import edu.colorado.phet.geneexpressionbasics.common.model.Protein;
import edu.colorado.phet.geneexpressionbasics.manualgeneexpression.model.StubGeneExpressionModel;
import java.awt.Color;
import java.awt.Shape;

public class ProteinA
extends Protein {
    private static final Color BASE_COLOR = new Color(255, 99, 71);

    public ProteinA() {
        this(new StubGeneExpressionModel());
    }

    protected ProteinA(GeneExpressionModel geneExpressionModel) {
        super(geneExpressionModel, ProteinA.createInitialShape(), BASE_COLOR);
    }

    protected Shape getUntranslatedShape(double d) {
        return ProteinA.createShape(d);
    }

    public Protein createInstance() {
        return new ProteinA(this.model);
    }

    public void setAttachmentPointPosition(Vector2D vector2D) {
        this.setPosition(vector2D.getX(), vector2D.getY() + 225.0 * this.getFullSizeProportion());
    }

    private static Shape createInitialShape() {
        return ProteinA.createShape(0.0);
    }

    private static Shape createShape(double d) {
        final double d2 = MathUtil.clamp(0.01, d, 1.0) * 450.0;
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath(0.0, 0.0){
            {
                super(d, d22);
                this.moveTo(-d2 / 2.0, 0.0);
                this.lineTo(0.0, -d2 / 2.0);
                this.lineTo(d2 / 2.0, 0.0);
                this.lineTo(0.0, d2 / 2.0);
                this.lineTo(-d2 / 2.0, 0.0);
                this.closePath();
            }
        };
        return doubleGeneralPath.getGeneralPath();
    }
}

