/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.mrnaproduction.model;

import edu.colorado.phet.common.phetcommon.math.Point3D;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.model.property.ChangeObserver;
import edu.colorado.phet.common.phetcommon.model.property.integerproperty.IntegerProperty;
import edu.colorado.phet.common.phetcommon.util.ObservableList;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.geneexpressionbasics.common.model.DnaMolecule;
import edu.colorado.phet.geneexpressionbasics.common.model.Gene;
import edu.colorado.phet.geneexpressionbasics.common.model.GeneA;
import edu.colorado.phet.geneexpressionbasics.common.model.GeneExpressionModel;
import edu.colorado.phet.geneexpressionbasics.common.model.MessengerRna;
import edu.colorado.phet.geneexpressionbasics.common.model.MobileBiomolecule;
import edu.colorado.phet.geneexpressionbasics.common.model.RnaPolymerase;
import edu.colorado.phet.geneexpressionbasics.common.model.TranscriptionFactor;
import edu.colorado.phet.geneexpressionbasics.common.model.motionstrategies.MotionBounds;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessengerRnaProductionModel
extends GeneExpressionModel
implements Resettable {
    public static final TranscriptionFactor.TranscriptionFactorConfig POSITIVE_TRANSCRIPTION_FACTOR_CONFIG = TranscriptionFactor.TRANSCRIPTION_FACTOR_CONFIG_GENE_1_POS;
    public static final TranscriptionFactor.TranscriptionFactorConfig NEGATIVE_TRANSCRIPTION_FACTOR_CONFIG = TranscriptionFactor.TRANSCRIPTION_FACTOR_CONFIG_GENE_1_NEG;
    private static final Random RAND = new Random();
    private final DnaMolecule dnaMolecule = new DnaMolecule(this, 500, -8500.0, true);
    private final Gene gene;
    public final ObservableList<MobileBiomolecule> mobileBiomoleculeList = new ObservableList();
    public final ObservableList<MessengerRna> messengerRnaList = new ObservableList();
    public final IntegerProperty positiveTranscriptionFactorCount = new IntegerProperty(0){
        {
            this.addObserver(new VoidFunction1<Integer>(){

                @Override
                public void apply(Integer n) {
                    MessengerRnaProductionModel.this.setTranscriptionFactorCount(TranscriptionFactor.TRANSCRIPTION_FACTOR_CONFIG_GENE_1_POS, n);
                }
            });
        }
    };
    public final IntegerProperty negativeTranscriptionFactorCount = new IntegerProperty(0){
        {
            this.addObserver(new VoidFunction1<Integer>(){

                @Override
                public void apply(Integer n) {
                    MessengerRnaProductionModel.this.setTranscriptionFactorCount(TranscriptionFactor.TRANSCRIPTION_FACTOR_CONFIG_GENE_1_NEG, n);
                }
            });
        }
    };
    public final MotionBounds moleculeMotionBounds;
    private final ConstantDtClock clock = new ConstantDtClock(30.0);
    private final Rectangle2D aboveDnaPolymeraseReturnBounds;
    private final Rectangle2D belowDnaPolymeraseReturnBounds;

    public MessengerRnaProductionModel() {
        this.clock.addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                MessengerRnaProductionModel.this.stepInTime(clockEvent.getSimulationTimeChange());
            }
        });
        this.gene = new GeneA(this.dnaMolecule, (int)Math.round(225.0));
        this.dnaMolecule.addGene(this.gene);
        double d = -1200.0;
        double d2 = 1100.0;
        double d3 = this.gene.getStartX() - 1300.0;
        double d4 = this.gene.getEndX() + 400.0;
        Area area = new Area(new Rectangle2D.Double(d3, d, d4 - d3, d2 - d));
        this.moleculeMotionBounds = new MotionBounds(area);
        Rectangle2D rectangle2D = new RnaPolymerase().getShape().getBounds2D();
        double d5 = this.dnaMolecule.getBasePairXOffsetByIndex(this.dnaMolecule.getGenes().get(0).getTranscribedRegion().getMin()) + (RAND.nextDouble() - 0.5) * 2000.0;
        double d6 = rectangle2D.getHeight() * 1.2;
        double d7 = rectangle2D.getWidth() * 4.0;
        this.aboveDnaPolymeraseReturnBounds = new Rectangle2D.Double(d5 - rectangle2D.getWidth() * 2.0, 0.0 + rectangle2D.getHeight(), d7, d6);
        this.belowDnaPolymeraseReturnBounds = new Rectangle2D.Double(d5 - rectangle2D.getWidth() * 2.0, 0.0 - rectangle2D.getHeight() - d6, d7, rectangle2D.getHeight() * 1.2);
        this.reset();
    }

    public ConstantDtClock getClock() {
        return this.clock;
    }

    @Override
    public DnaMolecule getDnaMolecule() {
        return this.dnaMolecule;
    }

    @Override
    public void addMobileBiomolecule(final MobileBiomolecule mobileBiomolecule) {
        this.mobileBiomoleculeList.add(mobileBiomolecule);
        mobileBiomolecule.setMotionBounds(this.moleculeMotionBounds);
        mobileBiomolecule.userControlled.addObserver(new ChangeObserver<Boolean>(){

            @Override
            public void update(Boolean bl, Boolean bl2) {
                if (bl.booleanValue()) {
                    MessengerRnaProductionModel.this.dnaMolecule.activateHints(mobileBiomolecule);
                } else {
                    MessengerRnaProductionModel.this.dnaMolecule.deactivateAllHints();
                }
            }
        });
        mobileBiomolecule.existenceStrength.addObserver(new VoidFunction1<Double>(){

            @Override
            public void apply(Double d) {
                if (d == 0.0) {
                    MessengerRnaProductionModel.this.removeMobileBiomolecule(mobileBiomolecule);
                    mobileBiomolecule.existenceStrength.removeObserver(this);
                }
            }
        });
    }

    @Override
    public List<MobileBiomolecule> getOverlappingBiomolecules(Shape shape) {
        ArrayList<MobileBiomolecule> arrayList = new ArrayList<MobileBiomolecule>();
        Rectangle2D rectangle2D = shape.getBounds2D();
        for (MobileBiomolecule mobileBiomolecule : this.mobileBiomoleculeList) {
            if (!mobileBiomolecule.getShape().getBounds2D().intersects(rectangle2D)) continue;
            Area area = new Area(shape);
            Area area2 = new Area(mobileBiomolecule.getShape());
            area2.intersect(area);
            if (area2.isEmpty()) continue;
            arrayList.add(mobileBiomolecule);
        }
        return arrayList;
    }

    public void removeMobileBiomolecule(MobileBiomolecule mobileBiomolecule) {
        this.mobileBiomoleculeList.remove(mobileBiomolecule);
    }

    @Override
    public void addMessengerRna(final MessengerRna messengerRna) {
        this.messengerRnaList.add(messengerRna);
        messengerRna.setFadeAwayWhenFormed(true);
        messengerRna.existenceStrength.addObserver(new VoidFunction1<Double>(){

            @Override
            public void apply(Double d) {
                if (d <= 0.0) {
                    MessengerRnaProductionModel.this.messengerRnaList.remove(messengerRna);
                    messengerRna.existenceStrength.removeObserver(this);
                }
            }
        });
    }

    @Override
    public void removeMessengerRna(MessengerRna messengerRna) {
        this.messengerRnaList.remove(messengerRna);
    }

    @Override
    public List<MessengerRna> getMessengerRnaList() {
        return this.messengerRnaList;
    }

    @Override
    public void reset() {
        this.positiveTranscriptionFactorCount.reset();
        this.negativeTranscriptionFactorCount.reset();
        this.mobileBiomoleculeList.clear();
        this.messengerRnaList.clear();
        this.dnaMolecule.reset();
        this.gene.getPolymeraseAffinityProperty().reset();
        this.gene.getTranscriptionFactorAffinityProperty(POSITIVE_TRANSCRIPTION_FACTOR_CONFIG).reset();
        this.gene.getTranscriptionFactorAffinityProperty(NEGATIVE_TRANSCRIPTION_FACTOR_CONFIG).reset();
        for (int i = 0; i < 7; ++i) {
            RnaPolymerase rnaPolymerase = new RnaPolymerase(this, new Vector2D(0.0, 0.0));
            rnaPolymerase.setPosition3D(this.generateInitialLocation3D(rnaPolymerase));
            rnaPolymerase.set3DMotionEnabled(true);
            rnaPolymerase.setRecycleMode(true);
            rnaPolymerase.addRecycleReturnZone(this.aboveDnaPolymeraseReturnBounds);
            rnaPolymerase.addRecycleReturnZone(this.belowDnaPolymeraseReturnBounds);
            this.addMobileBiomolecule(rnaPolymerase);
        }
    }

    private void stepInTime(double d) {
        for (MobileBiomolecule mobileBiomolecule : new ArrayList<MobileBiomolecule>(this.mobileBiomoleculeList)) {
            mobileBiomolecule.stepInTime(d);
        }
        for (MessengerRna messengerRna : new ArrayList<MessengerRna>(this.messengerRnaList)) {
            messengerRna.stepInTime(d);
        }
        this.dnaMolecule.stepInTime(d);
    }

    private Point3D generateInitialLocation3D(MobileBiomolecule mobileBiomolecule) {
        double d = this.moleculeMotionBounds.getBounds().getBounds2D().getMinX() + mobileBiomolecule.getShape().getBounds2D().getWidth() / 2.0;
        double d2 = this.moleculeMotionBounds.getBounds().getBounds2D().getMinY() + mobileBiomolecule.getShape().getBounds2D().getHeight() / 2.0;
        double d3 = this.moleculeMotionBounds.getBounds().getBounds2D().getMaxX() - mobileBiomolecule.getShape().getBounds2D().getWidth() / 2.0;
        double d4 = this.moleculeMotionBounds.getBounds().getBounds2D().getMaxY() - mobileBiomolecule.getShape().getBounds2D().getHeight() / 2.0;
        double d5 = d + RAND.nextDouble() * (d3 - d);
        double d6 = d2 + RAND.nextDouble() * (d4 - d2);
        double d7 = -RAND.nextDouble();
        return new Point3D.Double(d5, d6, d7);
    }

    private void setTranscriptionFactorCount(TranscriptionFactor.TranscriptionFactorConfig transcriptionFactorConfig, int n) {
        block3: {
            int n2;
            block4: {
                n2 = 0;
                for (MobileBiomolecule mobileBiomolecule : this.mobileBiomoleculeList) {
                    if (!(mobileBiomolecule instanceof TranscriptionFactor) || !((TranscriptionFactor)mobileBiomolecule).getConfig().equals(transcriptionFactorConfig)) continue;
                    ++n2;
                }
                if (n <= n2) break block4;
                for (int i = n2; i < n; ++i) {
                    MobileBiomolecule mobileBiomolecule;
                    mobileBiomolecule = new TranscriptionFactor((GeneExpressionModel)this, transcriptionFactorConfig, new Vector2D(0.0, 0.0));
                    mobileBiomolecule.setPosition3D(this.generateInitialLocation3D(mobileBiomolecule));
                    mobileBiomolecule.set3DMotionEnabled(true);
                    this.addMobileBiomolecule(mobileBiomolecule);
                }
                break block3;
            }
            if (n >= n2) break block3;
            for (MobileBiomolecule mobileBiomolecule : new ArrayList<MobileBiomolecule>(this.mobileBiomoleculeList)) {
                if (!(mobileBiomolecule instanceof TranscriptionFactor) || !((TranscriptionFactor)mobileBiomolecule).getConfig().equals(transcriptionFactorConfig)) continue;
                mobileBiomolecule.forceDetach();
                this.removeMobileBiomolecule(mobileBiomolecule);
                if (--n2 != n) continue;
                break;
            }
        }
    }
}

