/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.mrnaproduction.view;

import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.model.property.doubleproperty.DoubleProperty;
import edu.colorado.phet.common.phetcommon.model.property.integerproperty.IntegerProperty;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponent;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.ControlPanelNode;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.common.piccolophet.nodes.layout.VBox;
import edu.colorado.phet.geneexpressionbasics.GeneExpressionBasicsResources;
import edu.colorado.phet.geneexpressionbasics.GeneExpressionBasicsSimSharing;
import edu.colorado.phet.geneexpressionbasics.common.model.DnaMolecule;
import edu.colorado.phet.geneexpressionbasics.common.model.TranscriptionFactor;
import edu.colorado.phet.geneexpressionbasics.common.view.DnaMoleculeNode;
import edu.colorado.phet.geneexpressionbasics.common.view.MobileBiomoleculeNode;
import edu.colorado.phet.geneexpressionbasics.manualgeneexpression.model.StubGeneExpressionModel;
import edu.colorado.phet.geneexpressionbasics.mrnaproduction.model.MessengerRnaProductionModel;
import edu.colorado.phet.geneexpressionbasics.mrnaproduction.view.AffinityController;
import edu.colorado.phet.geneexpressionbasics.mrnaproduction.view.HorizontalSliderWithLabelsAtEnds;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.geom.Point2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranscriptionFactorControlPanel
extends PNode {
    private static final ModelViewTransform TRANSCRIPTION_FACTOR_MVT = ModelViewTransform.createSinglePointScaleInvertedYMapping(new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 0.0), 0.08);
    private static final ModelViewTransform DNA_MVT = ModelViewTransform.createSinglePointScaleInvertedYMapping(new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 0.0), 0.1);

    public TranscriptionFactorControlPanel(MessengerRnaProductionModel messengerRnaProductionModel, TranscriptionFactor.TranscriptionFactorConfig transcriptionFactorConfig, Property<Double> property) {
        IntegerProperty integerProperty;
        String string;
        if (transcriptionFactorConfig.isPositive) {
            transcriptionFactorConfig = MessengerRnaProductionModel.POSITIVE_TRANSCRIPTION_FACTOR_CONFIG;
            string = GeneExpressionBasicsResources.Strings.POSITIVE_TRANSCRIPTION_FACTOR_HTML;
            integerProperty = messengerRnaProductionModel.positiveTranscriptionFactorCount;
        } else {
            transcriptionFactorConfig = MessengerRnaProductionModel.NEGATIVE_TRANSCRIPTION_FACTOR_CONFIG;
            string = GeneExpressionBasicsResources.Strings.NEGATIVE_TRANSCRIPTION_FACTOR_HTML;
            integerProperty = messengerRnaProductionModel.negativeTranscriptionFactorCount;
        }
        HTMLNode hTMLNode = new HTMLNode(string){
            {
                this.setFont(new PhetFont(16, true));
            }
        };
        MobileBiomoleculeNode mobileBiomoleculeNode = new MobileBiomoleculeNode(TRANSCRIPTION_FACTOR_MVT, new TranscriptionFactor(transcriptionFactorConfig));
        DnaMoleculeNode dnaMoleculeNode = new DnaMoleculeNode(new DnaMolecule(11, 0.0, true), DNA_MVT, 2.0f, false);
        VBox vBox = new VBox(20.0, hTMLNode, new ConcentrationController(transcriptionFactorConfig, integerProperty, 0, 8), new AffinityController(mobileBiomoleculeNode, dnaMoleculeNode, property));
        this.addChild(new ControlPanelNode((PNode)vBox));
    }

    private static class ConcentrationController
    extends PNode {
        private ConcentrationController(TranscriptionFactor.TranscriptionFactorConfig transcriptionFactorConfig, IntegerProperty integerProperty, int n, int n2) {
            PText pText = new PText(GeneExpressionBasicsResources.Strings.CONCENTRATIONS){
                {
                    this.setFont(new PhetFont(14, false));
                }
            };
            MobileBiomoleculeNode mobileBiomoleculeNode = new MobileBiomoleculeNode(TRANSCRIPTION_FACTOR_MVT, new TranscriptionFactor(new StubGeneExpressionModel(), transcriptionFactorConfig));
            mobileBiomoleculeNode.setPickable(false);
            mobileBiomoleculeNode.setChildrenPickable(false);
            this.addChild(new VBox(5.0, pText, mobileBiomoleculeNode, new HorizontalSliderWithLabelsAtEnds(new UserComponent(GeneExpressionBasicsSimSharing.UserComponents.transcriptionFactorLevelSlider), new IntegerToDoublePropertyWrapper(integerProperty), n, n2, GeneExpressionBasicsResources.Strings.NONE, GeneExpressionBasicsResources.Strings.LOTS)));
        }
    }

    private static class IntegerToDoublePropertyWrapper
    extends DoubleProperty {
        private IntegerToDoublePropertyWrapper(final IntegerProperty integerProperty) {
            super((double)((Integer)integerProperty.get()));
            integerProperty.addObserver(new VoidFunction1<Integer>(){

                @Override
                public void apply(Integer n) {
                    IntegerToDoublePropertyWrapper.this.set(Double.valueOf(n.intValue()));
                }
            });
            this.addObserver(new VoidFunction1<Double>(){

                @Override
                public void apply(Double d) {
                    integerProperty.set((int)Math.round(d));
                }
            });
        }
    }
}

