/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.multiplecells.view;

import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.ControlPanelNode;
import edu.colorado.phet.common.piccolophet.nodes.HTMLImageButtonNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.PhetPText;
import edu.colorado.phet.common.piccolophet.nodes.ResetAllButtonNode;
import edu.colorado.phet.common.piccolophet.nodes.layout.VBox;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.FloatingClockControlNode;
import edu.colorado.phet.geneexpressionbasics.GeneExpressionBasicsResources;
import edu.colorado.phet.geneexpressionbasics.GeneExpressionBasicsSimSharing;
import edu.colorado.phet.geneexpressionbasics.multiplecells.model.Cell;
import edu.colorado.phet.geneexpressionbasics.multiplecells.model.MultipleCellsModel;
import edu.colorado.phet.geneexpressionbasics.multiplecells.view.AffinityControlPanel;
import edu.colorado.phet.geneexpressionbasics.multiplecells.view.CollapsibleControlPanel;
import edu.colorado.phet.geneexpressionbasics.multiplecells.view.ColorChangingCellNode;
import edu.colorado.phet.geneexpressionbasics.multiplecells.view.ConcentrationsControlPanel;
import edu.colorado.phet.geneexpressionbasics.multiplecells.view.DegradationControlPanel;
import edu.colorado.phet.geneexpressionbasics.multiplecells.view.FluorescentCellsPictureDialog;
import edu.colorado.phet.geneexpressionbasics.multiplecells.view.IntegerHSliderNode;
import edu.colorado.phet.geneexpressionbasics.multiplecells.view.ProteinLevelChartNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Paint;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class MultipleCellsCanvas
extends PhetPCanvas
implements Resettable {
    private static final Dimension2D STAGE_SIZE = new PDimension(1008.0, 679.0);
    private final PPath cellBoundingBox = new PhetPPath(new BasicStroke(5.0f), (Paint)Color.red);
    private final ModelViewTransform mvt;
    private final MultipleCellsModel model;
    private final BooleanProperty clockRunning = new BooleanProperty(false);
    private final PNode localWorldRootNode = new PNode();
    private final ProteinLevelChartNode proteinLevelChartNode;
    private final CollapsibleControlPanel concentrationControlPanel;
    private final CollapsibleControlPanel degradationParameterController;
    private final CollapsibleControlPanel affinityControlPanel;

    public MultipleCellsCanvas(final MultipleCellsModel multipleCellsModel, final Frame frame) {
        this.model = multipleCellsModel;
        this.setWorldTransformStrategy(new PhetPCanvas.CenteredStage(this, STAGE_SIZE));
        this.mvt = ModelViewTransform.createSinglePointScaleInvertedYMapping(new Point2D.Double(0.0, 0.0), new Point((int)Math.round(STAGE_SIZE.getWidth() * 0.475), (int)Math.round(STAGE_SIZE.getHeight() * 0.4)), 1.0E8);
        this.setBackground(Color.BLACK);
        this.addWorldChild(this.localWorldRootNode);
        multipleCellsModel.visibleCellList.addElementAddedObserver(new VoidFunction1<Cell>(){

            @Override
            public void apply(final Cell cell) {
                final ColorChangingCellNode colorChangingCellNode = new ColorChangingCellNode(cell, MultipleCellsCanvas.this.mvt);
                MultipleCellsCanvas.this.localWorldRootNode.addChild(colorChangingCellNode);
                multipleCellsModel.visibleCellList.addElementRemovedObserver(new VoidFunction1<Cell>(){

                    @Override
                    public void apply(Cell cell2) {
                        if (cell2 == cell) {
                            MultipleCellsCanvas.this.localWorldRootNode.removeChild(colorChangingCellNode);
                            multipleCellsModel.visibleCellList.removeElementRemovedObserver(this);
                        }
                    }
                });
            }
        });
        this.proteinLevelChartNode = new ProteinLevelChartNode(multipleCellsModel.averageProteinLevel, multipleCellsModel.getClock());
        this.addWorldChild(this.proteinLevelChartNode);
        CellNumberController cellNumberController = new CellNumberController(multipleCellsModel);
        this.addWorldChild(cellNumberController);
        this.concentrationControlPanel = new ConcentrationsControlPanel(multipleCellsModel);
        this.addWorldChild(this.concentrationControlPanel);
        this.affinityControlPanel = new AffinityControlPanel(multipleCellsModel);
        this.addWorldChild(this.affinityControlPanel);
        this.degradationParameterController = new DegradationControlPanel(multipleCellsModel);
        this.addWorldChild(this.degradationParameterController);
        final ConstantDtClock constantDtClock = (ConstantDtClock)multipleCellsModel.getClock();
        this.clockRunning.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                constantDtClock.setRunning(bl);
            }
        });
        final FloatingClockControlNode floatingClockControlNode = new FloatingClockControlNode(this.clockRunning, null, multipleCellsModel.getClock(), null, new Property<Color>(Color.white));
        multipleCellsModel.getClock().addClockListener(new ClockAdapter(){

            public void clockStarted(ClockEvent clockEvent) {
                MultipleCellsCanvas.this.clockRunning.set(true);
            }
        });
        final ResetAllButtonNode resetAllButtonNode = new ResetAllButtonNode(new Resettable[]{multipleCellsModel, this}, this, 18, Color.BLACK, new Color(255, 153, 0)){
            {
                super(resettableArray, component, n, color, color2);
                this.setConfirmationEnabled(false);
                this.setOffset(floatingClockControlNode.getFullBoundsReference().getCenterX() - this.getFullBoundsReference().getWidth() / 2.0, MultipleCellsCanvas.this.concentrationControlPanel.getFullBoundsReference().getMaxY() + 30.0);
            }
        };
        HTMLImageButtonNode hTMLImageButtonNode = new HTMLImageButtonNode(GeneExpressionBasicsResources.Strings.SHOW_REAL_CELLS, new PhetFont(18), Color.YELLOW){
            {
                super(string, phetFont, color);
                this.centerFullBoundsOnPoint(MultipleCellsCanvas.this.concentrationControlPanel.getFullBoundsReference().getCenterX(), resetAllButtonNode.getFullBoundsReference().getCenterY());
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        FluorescentCellsPictureDialog fluorescentCellsPictureDialog = new FluorescentCellsPictureDialog(frame);
                        SwingUtils.centerInParent(fluorescentCellsPictureDialog);
                        fluorescentCellsPictureDialog.setVisible(true);
                    }
                });
            }
        };
        VBox vBox = new VBox(20.0, floatingClockControlNode, resetAllButtonNode, hTMLImageButtonNode);
        this.addWorldChild(vBox);
        multipleCellsModel.visibleCellList.addElementAddedObserver(new VoidFunction1<Cell>(){

            @Override
            public void apply(Cell cell) {
                MultipleCellsCanvas.this.setZoomToSeeAllCells();
            }
        });
        multipleCellsModel.visibleCellList.addElementRemovedObserver(new VoidFunction1<Cell>(){

            @Override
            public void apply(Cell cell) {
                MultipleCellsCanvas.this.setZoomToSeeAllCells();
            }
        });
        double d = Math.max(Math.max(this.concentrationControlPanel.getFullBoundsReference().width, this.affinityControlPanel.getFullBoundsReference().width), this.degradationParameterController.getFullBoundsReference().width);
        this.concentrationControlPanel.setMinWidth(d);
        this.affinityControlPanel.setMinWidth(d);
        this.degradationParameterController.setMinWidth(d);
        this.proteinLevelChartNode.setOffset(this.mvt.modelToViewX(0.0) - this.proteinLevelChartNode.getFullBoundsReference().width / 2.0, STAGE_SIZE.getHeight() - this.proteinLevelChartNode.getFullBoundsReference().height - 10.0);
        ((PNode)vBox).setOffset(this.proteinLevelChartNode.getFullBoundsReference().getMinX() / 2.0 - vBox.getFullBoundsReference().width / 2.0, this.proteinLevelChartNode.getFullBoundsReference().getCenterY() - vBox.getFullBoundsReference().height / 2.0);
        this.concentrationControlPanel.setOffset(STAGE_SIZE.getWidth() - this.concentrationControlPanel.getFullBoundsReference().width - 10.0, 20.0);
        this.affinityControlPanel.setOffset(this.concentrationControlPanel.getFullBoundsReference().getMinX(), this.concentrationControlPanel.getFullBoundsWhenOpen().getMaxY() + 10.0);
        this.degradationParameterController.setOffset(this.affinityControlPanel.getFullBoundsReference().getMinX(), this.affinityControlPanel.getFullBoundsWhenOpen().getMaxY() + 10.0);
        cellNumberController.setOffset(this.mvt.modelToViewX(0.0) - cellNumberController.getFullBoundsReference().width / 2.0, 10.0);
    }

    private void setZoomToSeeAllCells() {
        this.localWorldRootNode.setTransform(new AffineTransform());
        Rectangle2D rectangle2D = this.model.getVisibleCellCollectionBounds();
        if (rectangle2D.getWidth() > 0.0 && rectangle2D.getHeight() > 0.0) {
            double d = Math.min(STAGE_SIZE.getWidth() * 0.75 / this.mvt.modelToViewDeltaX(rectangle2D.getWidth()), 1.0);
            double d2 = Math.min(STAGE_SIZE.getHeight() * 0.4 / Math.abs(this.mvt.modelToViewDeltaY(rectangle2D.getHeight())), 1.0);
            this.localWorldRootNode.scaleAboutPoint(Math.min(d, d2), this.mvt.modelToView(new Point2D.Double(0.0, 0.0)));
        }
        this.cellBoundingBox.setPathTo(this.mvt.modelToView(this.model.getVisibleCellCollectionBounds()));
    }

    public void reset() {
        this.proteinLevelChartNode.clear();
        this.concentrationControlPanel.setOpen(false);
        this.affinityControlPanel.setOpen(false);
        this.degradationParameterController.setOpen(false);
        this.clockRunning.set(true);
    }

    private static class CellNumberController
    extends PNode {
        private CellNumberController(MultipleCellsModel multipleCellsModel) {
            IntegerHSliderNode integerHSliderNode = new IntegerHSliderNode(GeneExpressionBasicsSimSharing.UserComponents.numberOfCellsSlider, 1, 90, 4.0, 100.0, multipleCellsModel.numberOfVisibleCells);
            integerHSliderNode.addLabel(1.0, new PLabel(GeneExpressionBasicsResources.Strings.ONE, 14));
            integerHSliderNode.addLabel(90.0, new PLabel(GeneExpressionBasicsResources.Strings.MANY, 14));
            ControlPanelNode controlPanelNode = new ControlPanelNode((PNode)new VBox(new PhetPText(GeneExpressionBasicsResources.Strings.CELLS, new PhetFont(16, true)), integerHSliderNode), new Color(245, 205, 245));
            this.addChild(controlPanelNode);
        }
    }

    private static class PLabel
    extends PText {
        private PLabel(String string, int n) {
            this(string, n, false);
        }

        private PLabel(String string, int n, boolean bl) {
            super(string);
            this.setFont(new PhetFont(n, bl));
        }
    }
}

