/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.multiplecells.view;

import edu.colorado.phet.common.jfreechartphet.piccolo.JFreeChartNode;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.IntegerRange;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.ControlPanelNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.kit.ZeroOffsetNode;
import edu.colorado.phet.common.piccolophet.nodes.layout.VBox;
import edu.colorado.phet.geneexpressionbasics.GeneExpressionBasicsResources;
import edu.colorado.phet.geneexpressionbasics.multiplecells.view.ColorChangingCellNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.BasicStroke;
import java.awt.GradientPaint;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProteinLevelChartNode
extends PNode {
    private static final Dimension2D SIZE = new PDimension(400.0, 200.0);
    private static final IntegerRange PROTEIN_LEVEL_RANGE = new IntegerRange(0, 170);
    private final XYSeries dataSeries = new XYSeries((Comparable)((Object)"0"));
    private double timeOffset = 0.0;

    public ProteinLevelChartNode(final Property<Double> property, final IClock iClock) {
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection(this.dataSeries);
        JFreeChart jFreeChart = ProteinLevelChartNode.createXYLineChart(GeneExpressionBasicsResources.Strings.AVERAGE_PROTEIN_LEVEL_VS_TIME, GeneExpressionBasicsResources.Strings.TIME, null, xYSeriesCollection, PlotOrientation.VERTICAL);
        NumberAxis numberAxis = new NumberAxis(MessageFormat.format(GeneExpressionBasicsResources.Strings.PATTERN__0VALUE__1UNITS, GeneExpressionBasicsResources.Strings.TIME, GeneExpressionBasicsResources.Strings.UNITS__S));
        numberAxis.setRange(0.0, 30.0);
        numberAxis.setNumberFormatOverride(new DecimalFormat("##"));
        numberAxis.setLabelFont(new PhetFont(12));
        jFreeChart.getXYPlot().setDomainAxis(numberAxis);
        NumberAxis numberAxis2 = new NumberAxis();
        numberAxis2.setRange(PROTEIN_LEVEL_RANGE.getMin(), PROTEIN_LEVEL_RANGE.getMax());
        numberAxis2.setTickLabelsVisible(false);
        numberAxis2.setTickMarksVisible(false);
        jFreeChart.getXYPlot().setRangeAxis(numberAxis2);
        JFreeChartNode jFreeChartNode = new JFreeChartNode(jFreeChart, false);
        jFreeChartNode.setBounds(0.0, 0.0, SIZE.getWidth(), SIZE.getHeight());
        jFreeChartNode.updateChartRenderingInfo();
        YAxisLabel yAxisLabel = new YAxisLabel(jFreeChartNode.getFullBoundsReference().height * 0.65);
        yAxisLabel.setOffset(0.0, 29.0);
        PNode pNode = new PNode();
        pNode.addChild(yAxisLabel);
        jFreeChartNode.setOffset(yAxisLabel.getFullBoundsReference().width, 0.0);
        pNode.addChild(jFreeChartNode);
        this.addChild(new ControlPanelNode(pNode));
        iClock.addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                if (iClock.getSimulationTime() - ProteinLevelChartNode.this.timeOffset > 30.0) {
                    ProteinLevelChartNode.this.clear();
                }
                if (ProteinLevelChartNode.this.dataSeries.getItemCount() == 0) {
                    ProteinLevelChartNode.this.timeOffset = iClock.getSimulationTime();
                }
                ProteinLevelChartNode.this.dataSeries.add(iClock.getSimulationTime() - ProteinLevelChartNode.this.timeOffset, (Number)property.get());
            }
        });
    }

    private static JFreeChart createXYLineChart(String string, String string2, String string3, XYDataset xYDataset, PlotOrientation plotOrientation) {
        if (plotOrientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        JFreeChart jFreeChart = ChartFactory.createXYLineChart(string, string2, string3, xYDataset, PlotOrientation.VERTICAL, false, false, false);
        XYPlot xYPlot = jFreeChart.getXYPlot();
        XYItemRenderer xYItemRenderer = xYPlot.getRenderer();
        xYItemRenderer.setStroke(new BasicStroke(2.0f, 1, 2));
        return jFreeChart;
    }

    public void clear() {
        this.dataSeries.clear();
    }

    public static class YAxisLabel
    extends PNode {
        public YAxisLabel(double d) {
            PText pText = new PText(GeneExpressionBasicsResources.Strings.LOTS);
            pText.setFont(new PhetFont(12));
            PText pText2 = new PText(GeneExpressionBasicsResources.Strings.NONE);
            pText2.setFont(new PhetFont(12));
            PhetPPath phetPPath = new PhetPPath(new Rectangle2D.Double(0.0, 0.0, Math.max(pText.getFullBoundsReference().width, pText2.getFullBoundsReference().width) * 1.1, d - pText.getFullBoundsReference().height / 2.0 - pText2.getFullBoundsReference().height / 2.0));
            phetPPath.setStroke(null);
            VBox vBox = new VBox(0.0, pText, phetPPath, pText2);
            PhetPPath phetPPath2 = new PhetPPath(new Rectangle2D.Double(0.0, 0.0, 20.0, d));
            phetPPath2.setStroke(new BasicStroke(1.0f));
            phetPPath2.setPaint(new GradientPaint(0.0f, (float)d, ColorChangingCellNode.NOMINAL_FILL_COLOR, 0.0f, 0.0f, ColorChangingCellNode.FLORESCENT_FILL_COLOR));
            ZeroOffsetNode zeroOffsetNode = new ZeroOffsetNode((PNode)new PText(GeneExpressionBasicsResources.Strings.AVERAGE_PROTEIN_LEVEL){
                {
                    this.setFont(new PhetFont(14));
                    this.rotate(-1.5707963267948966);
                }
            });
            zeroOffsetNode.setOffset(0.0, d / 2.0 - zeroOffsetNode.getFullBoundsReference().height / 2.0);
            this.addChild(zeroOffsetNode);
            ((PNode)vBox).setOffset(zeroOffsetNode.getFullBoundsReference().getMaxX(), d / 2.0 - vBox.getFullBoundsReference().height / 2.0);
            this.addChild(vBox);
            phetPPath2.setOffset(vBox.getFullBoundsReference().getMaxX() + 3.0, 0.0);
            this.addChild(phetPPath2);
        }
    }
}

