/* Vamos a generar, mediante JavaScript, esta estructura HTML al final del <body>
	<div id="estadistica" class="stat">
		<div id="estadistica2" class="stat">
			<input id="boton" type="button" value="Ver estadísticas">
		</div>
	</div>
*/

// Creamos un nuevo <div> al final del body de la página
const nuevoDiv1 = document.createElement("div");
// Asignamos id al nuevo div
nuevoDiv1.id = "estadistica";
// Lo asignamos a la clase stat.
nuevoDiv1.setAttribute("class", "stat");

// Creamos un nuevo <div> dentro del div anterior
const nuevoDiv2 = document.createElement("div");
// Asignamos id al nuevo div2
nuevoDiv2.id = "estadistica2";
// Lo asignamos también a la clase stat.
nuevoDiv2.setAttribute("class", "stat");

// Creamos ahora un elemento input de tipo botón.
const btn = document.createElement("input");
// Establecemos los atributos del input para que sea un botón
btn.setAttribute("type", "button");
btn.setAttribute("value", "Ver estadísticas");
btn.setAttribute("id", "boton");
// Le asociamos la función Stat() que se ejecutará al ser pulsado.
btn.addEventListener('click', Stat);

// Añadimos el nuevo botón al div con id "estadistica2"
nuevoDiv2.appendChild(btn);
// Añadimos el nuevo div2 al elemento div1 
nuevoDiv1.appendChild(nuevoDiv2);
// Añadimos el nuevo div1 al elemento body
document.querySelector("body").appendChild(nuevoDiv1);

// La variable nP nos permitirá saber si ya se creó el párrafo y así evitar que se duplique.
let nP = false;

/* Creamos la constante que se refiera al objeto <div> contenedor del nuevo párrafo.
	La creamos fuera de la función para que sea una variable global dado que haremos
	referencia a ella en distintas ocasiones */
const contenedor = document.querySelector("div.stat");

// Definimos la función que genera los cálculos de número de elementos HTML.
function Stat() {
	// Si el nuevo párrafo aún no ha sido creado...
	if (nP === false) {
		// Definimos la matriz o array que almacenará todos los elementos <div> existentes en el DOM.
		let div = document.querySelectorAll('div');
		// Calculamos el número de celdas de dicha matriz.
		let nd = div.length;
		// Establecemos el texto a mostrar según el número de celdas.
		let ndt="";
		if (nd === 0) { 
			ndt = " ningún elemento"; 
		} else if (nd === 1) {
			ndt = "1 elemento";
		} else {
			ndt = nd.toString() + " elementos";
		}
		ndt += " &lt;div&gt;,<br> &nbsp;&nbsp;&nbsp;&nbsp;- ";

		// Definimos la matriz o array que almacenará todos los párrafos existentes en el DOM.
		let parrafos = document.querySelectorAll('p');
		// Calculamos el número de celdas de dicha matriz.
		let np = parrafos.length;
		// Establecemos el texto a mostrar según el número de celdas.
		let npt="";
		if (np === 0) { 
			npt = " ningún párrafo"; 
		} else if (np === 1) {
			npt = "1 párrafo";
		} else {
			npt = np.toString() + " párrafos";
		}
		npt += ",<br> &nbsp;&nbsp;&nbsp;&nbsp;- ";

		// Definimos la matriz o array que almacenará todas las listas <ol> existentes en el DOM.
		let ol = document.querySelectorAll('ol');
		// Calculamos el número de celdas de dicha matriz.
		let nol = ol.length;
		// Establecemos el texto a mostrar según el número de celdas.
		let nolt="";
		if (nol === 0) { 
			nolt = " ninguna lista"; 
		} else if (nol === 1) {
			nolt = "1 lista";
		} else {
			nolt = nol.toString() + " listas";
		}
		nolt += " &lt;ol&gt;,<br> &nbsp;&nbsp;&nbsp;&nbsp;- ";

		// Definimos las matrices o arrays que almacenarán todas las listas <ul> existentes en el DOM.
		let ul = document.querySelectorAll('ul');
		// Y calculamos aparte cuántas listas hay ocultas.
		let oul = document.querySelectorAll('ul[class^="oculto"]');
		// Calculamos el número de celdas de dichas matrices.
		let nul  =  ul.length;
		let noul = oul.length;
		// Establecemos el texto a mostrar según el número de celdas en cada matriz.
		let nult="y ";
		if (nul === 0) { 
			nult += " ninguna lista"; 
		} else if (nul === 1) {
			nult += "1 lista";
		} else {
			nult = nult + nul.toString() + " listas";
		}
		nult += " &lt;ul&gt; (";
		if (noul === 0) { 
			nult += "ninguna oculta"; 
		} else if (noul === 1) {
			nult += "1 de ellas oculta";
		} else {
			nult = nult + noul.toString() + " de ellas ocultas";
		}
		nult += ").";

		// Creamos un nuevo párrafo.
		const nuevoParrafo = document.createElement("p");
		// Le asignamos contenido con códigos HTML que deberán ser correctamente interpretados.
		nuevoParrafo.innerHTML = "La página contiene: <br> &nbsp;&nbsp;&nbsp;&nbsp;- " + ndt + npt + nolt + nult;
		/* Asignamos id al nuevo párrafo para así poder referirnos a él más adelante ya que la
		   constante nuevoParrafo, al ser local en esta función, dejará de existir al salir de ella
		   y la próxima vez que se ejecute esta función pasaremos directamente a la opción  else  ya
		   que el párrafo recien creado ya existirá.*/
		nuevoParrafo.id = "nuevoParrafo";
		/* Asignamos el nuevo párrafo al elemento <div> de la clase .stat almacenado en la
			constante contenedor. */
		contenedor.appendChild(nuevoParrafo);
		// Forzamos un scroll hasta el final del body para enfocar los nuevos datos añadidos.
		document.body.scrollIntoView({ behavior: 'smooth', block: 'end' });
		// Cambiamos el color y el texto del botón
		btn.style.backgroundColor = "DarkSalmon";
		btn.value = "Ocultar estadísticas";
		/* Finalmente cambiamos el valor de la variable booleana a true para indicar
			que el nuevo párrafo ya ha sido creado en la página. */
		nP = true;
	} else {
		/* Como el párrafo ya existe (nP no es false) procedemos a eliminarlo (ocultamos los datos).
			Creamos la constante que va a representar al párrafo que se añadió a la página */
		const nuevoParrafo = document.querySelector("#nuevoParrafo");
		// Eliminamos dicho objeto.
		contenedor.removeChild(nuevoParrafo);
		// Cambiamos el color y el texto del botón
		btn.style.backgroundColor = "PaleGreen";
		btn.value = "Ver estadísticas";
		/* Y finalmente cambiamos el valor de la variable booleana para indicar que el párrafo
			ya no existe en esta página. */
		nP = false;
	}
	
}





