// Función que devuelve el número de listas que existen en la página
function cuentaListas(){
	let listaOl = document.querySelectorAll('ol');
	let listaUl = document.querySelectorAll('ul');
	let listaDl = document.querySelectorAll('dl');
	return listaOl.length + listaUl.length + listaDl.length;
}


// Función que muestra el mensaje al pulsar el botón
function alerta(){
	let numListas = cuentaListas();
	let numParrafos = document.querySelectorAll('p');

	if (0 <= numListas ) {
		if (numListas === 1){ //En caso de que tenga una lista
			alert("La página tiene " + numParrafos.length + " párrafos y " + numListas +" lista");
		}
		else{ //En caso de que tenga más de 1 lista
			alert("La página tiene " + numParrafos.length + " párrafos y " + numListas +" lista");
		}
	}
	else {
		  alert("La página tiene XX párrafos y no tiene listas"); 
	}
}

// Función que cambia el estilo de la página
function cambio(){
	// Almacenamos en una variable el elemento h1
	let titulo = document.querySelector('h1');
	titulo.style.color = "rgb(250,0,0)";
	
	// Almacenamos en una variable el elemento body
	let pagina = document.querySelector('body');
	pagina.style.backgroundColor = "rgb(235, 255, 184)";
	
	// Cambio de color de texto y fondo de las etiquetas h3
	let header3 = document.querySelectorAll('h3');
	let i;
	for (i=0;i<header3.length;i++)
	{
		header3[i].style.color = "#0A4EFC"; /* Color del texto */
		header3[i].style.backgroundColor = "#FCD93E"; /* Color del fondo */
		header3[i].style.fontFamily = "Snap ITC"; /* Tipo de letra */
		header3[i].style.fontSize = "40px"; /* Tamaño de letra */
	}
	
	// Cambio de estilo de los botones
	let botones = document.querySelectorAll('button');
	for (i=0;i<botones.length;i++)
	{
		botones[i].classList.add('boton');
	}
}

//Funcion que revierte los cambios hechos
function reset(){
	// Almacenamos en una variable el elemento h1
	let titulo = document.querySelector('h1');
	titulo.style.color = "#ff8800";
	
	// Almacenamos en una variable el elemento body
	let pagina = document.querySelector('body');
	pagina.style.backgroundColor = "lightgrey";
	
	// //Cambio de color de texto y fondo de las etiquetas h3
	let header3 = document.querySelectorAll('h3');
	let i;
	for (i=0;i<header3.length;i++)
	{
		header3[i].style.color = "#2c8b0e"; /* Color del texto */
		header3[i].style.backgroundColor = "darkgrey"; /* Color del fondo */
		header3[i].style.fontFamily = "Forte"; /* Tipo de letra */
		header3[i].style.fontSize = "24px"; /* Tamaño de letra */
	}

	// Cambio de estilo de los botones
	let botones = document.querySelectorAll('button');
	for (i=0;i<botones.length;i++)
	{
		botones[i].classList.remove('boton');
	}
}

// Se crea el objeto botones
let botones = document.querySelectorAll('button');
// se añade el evento click para que ejecute la función alerta en el momento que se produzca
botones[0].addEventListener('click',alerta);

// se añade el evento click para que ejecute la función cambio en el momento que se produzca
botones[1].addEventListener('click',cambio);

// se añade el evento click para que ejecute la función cambio en el momento que se produzca
botones[2].addEventListener('click',reset);
