#! /bin/sh
. $3/funcs.sh
bootfs=$1
rootfs=$2
jvm=`echo $bootfs/ejre*`
ipaddress=10.0.1.1
LJHOME=home/root/lejos
echo Java is $jvm
current=${PWD}
log "Installing rootfs"
cd "$rootfs"
gunzip -c "$bootfs"/rootfs.cpio.gz | cpio -i
cd "$current"
rm "$rootfs"/etc/mtab
rm "$rootfs"/etc/wpa_supplicant.conf
sync
log "Installing modules"
rm -rf $rootfs/lib/modules/*
cp -r modules/* $rootfs
cp -r netmods/* "$rootfs/"/lib/modules/*/kernel/drivers/net/wireless/
cp -r firmware/* "$rootfs"/
rm "$rootfs"/lib/modules/*/modules.dep
sync
log "Installing leJOS"
rm -rf "$rootfs"/home/root/lms2012
cp -r lejosfs/* "$rootfs"
cp ev3classes.jar "$rootfs"/$LJHOME/lib
cp dbusjava.jar "$rootfs"/$LJHOME/lib
cp opencv-*.jar "$rootfs"/$LJHOME/lib

cp mod/*.ko "$rootfs"/$LJHOME/mod
cp version "$rootfs"/$LJHOME
cp -P lib/*.so* "$rootfs"/usr/lib
sync
log "Install links"
cd $rootfs/bin
ln -s ../$LJHOME/bin/jrun jrun
cd ../etc/rc0.d
ln -s ../init.d/lejos K09lejos
ln -s ../init.d/lejosunload S89lejosunload
cd ../rc5.d
ln -s ../init.d/dropbear S81dropbear
ln -s ../init.d/lejos S98lejos
cd $current
rm "$rootfs"/var/lib/bluetooth
mkdir "$rootfs"/var/lib/bluetooth
log "Install libjna"
cp -r libjna "$rootfs"/$LJHOME
cp jna.jar "$rootfs"/$LJHOME/libjna/usr/share/java
log "Copy config files"
cp $bootfs/wpa_supplicant.conf "$rootfs"/etc 2> /dev/null
cp $bootfs/hostname $rootfs/etc 2> /dev/null
cp $bootfs/wpa_supplicant.lejos $rootfs/$LJHOME/config/wpa_supplicant.conf 2> /dev/null
cp $bootfs/pan.conf $rootfs/$LJHOME/config/ 2> /dev/null
ls $bootfs
cd $bootfs
ls
pwd
newjre=$(echo ejre*)
echo "jre is $newjre"
if [ -f $newjre ];
then
  log "Install jre"
  rm -rf $rootfs/$LJHOME/ejre* 2> /dev/null
  log "Extracting jre"
  tar -C $rootfs/$LJHOME -zxf ${newjre} || error "JRE extract failed"
  echo ${newjre} > $rootfs/$LJHOME/jrever
  rm $rootfs/$LJHOME/jreopt
fi
cd $rootfs/$LJHOME
log "Check Java"
$rootfs/$LJHOME/ejre*/bin/java -version || error "Java not installed"
if [ ! -f jreopt ];
then
  log "Optimize java"
  $rootfs/$LJHOME/ejre*/bin/java -client -Xshare:dump
  touch jreopt
fi

sync
