document.addEventListener('DOMContentLoaded', (event) => {
    // Crear botón de estadísticas
    const botonEstadisticas = document.createElement('button');
    botonEstadisticas.textContent = 'Estadísticas';
    botonEstadisticas.style.cssText = 'display: block; margin: 20px auto; padding: 10px 20px; font-size: 16px; cursor: pointer;';

    // Añadir botón al final del contenedor
    const contenedor = document.querySelector('.container');
    contenedor.appendChild(botonEstadisticas);

    // Función que se ejecuta al hacer clic en el botón
    botonEstadisticas.addEventListener('click', () => {
        // Contar párrafos en el documento
        const numeroDeParrafos = document.querySelectorAll('p').length;

        // Crear párrafo con mensaje
        const parrafoEstadisticas = document.createElement('p');
        parrafoEstadisticas.textContent = `La página tiene ${numeroDeParrafos} párrafos.`;
        parrafoEstadisticas.style.cssText = 'text-align: center; font-weight: bold;';

        // Añadir el párrafo con el mensaje al final del contenedor
        contenedor.appendChild(parrafoEstadisticas);

        // Opcional: deshabilitar el botón después de usarlo para evitar múltiples párrafos iguales
        botonEstadisticas.disabled = true;
        botonEstadisticas.style.opacity = '0.5';
        botonEstadisticas.style.cursor = 'not-allowed';
    });
});
