/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.math;

import edu.colorado.phet.common.phetcommon.math.Complex;
import edu.colorado.phet.common.phetcommon.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DampedMassSpringSystem {
    private final double mass;
    private final double k;
    private final double c;
    private final double x0;
    private final double v0;
    private final double omega0;
    private final double zeta;
    private final Pair<Complex, Complex> characteristicEquationRoots;
    private final Complex smallRoot;
    private final Complex largeRoot;
    private final Complex smallConstant;
    private final Complex largeConstant;

    public DampedMassSpringSystem(double d, double d2, double d3, double d4, double d5) {
        this.mass = d;
        this.k = d2;
        this.c = d3;
        this.x0 = d4;
        this.v0 = d5;
        this.omega0 = Math.sqrt(d2 / d);
        this.zeta = d3 / (2.0 * Math.sqrt(d * d2));
        this.characteristicEquationRoots = DampedMassSpringSystem.solveQuadratic(1.0, d3 / d, d2 / d);
        this.smallRoot = (Complex)this.characteristicEquationRoots._1;
        this.largeRoot = (Complex)this.characteristicEquationRoots._2;
        Complex complex = new Complex(d4, 0.0);
        Complex complex2 = new Complex(d5, 0.0);
        Complex complex3 = this.largeRoot.getMultiply(complex).getSubtract(complex2).getDivide(this.smallRoot.getSubtract(this.largeRoot));
        if (this.isCriticallyDamped()) {
            this.largeConstant = complex;
            this.smallConstant = complex2.getAdd(complex.getMultiply(this.omega0));
        } else {
            this.largeConstant = complex.getAdd(complex3);
            this.smallConstant = complex3.getOpposite();
        }
    }

    public double evaluatePosition(double d) {
        Complex complex;
        if (this.isCriticallyDamped()) {
            double d2 = -this.omega0;
            double d3 = this.x0;
            double d4 = this.v0 + this.omega0 * this.x0;
            complex = new Complex((d3 + d4 * d) * Math.exp(d2 * d), 0.0);
        } else {
            Complex complex2 = this.largeConstant.getMultiply(Complex.getExp(this.largeRoot.getMultiply(d)));
            Complex complex3 = this.smallConstant.getMultiply(Complex.getExp(this.smallRoot.getMultiply(d)));
            complex = complex2.getAdd(complex3);
        }
        return complex._real;
    }

    public double evaluateVelocity(double d) {
        Complex complex;
        if (this.isCriticallyDamped()) {
            double d2 = -this.omega0;
            double d3 = this.x0;
            double d4 = this.v0 + this.omega0 * this.x0;
            complex = new Complex(Math.exp(d2 * d) * (d3 * d2 + d4 * d2 * d + d4), 0.0);
        } else {
            Complex complex2 = this.largeConstant.getMultiply(Complex.getExp(this.largeRoot.getMultiply(d))).getMultiply(this.largeRoot);
            Complex complex3 = this.smallConstant.getMultiply(Complex.getExp(this.smallRoot.getMultiply(d))).getMultiply(this.smallRoot);
            complex = complex2.getAdd(complex3);
        }
        return complex._real;
    }

    public boolean isCriticallyDamped() {
        return this.zeta == 1.0;
    }

    public static double getCriticallyDampedDamping(double d, double d2) {
        return 2.0 * Math.sqrt(d * d2);
    }

    public static Pair<Complex, Complex> solveQuadratic(double d, double d2, double d3) {
        return DampedMassSpringSystem.solveQuadratic(new Complex(d, 0.0), new Complex(d2, 0.0), new Complex(d3, 0.0));
    }

    public static Pair<Complex, Complex> solveQuadratic(Complex complex, Complex complex2, Complex complex3) {
        Complex complex4 = complex2.getMultiply(complex2).getSubtract(complex.getMultiply(complex3).getMultiply(4.0));
        Complex complex5 = complex4.getCanonicalSquareRoot();
        return new Pair<Complex, Complex>(new Complex(complex2.getOpposite().getSubtract(complex5).getDivide(complex.getMultiply(2.0))), new Complex(complex2.getOpposite().getAdd(complex5).getDivide(complex.getMultiply(2.0))));
    }
}

