/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes;

import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.Option;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.piccolophet.PiccoloPhetApplication;
import edu.colorado.phet.common.piccolophet.nodes.PointSensor;
import edu.colorado.phet.common.piccolophet.nodes.SpeedometerNode;
import edu.colorado.phet.common.piccolophet.nodes.ToolNode;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpeedometerSensorNode
extends ToolNode {
    public final ModelViewTransform transform;
    public final PointSensor<Double> pointSensor;
    public final SpeedometerNode bodyNode;
    public final PImage velocityPointNode;
    public final BufferedImage velocityPoint;

    public SpeedometerSensorNode(final ModelViewTransform modelViewTransform, final PointSensor<Double> pointSensor, String string, double d) {
        this.transform = modelViewTransform;
        this.pointSensor = pointSensor;
        final Property<Option<Double>> property = new Property<Option<Double>>(new Option.Some<Double>(0.0));
        pointSensor.value.addObserver(new VoidFunction1<Option<Double>>(){

            @Override
            public void apply(Option<Double> option) {
                property.set(option);
            }
        });
        this.bodyNode = new SpeedometerNode(string, 100.0, property, d);
        this.velocityPoint = PiccoloPhetApplication.RESOURCES.getImage("speedometer_point.png");
        this.velocityPointNode = new PImage(this.velocityPoint);
        final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SpeedometerSensorNode.this.velocityPointNode.setOffset(SpeedometerSensorNode.this.bodyNode.getFullBounds().getCenterX() - SpeedometerSensorNode.this.velocityPointNode.getFullBounds().getWidth() / 2.0, SpeedometerSensorNode.this.bodyNode.getFullBounds().getMaxY() - 10.0);
            }
        };
        propertyChangeListener.propertyChange(null);
        this.addChild(this.velocityPointNode);
        this.addChild(this.bodyNode);
        pointSensor.position.addObserver(new SimpleObserver(){

            public void update() {
                Point2D.Double double_ = modelViewTransform.modelToView(pointSensor.position.get()).toPoint2D();
                SpeedometerSensorNode.this.setOffset(double_.getX() - SpeedometerSensorNode.this.bodyNode.getFullBounds().getWidth() / 2.0, double_.getY() - SpeedometerSensorNode.this.bodyNode.getFullBounds().getHeight() - (double)SpeedometerSensorNode.this.velocityPoint.getHeight() + 10.0);
                propertyChangeListener.propertyChange(null);
            }
        });
    }
}

