/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lwjglphet.contrib;

import edu.colorado.phet.lwjglphet.StartupUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LWJGLStartupImplementation {
    private static final Logger logger = Logger.getLogger(StartupUtils.class.getName());
    private static final byte[] buf = new byte[1024];

    public static Platform getPlatform() {
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = System.getProperty("os.arch").toLowerCase();
        boolean bl = LWJGLStartupImplementation.is64Bit(string2);
        if (string.contains("windows")) {
            return bl ? Platform.Windows64 : Platform.Windows32;
        }
        if (string.contains("linux") || string.contains("freebsd") || string.contains("sunos")) {
            return bl ? Platform.Linux64 : Platform.Linux32;
        }
        if (string.contains("mac os x") || string.contains("darwin")) {
            if (string2.startsWith("ppc")) {
                return bl ? Platform.MacOSX_PPC64 : Platform.MacOSX_PPC32;
            }
            return bl ? Platform.MacOSX64 : Platform.MacOSX32;
        }
        throw new UnsupportedOperationException("The specified platform: " + string + " is not supported.");
    }

    private static boolean is64Bit(String string) {
        if (string.equals("x86")) {
            return false;
        }
        if (string.equals("amd64")) {
            return true;
        }
        if (string.equals("x86_64")) {
            return true;
        }
        if (string.equals("ppc") || string.equals("PowerPC")) {
            return false;
        }
        if (string.equals("ppc64")) {
            return true;
        }
        if (string.equals("i386") || string.equals("i686")) {
            return false;
        }
        if (string.equals("universal")) {
            return false;
        }
        throw new UnsupportedOperationException("Unsupported architecture: " + string);
    }

    protected static void extractNativeLib(File file, String string, String string2) throws IOException {
        LWJGLStartupImplementation.extractNativeLib(file, string, string2, false, true);
    }

    protected static void extractNativeLib(File file, String string, String string2, boolean bl, boolean bl2) throws IOException {
        String string3 = System.mapLibraryName(string2);
        String string4 = "native/" + string + "/" + string3;
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string4);
        if (inputStream == null) {
            if (string3.endsWith(".dylib")) {
                string4 = string4.replaceFirst(".dylib", ".jnilib");
                inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string4);
            }
            if (inputStream == null) {
                if (!bl2) {
                    logger.log(Level.WARNING, "Cannot locate native library: {0}/{1}", new String[]{string, string3});
                }
                return;
            }
        }
        File file2 = new File(file, string3);
        try {
            int n;
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            while ((n = inputStream.read(buf)) > 0) {
                ((OutputStream)fileOutputStream).write(buf, 0, n);
            }
            inputStream.close();
            ((OutputStream)fileOutputStream).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (fileNotFoundException.getMessage().contains("used by another process")) {
                return;
            }
            throw new RuntimeException(fileNotFoundException);
        }
        finally {
            if (bl) {
                System.load(file2.getAbsolutePath());
            }
        }
        logger.log(Level.INFO, "Copied {0} to {1}", new Object[]{string3, file2});
        System.out.println(file2);
    }

    public static void extractNativeLibs(File file, Platform platform, boolean bl, boolean bl2) throws IOException {
        System.out.println("Extraction Directory: " + file.getAbsolutePath());
        System.setProperty("org.lwjgl.librarypath", file.getAbsolutePath());
        System.out.println("Platform guess: " + (Object)((Object)platform));
        switch (platform) {
            case Windows64: {
                LWJGLStartupImplementation.extractNativeLib(file, "windows", "lwjgl64");
                if (bl) {
                    LWJGLStartupImplementation.extractNativeLib(file, "windows", "OpenAL64");
                }
                if (!bl2) break;
                LWJGLStartupImplementation.extractNativeLib(file, "windows", "jinput-dx8_64");
                LWJGLStartupImplementation.extractNativeLib(file, "windows", "jinput-raw_64");
                break;
            }
            case Windows32: {
                LWJGLStartupImplementation.extractNativeLib(file, "windows", "lwjgl");
                if (bl) {
                    LWJGLStartupImplementation.extractNativeLib(file, "windows", "OpenAL32");
                }
                if (!bl2) break;
                LWJGLStartupImplementation.extractNativeLib(file, "windows", "jinput-dx8");
                LWJGLStartupImplementation.extractNativeLib(file, "windows", "jinput-raw");
                break;
            }
            case Linux64: {
                LWJGLStartupImplementation.extractNativeLib(file, "linux", "lwjgl64");
                if (bl2) {
                    LWJGLStartupImplementation.extractNativeLib(file, "linux", "jinput-linux64");
                }
                if (!bl) break;
                LWJGLStartupImplementation.extractNativeLib(file, "linux", "openal64");
                break;
            }
            case Linux32: {
                LWJGLStartupImplementation.extractNativeLib(file, "linux", "lwjgl");
                if (bl2) {
                    LWJGLStartupImplementation.extractNativeLib(file, "linux", "jinput-linux");
                }
                if (!bl) break;
                LWJGLStartupImplementation.extractNativeLib(file, "linux", "openal");
                break;
            }
            case MacOSX_PPC32: 
            case MacOSX32: 
            case MacOSX_PPC64: 
            case MacOSX64: {
                LWJGLStartupImplementation.extractNativeLib(file, "macosx", "lwjgl");
                if (!bl2) break;
                LWJGLStartupImplementation.extractNativeLib(file, "macosx", "jinput-osx");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Platform
    extends Enum<Platform> {
        public static final /* enum */ Platform Windows32 = new Platform();
        public static final /* enum */ Platform Windows64 = new Platform();
        public static final /* enum */ Platform Linux32 = new Platform();
        public static final /* enum */ Platform Linux64 = new Platform();
        public static final /* enum */ Platform MacOSX32 = new Platform();
        public static final /* enum */ Platform MacOSX64 = new Platform();
        public static final /* enum */ Platform MacOSX_PPC32 = new Platform();
        public static final /* enum */ Platform MacOSX_PPC64 = new Platform();
        private static final /* synthetic */ Platform[] $VALUES;

        public static Platform[] values() {
            return (Platform[])$VALUES.clone();
        }

        static {
            $VALUES = new Platform[]{Windows32, Windows64, Linux32, Linux64, MacOSX32, MacOSX64, MacOSX_PPC32, MacOSX_PPC64};
        }
    }
}

