/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lwjglphet.math;

import edu.colorado.phet.common.phetcommon.math.Matrix4F;
import edu.colorado.phet.common.phetcommon.math.Ray3F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.common.phetcommon.model.event.Notifier;
import edu.colorado.phet.common.phetcommon.model.event.ValueNotifier;
import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class LWJGLTransform {
    public final Notifier<LWJGLTransform> changed = new ValueNotifier<LWJGLTransform>(this);
    private Matrix4F matrix;
    private Matrix4F inverse;
    private FloatBuffer transformBuffer = BufferUtils.createFloatBuffer(16);
    private FloatBuffer inverseTransformBuffer = BufferUtils.createFloatBuffer(16);

    public LWJGLTransform() {
        this.set(Matrix4F.IDENTITY);
    }

    public LWJGLTransform(Matrix4F matrix4F) {
        this.set(matrix4F);
    }

    public void set(Matrix4F matrix4F) {
        this.matrix = matrix4F;
        this.inverse = matrix4F.inverted();
        matrix4F.writeToBuffer(this.transformBuffer);
        this.inverse.writeToBuffer(this.inverseTransformBuffer);
        this.changed.updateListeners(this);
    }

    public void prepend(Matrix4F matrix4F) {
        this.set(matrix4F.times(this.matrix));
    }

    public void append(Matrix4F matrix4F) {
        this.set(this.matrix.times(matrix4F));
    }

    public Matrix4F getMatrix() {
        return this.matrix;
    }

    public Matrix4F getInverse() {
        return this.inverse;
    }

    public void apply() {
        switch (this.matrix.type) {
            case SCALING: {
                Vector3F vector3F = this.matrix.getScaling();
                GL11.glScalef(vector3F.x, vector3F.y, vector3F.z);
                break;
            }
            case TRANSLATION_3D: {
                Vector3F vector3F = this.matrix.getTranslation();
                GL11.glTranslatef(vector3F.x, vector3F.y, vector3F.z);
                break;
            }
            default: {
                this.transformBuffer.rewind();
                GL11.glMultMatrix(this.transformBuffer);
            }
        }
    }

    public boolean isIdentity() {
        return this.matrix.type == Matrix4F.MatrixType.IDENTITY;
    }

    public Vector3F transformPosition(Vector3F vector3F) {
        return this.matrix.times(vector3F);
    }

    public Vector3F transformDelta(Vector3F vector3F) {
        return this.matrix.timesVector(vector3F);
    }

    public float transformDeltaX(float f) {
        return this.transformDelta((Vector3F)new Vector3F((float)f, (float)0.0f, (float)0.0f)).x;
    }

    public float transformDeltaY(float f) {
        return this.transformDelta((Vector3F)new Vector3F((float)0.0f, (float)f, (float)0.0f)).y;
    }

    public Vector3F inversePosition(Vector3F vector3F) {
        return this.inverse.times(vector3F);
    }

    public Ray3F inverseRay(Ray3F ray3F) {
        return new Ray3F(this.inversePosition(ray3F.pos), this.inversePosition(ray3F.pos.plus(ray3F.dir)).minus(this.inversePosition(ray3F.pos)));
    }
}

