/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lwjglphet.nodes;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2F;
import edu.colorado.phet.common.phetcommon.model.event.UpdateListener;
import edu.colorado.phet.common.phetcommon.model.event.VoidNotifier;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.lwjglphet.CanvasTransform;
import edu.colorado.phet.lwjglphet.GLOptions;
import edu.colorado.phet.lwjglphet.LWJGLCanvas;
import edu.colorado.phet.lwjglphet.LWJGLTab;
import edu.colorado.phet.lwjglphet.SwingImage;
import edu.colorado.phet.lwjglphet.nodes.AbstractSwingGraphicsNode;
import edu.colorado.phet.lwjglphet.utils.LWJGLUtils;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.Component;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrthoSwingNode
extends AbstractSwingGraphicsNode {
    public final Property<Vector2D> position;
    private boolean mouseEnabled = true;
    private final LWJGLTab tab;
    private final CanvasTransform canvasTransform;
    private int offsetX;
    private int offsetY;

    public OrthoSwingNode(JComponent jComponent, LWJGLTab lWJGLTab, CanvasTransform canvasTransform, Property<Vector2D> property, VoidNotifier voidNotifier) {
        super(jComponent);
        this.tab = lWJGLTab;
        this.canvasTransform = canvasTransform;
        this.position = property;
        property.addObserver(new SimpleObserver(){

            public void update() {
                OrthoSwingNode.this.rebuildComponentImage();
            }
        }, false);
        canvasTransform.transform.addObserver(new SimpleObserver(){

            public void update() {
                OrthoSwingNode.this.rebuildComponentImage();
            }
        });
        voidNotifier.addUpdateListener(new UpdateListener(){

            public void update() {
                if (OrthoSwingNode.this.componentImage != null && OrthoSwingNode.this.isMouseEnabled()) {
                    Vector2F vector2F = OrthoSwingNode.this.screenToLocalCoordinates(new Vector2F(Mouse.getEventX(), Mouse.getEventY()));
                    OrthoSwingNode.this.componentImage.handleMouseEvent((int)vector2F.x, (int)vector2F.y);
                }
            }
        }, false);
    }

    public Component getComponentAt(int n, int n2) {
        if (this.componentImage != null) {
            Vector2F vector2F = this.screenToLocalCoordinates(new Vector2F(n, n2));
            Vector2F vector2F2 = this.componentImage.localToComponentCoordinates(new Vector2F(vector2F.x, vector2F.y));
            return this.componentImage.componentAt((int)vector2F2.x, (int)vector2F2.y);
        }
        return null;
    }

    public Vector2F screenToLocalCoordinates(Vector2F vector2F) {
        return new Vector2F(vector2F.x - (float)this.offsetX, this.tab.canvasSize.get().height - Mouse.getEventY() - this.offsetY);
    }

    public Vector2F screentoComponentCoordinates(Vector2F vector2F) {
        return this.componentImage.localToComponentCoordinates(this.screenToLocalCoordinates(vector2F));
    }

    @Override
    public void renderSelf(GLOptions gLOptions) {
        if (this.componentImage == null) {
            return;
        }
        GL11.glEnable(3553);
        GL11.glShadeModel(7424);
        this.componentImage.useTexture();
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GL11.glBegin(7);
        GL11.glTexCoord2f(0.0f, 0.0f);
        GL11.glVertex3f(this.offsetX, this.offsetY, 0.0f);
        GL11.glTexCoord2f(0.0f, 1.0f);
        GL11.glVertex3f(this.offsetX, this.offsetY + this.componentImage.getHeight(), 0.0f);
        GL11.glTexCoord2f(1.0f, 1.0f);
        GL11.glVertex3f(this.offsetX + this.componentImage.getWidth(), this.offsetY + this.componentImage.getHeight(), 0.0f);
        GL11.glTexCoord2f(1.0f, 0.0f);
        GL11.glVertex3f(this.offsetX + this.componentImage.getWidth(), this.offsetY, 0.0f);
        GL11.glEnd();
        GL11.glShadeModel(7425);
        GL11.glDisable(3553);
    }

    @Override
    protected synchronized void rebuildComponentImage() {
        PBounds pBounds = new PBounds(this.position.get().getX(), this.position.get().getY(), this.size.width, this.size.height);
        Rectangle2D rectangle2D = this.canvasTransform.getTransformedBounds(pBounds);
        final double d = rectangle2D.getWidth() / pBounds.getWidth();
        final double d2 = rectangle2D.getHeight() / pBounds.getHeight();
        this.offsetX = (int)Math.floor(rectangle2D.getMinX());
        this.offsetY = (int)Math.floor(rectangle2D.getMinY());
        final double d3 = rectangle2D.getMinX() - (double)this.offsetX;
        final double d4 = Math.ceil(rectangle2D.getMaxY()) - rectangle2D.getMaxY();
        int n = LWJGLUtils.toPowerOf2((int)Math.ceil(rectangle2D.getMaxX()) - this.offsetX);
        int n2 = LWJGLUtils.toPowerOf2((int)Math.ceil(rectangle2D.getMaxY()) - this.offsetY);
        final SwingImage swingImage = new SwingImage(n, n2, true, 9728, 9728, new AffineTransform(){
            {
                this.translate(d3, -d4);
                this.scale(d, d2);
            }
        }, this.component);
        LWJGLCanvas.addTask(new Runnable(){

            public void run() {
                OrthoSwingNode.this.componentImage = swingImage;
            }
        });
    }

    public boolean isMouseEnabled() {
        return this.mouseEnabled;
    }

    public void setMouseEnabled(boolean bl) {
        this.mouseEnabled = bl;
    }
}

