/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lwjglphet.nodes;

import edu.colorado.phet.common.phetcommon.math.PlaneF;
import edu.colorado.phet.common.phetcommon.math.Ray3F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.common.phetcommon.model.event.Notifier;
import edu.colorado.phet.common.phetcommon.model.event.UpdateListener;
import edu.colorado.phet.common.piccolophet.nodes.kit.ZeroOffsetNode;
import edu.colorado.phet.lwjglphet.GLOptions;
import edu.colorado.phet.lwjglphet.PiccoloImage;
import edu.colorado.phet.lwjglphet.nodes.AbstractGraphicsNode;
import edu.colorado.phet.lwjglphet.utils.LWJGLUtils;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPickPath;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.opengl.GL11;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadedPlanarPiccoloNode
extends AbstractGraphicsNode {
    private final PNode node;
    private final PNode wrappedNode;
    private Cursor cursor = Cursor.getPredefinedCursor(0);
    private PiccoloImage piccoloImage;
    private List<Notifier<?>> repaintNotifiers = new ArrayList();
    private UpdateListener repaintListener = new UpdateListener(){

        public void update() {
            ThreadedPlanarPiccoloNode.this.repaint();
        }
    };

    public ThreadedPlanarPiccoloNode(PNode pNode) {
        this.node = pNode;
        this.wrappedNode = new ZeroOffsetNode(pNode);
        this.repaint();
    }

    public void repaint() {
        Dimension dimension = this.getCurrentSize();
        if (this.piccoloImage == null || !this.size.equals(dimension)) {
            this.size = dimension;
            this.rebuildComponentImage();
            this.onResize.updateListeners();
        }
        this.piccoloImage.repaint();
    }

    private Dimension getCurrentSize() {
        PBounds pBounds = this.node.getFullBounds();
        return new Dimension((int)Math.ceil(pBounds.getWidth()), (int)Math.ceil(pBounds.getHeight()));
    }

    public <T> void addRepaintNotifier(Notifier<T> notifier) {
        this.repaintListener = new UpdateListener(){

            public void update() {
                ThreadedPlanarPiccoloNode.this.repaint();
            }
        };
        notifier.addUpdateListener(this.repaintListener, false);
        this.repaintNotifiers.add(notifier);
    }

    public void recycle() {
        for (Notifier<?> notifier : this.repaintNotifiers) {
            notifier.removeListener(this.repaintListener);
        }
        this.repaintNotifiers.clear();
    }

    public boolean doesLocalRayHit(Ray3F ray3F) {
        Vector3F vector3F = PlaneF.XY.intersectWithRay(ray3F);
        return this.intersects(new Vector2F(vector3F.x, (float)this.getComponentHeight() - vector3F.y));
    }

    @Override
    public void renderSelf(GLOptions gLOptions) {
        if (this.piccoloImage == null) {
            return;
        }
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GL11.glEnable(3553);
        GL11.glShadeModel(7424);
        this.piccoloImage.useTexture();
        GL11.glBegin(7);
        float f = 0.0f;
        float f2 = this.piccoloImage.getWidth();
        float f3 = this.size.height;
        float f4 = this.size.height - this.piccoloImage.getHeight();
        GL11.glTexCoord2f(0.0f, 1.0f);
        GL11.glVertex3f(f, f4, 0.0f);
        GL11.glTexCoord2f(0.0f, 0.0f);
        GL11.glVertex3f(f, f3, 0.0f);
        GL11.glTexCoord2f(1.0f, 0.0f);
        GL11.glVertex3f(f2, f3, 0.0f);
        GL11.glTexCoord2f(1.0f, 1.0f);
        GL11.glVertex3f(f2, f4, 0.0f);
        GL11.glEnd();
        GL11.glShadeModel(7425);
        GL11.glDisable(3553);
    }

    @Override
    protected synchronized void rebuildComponentImage() {
        PiccoloImage piccoloImage;
        int n = LWJGLUtils.toPowerOf2(this.size.width);
        int n2 = LWJGLUtils.toPowerOf2(this.size.height);
        if (this.piccoloImage != null) {
            this.piccoloImage.dispose();
        }
        this.piccoloImage = piccoloImage = new PiccoloImage(n, n2, true, 9729, 9729, new AffineTransform(), this.wrappedNode);
    }

    public boolean intersects(Vector2F vector2F) {
        return this.getNode().fullPick(new PPickPath(new PCamera(), new PBounds(vector2F.x, vector2F.y, 0.1, 0.1)));
    }

    public PNode getNode() {
        return this.node;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public void setCursor(Cursor cursor) {
        this.cursor = cursor;
    }
}

