/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lwjglphet.shapes;

import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.lwjglphet.GLOptions;
import edu.colorado.phet.lwjglphet.nodes.GLNode;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class GridMesh
extends GLNode {
    private FloatBuffer positionBuffer;
    protected FloatBuffer normalBuffer;
    protected FloatBuffer textureBuffer;
    private IntBuffer indexBuffer;
    private boolean updateNormals = true;
    private int rows;
    private int columns;
    protected Vector3F[] positions;

    public GridMesh(int n, int n2, Vector3F[] vector3FArray) {
        int n3;
        int n4;
        assert (n * n2 == vector3FArray.length);
        this.rows = n;
        this.columns = n2;
        this.positions = vector3FArray;
        int n5 = n2 * n;
        this.positionBuffer = BufferUtils.createFloatBuffer(n5 * 3);
        this.normalBuffer = BufferUtils.createFloatBuffer(n5 * 3);
        this.textureBuffer = BufferUtils.createFloatBuffer(n5 * 2);
        int n6 = (n - 1) * n2 * 2 + (n - 2) * 2;
        this.indexBuffer = BufferUtils.createIntBuffer(n6);
        if (vector3FArray != null) {
            this.setPositions(vector3FArray);
        }
        float f = Math.max(n, n2);
        for (n4 = 0; n4 < n; ++n4) {
            for (n3 = 0; n3 < n2; ++n3) {
                this.textureBuffer.put(new float[]{(float)n3 / f, (float)n4 / f});
            }
        }
        for (n4 = 0; n4 < n - 1; ++n4) {
            n3 = n4 * n2;
            if (n4 != 0) {
                this.indexBuffer.put(n3 + n2 - 1);
                this.indexBuffer.put(n3);
            }
            for (int i = 0; i < n2; ++i) {
                this.indexBuffer.put(n3 + i);
                this.indexBuffer.put(n3 + n2 + i);
            }
        }
    }

    public void updateGeometry(Vector3F[] vector3FArray) {
        this.setPositions(vector3FArray);
    }

    private void setPositions(Vector3F[] vector3FArray) {
        this.positions = vector3FArray;
        this.positionBuffer.clear();
        if (this.updateNormals) {
            this.normalBuffer.clear();
        }
        for (int i = 0; i < this.rows; ++i) {
            int n = i * this.columns;
            for (int j = 0; j < this.columns; ++j) {
                Vector3F vector3F = vector3FArray[n + j];
                this.positionBuffer.put(new float[]{vector3F.x, vector3F.y, vector3F.z});
                if (!this.updateNormals) continue;
                Vector3F vector3F2 = this.getNormal(i, j);
                this.normalBuffer.put(new float[]{vector3F2.x, vector3F2.y, vector3F2.z});
            }
        }
    }

    public Vector3F getNormal(int n, int n2) {
        Vector3F vector3F;
        Vector3F vector3F2;
        Vector3F vector3F3;
        Vector3F vector3F4;
        Vector3F vector3F5 = this.getPosition(n, n2);
        if (n > 0) {
            vector3F4 = this.getPosition(n - 1, n2).minus(vector3F5);
            vector3F3 = n < this.rows - 1 ? this.getPosition(n + 1, n2).minus(vector3F5) : vector3F4.negated();
        } else {
            vector3F3 = this.getPosition(n + 1, n2).minus(vector3F5);
            vector3F4 = vector3F3.negated();
        }
        if (n2 > 0) {
            vector3F2 = this.getPosition(n, n2 - 1).minus(vector3F5);
            vector3F = n2 < this.columns - 1 ? this.getPosition(n, n2 + 1).minus(vector3F5) : vector3F2.negated();
        } else {
            vector3F = this.getPosition(n, n2 + 1).minus(vector3F5);
            vector3F2 = vector3F.negated();
        }
        Vector3F vector3F6 = new Vector3F();
        vector3F6 = vector3F6.plus(vector3F.cross(vector3F4).normalized());
        vector3F6 = vector3F6.plus(vector3F4.cross(vector3F2).normalized());
        vector3F6 = vector3F6.plus(vector3F2.cross(vector3F3).normalized());
        vector3F6 = vector3F6.plus(vector3F3.cross(vector3F).normalized());
        return vector3F6.normalized();
    }

    protected void preRender(GLOptions gLOptions) {
        super.preRender(gLOptions);
        this.positionBuffer.rewind();
        this.normalBuffer.rewind();
        this.textureBuffer.rewind();
        this.indexBuffer.rewind();
        GL11.glEnableClientState(32884);
        if (gLOptions.shouldSendTexture()) {
            GL11.glEnableClientState(32888);
            GL11.glTexCoordPointer(2, 0, this.textureBuffer);
        }
        if (gLOptions.shouldSendNormals()) {
            GL11.glEnableClientState(32885);
            GL11.glNormalPointer(0, this.normalBuffer);
        }
        GL11.glVertexPointer(3, 0, this.positionBuffer);
    }

    protected void postRender(GLOptions gLOptions) {
        super.postRender(gLOptions);
        GL11.glDisableClientState(32884);
        if (gLOptions.shouldSendTexture()) {
            GL11.glDisableClientState(32888);
        }
        if (gLOptions.shouldSendNormals()) {
            GL11.glDisableClientState(32885);
        }
    }

    public void renderSelf(GLOptions gLOptions) {
        GL11.glDrawElements(5, this.indexBuffer);
    }

    public Vector3F getPosition(int n, int n2) {
        return this.positions[n * this.columns + n2];
    }
}

