/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lwjglphet.utils;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.HorizontalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.util.HTMLUtils;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.lwjglphet.LWJGLCanvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.FloatBuffer;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

public class LWJGLUtils {
    private static int nextDisplayList = 1;

    public static int toPowerOf2(int n) {
        int n2;
        for (n2 = 1; n2 < n; n2 *= 2) {
        }
        return n2;
    }

    public static boolean isPowerOf2(int n) {
        return n == LWJGLUtils.toPowerOf2(n);
    }

    public static void color4f(Color color) {
        GL11.glColor4f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f);
    }

    public static void vertex3f(Vector3F vector3F) {
        GL11.glVertex3f(vector3F.x, vector3F.y, vector3F.z);
    }

    public static void vertex2fxy(Vector2F vector2F) {
        GL11.glVertex3f(vector2F.x, vector2F.y, 0.0f);
    }

    public static FloatBuffer floatBuffer(float[] fArray) {
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(fArray.length);
        floatBuffer.put(fArray);
        floatBuffer.rewind();
        return floatBuffer;
    }

    public static void invoke(Runnable runnable) {
        LWJGLCanvas.addTask(runnable);
    }

    public static boolean isLWJGLRendererThread() {
        return Thread.currentThread().getName().equals("PhET LWJGL Main Loop Thread");
    }

    public static SimpleObserver swingObserver(final Runnable runnable) {
        return new SimpleObserver(){

            public void update() {
                SwingUtilities.invokeLater(runnable);
            }
        };
    }

    public static boolean containsMacJava7Issue() {
        return System.mapLibraryName("lwjgl").endsWith("dylib") && System.getProperty("os.name").contains("OS X") && System.getProperty("java.version").split("\\.")[1].equals("7");
    }

    public static void showMacJava7Warning(Frame frame) {
        JDialog jDialog = new JDialog(frame){
            {
                this.setContentPane(new JPanel(new GridLayout(1, 1)){
                    {
                        this.setBorder(new EmptyBorder(10, 10, 10, 10));
                        this.add(new HorizontalLayoutPanel(){
                            {
                                ImageIcon imageIcon = new ImageIcon(PhetCommonResources.getInstance().getImage("logos/phet-logo-120x50.jpg"));
                                JLabel jLabel = new JLabel(imageIcon);
                                this.add(jLabel);
                                this.add((Component)new VerticalLayoutPanel(){
                                    {
                                        this.add(new JLabel(PhetCommonResources.getString("Jme.thisSimulationWasUnableToStart")){
                                            {
                                                this.setFont(new PhetFont(20, true));
                                                this.setForeground(Color.BLUE);
                                            }
                                        });
                                        String string = "http://support.apple.com/kb/HT5559?viewlocale=en_US";
                                        String string2 = PhetCommonResources.getString("Lwjgl.macJava17Message");
                                        this.add(new HTMLUtils.InteractiveHTMLPane(MessageFormat.format(string2, string)){
                                            {
                                                this.setOpaque(false);
                                                this.setFont(new PhetFont(16, true));
                                            }
                                        });
                                        this.add(new JPanel(){
                                            {
                                                this.add(new JButton(PhetCommonResources.getString("Common.choice.ok")){
                                                    {
                                                        this.addActionListener(new ActionListener(){

                                                            public void actionPerformed(ActionEvent actionEvent) {
                                                                this.dispose();
                                                            }
                                                        });
                                                    }
                                                });
                                            }
                                        });
                                    }
                                }, new GridBagConstraints(){
                                    {
                                        this.fill = 2;
                                        this.insets = new Insets(10, 10, 10, 10);
                                    }
                                });
                            }
                        });
                        this.setMaximumSize(new Dimension(500, 10000));
                    }
                });
            }
        };
        jDialog.setModal(true);
        jDialog.pack();
        SwingUtils.centerWindowOnScreen(jDialog);
        jDialog.show();
    }

    public static void showErrorDialog(final Frame frame, final Throwable throwable) {
        final ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        final String string = contextCapabilities != null && contextCapabilities.OpenGL20 ? GL11.glGetString(35724) : "(none)";
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String string3 = "";
                for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                    string3 = string3 + stackTraceElement.toString() + "\n";
                }
                StringBuilder stringBuilder = new StringBuilder();
                if (contextCapabilities != null) {
                    stringBuilder.append(" OpenGL11:").append(contextCapabilities.OpenGL11);
                    stringBuilder.append(" OpenGL12:").append(contextCapabilities.OpenGL12);
                    stringBuilder.append(" OpenGL13:").append(contextCapabilities.OpenGL13);
                    stringBuilder.append(" OpenGL14:").append(contextCapabilities.OpenGL14);
                    stringBuilder.append(" OpenGL15:").append(contextCapabilities.OpenGL15);
                    stringBuilder.append(" OpenGL20:").append(contextCapabilities.OpenGL20);
                    stringBuilder.append(" OpenGL21:").append(contextCapabilities.OpenGL21);
                    stringBuilder.append(" OpenGL30:").append(contextCapabilities.OpenGL30);
                    stringBuilder.append(" OpenGL31:").append(contextCapabilities.OpenGL31);
                    stringBuilder.append(" OpenGL32:").append(contextCapabilities.OpenGL32);
                    stringBuilder.append(" OpenGL33:").append(contextCapabilities.OpenGL33);
                    stringBuilder.append(" OpenGL40:").append(contextCapabilities.OpenGL40);
                    stringBuilder.append(" OpenGL41:").append(contextCapabilities.OpenGL41);
                    stringBuilder.append(" GL_ARB_texture_non_power_of_two:").append(contextCapabilities.GL_ARB_texture_non_power_of_two);
                    stringBuilder.append(" GL_EXT_framebuffer_object:").append(contextCapabilities.GL_EXT_framebuffer_object);
                    stringBuilder.append(" GL_ARB_draw_buffers:").append(contextCapabilities.GL_ARB_draw_buffers);
                    stringBuilder.append(" GL_ARB_vertex_program:").append(contextCapabilities.GL_ARB_vertex_program);
                    stringBuilder.append(" GL_ARB_fragment_program:").append(contextCapabilities.GL_ARB_fragment_program);
                    stringBuilder.append(" GLSL version:").append(string);
                }
                final String string2 = "<html><body>Error information:<br/>" + throwable.getMessage() + "<br/>" + "stack trace:<br/>" + string3 + "<br/>" + "Renderer Capabilities:<br/>" + stringBuilder.toString() + "</body></html>";
                JDialog jDialog = new JDialog(frame){
                    {
                        super(frame);
                        this.setContentPane(new JPanel(new GridLayout(1, 1)){
                            {
                                this.add(new JPanel(new GridBagLayout()){
                                    {
                                        this.add((Component)new VerticalLayoutPanel(){
                                            {
                                                this.add(new JLabel(PhetCommonResources.getString("Jme.thisSimulationWasUnableToStart")){
                                                    {
                                                        this.setFont(new PhetFont(20, true));
                                                        this.setForeground(Color.RED);
                                                    }
                                                });
                                                String string = "http://phet.colorado.edu/en/troubleshooting#3d-driver";
                                                String string2 = "<a href=\"" + string + "\">" + string + "</a>";
                                                String string3 = "phethelp@colorado.edu";
                                                String string4 = "<a href=\"mailto:" + string3 + "\">" + string3 + "</a>";
                                                String string5 = PhetCommonResources.getString("Jme.moreInformation");
                                                this.add(new HTMLUtils.InteractiveHTMLPane(MessageFormat.format(string5, string2, string4)){
                                                    {
                                                        this.setOpaque(false);
                                                        this.setFont(new PhetFont(16, true));
                                                    }
                                                });
                                            }
                                        }, new GridBagConstraints(){
                                            {
                                                this.fill = 2;
                                                this.insets = new Insets(10, 10, 10, 10);
                                            }
                                        });
                                        this.add((Component)new JScrollPane(new JEditorPane("text/html", string2){
                                            {
                                                this.setCaretPosition(0);
                                            }
                                        }), new GridBagConstraints(){
                                            {
                                                this.gridx = 0;
                                                this.gridy = 1;
                                                this.fill = 1;
                                                this.weightx = 1.0;
                                                this.weighty = 1.0;
                                            }
                                        });
                                        this.add((Component)new JButton(PhetCommonResources.getString("Jme.copyThisToTheClipboard")){
                                            {
                                                LWJGLUtils.setClipboard(string2);
                                            }
                                        }, new GridBagConstraints(){
                                            {
                                                this.gridy = 2;
                                                this.anchor = 22;
                                                this.insets = new Insets(5, 5, 5, 5);
                                            }
                                        });
                                        this.setPreferredSize(new Dimension(800, 600));
                                    }
                                });
                            }
                        });
                        this.pack();
                    }
                };
                SwingUtils.centerInParent(jDialog);
                jDialog.setVisible(true);
            }
        });
    }

    private static void setClipboard(String string) {
        StringSelection stringSelection = new StringSelection(string);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
    }
}

