/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.control;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2F;
import edu.colorado.phet.common.piccolophet.nodes.Spacer;
import edu.colorado.phet.platetectonics.PlateTectonicsResources;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.geom.Point2D;

public class CrustChooserPanel
extends PNode {
    private final int verticalOffset;
    private final Spacer continentalSpacer;
    private final Spacer youngOceanicSpacer;
    private final Spacer oldOceanicSpacer;

    public CrustChooserPanel() {
        PText pText = new PText(PlateTectonicsResources.Strings.CONTINENTAL_CRUST);
        PText pText2 = new PText(PlateTectonicsResources.Strings.YOUNG_OCEANIC_CRUST);
        PText pText3 = new PText(PlateTectonicsResources.Strings.OLD_OCEANIC_CRUST);
        this.addChild(pText);
        this.addChild(pText2);
        this.addChild(pText3);
        pText.setOffset((140.0 - pText.getFullBounds().getWidth()) / 2.0, 0.0);
        pText2.setOffset((140.0 - pText2.getFullBounds().getWidth()) / 2.0 + 20.0 + 140.0, 0.0);
        pText3.setOffset((140.0 - pText3.getFullBounds().getWidth()) / 2.0 + 320.0, 0.0);
        this.verticalOffset = (int)(pText.getFullBounds().getHeight() + 10.0);
        this.continentalSpacer = new Spacer(0.0, this.verticalOffset, 140.0, 100.0);
        this.addChild(this.continentalSpacer);
        this.youngOceanicSpacer = new Spacer(160.0, this.verticalOffset, 140.0, 100.0);
        this.addChild(this.youngOceanicSpacer);
        this.oldOceanicSpacer = new Spacer(320.0, this.verticalOffset, 140.0, 100.0);
        this.addChild(this.oldOceanicSpacer);
    }

    private Vector2F getPieceCenter(Spacer spacer) {
        Point2D point2D = spacer.localToGlobal(new Point2D.Double(spacer.getRectangle().getX() + 70.0, spacer.getRectangle().getY() + 50.0));
        return new Vector2F(point2D.getX(), point2D.getY());
    }

    public Vector2F getContinentalCenter() {
        return this.getPieceCenter(this.continentalSpacer);
    }

    public Vector2F getYoungOceanicCenter() {
        return this.getPieceCenter(this.youngOceanicSpacer);
    }

    public Vector2F getOldOceanicCenter() {
        return this.getPieceCenter(this.oldOceanicSpacer);
    }
}

