/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.control;

import edu.colorado.phet.common.phetcommon.math.DampedMassSpringSystem;
import edu.colorado.phet.common.phetcommon.math.Matrix4F;
import edu.colorado.phet.common.phetcommon.math.Ray3F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.common.phetcommon.model.event.ValueNotifier;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.Parameter;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterKeys;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.util.Option;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.PointSensor;
import edu.colorado.phet.common.piccolophet.nodes.SpeedometerNode;
import edu.colorado.phet.common.piccolophet.nodes.SpeedometerSensorNode;
import edu.colorado.phet.lwjglphet.LWJGLCursorHandler;
import edu.colorado.phet.lwjglphet.math.LWJGLTransform;
import edu.colorado.phet.lwjglphet.nodes.ThreadedPlanarPiccoloNode;
import edu.colorado.phet.lwjglphet.utils.LWJGLUtils;
import edu.colorado.phet.platetectonics.PlateTectonicsConstants;
import edu.colorado.phet.platetectonics.PlateTectonicsResources;
import edu.colorado.phet.platetectonics.PlateTectonicsSimSharing;
import edu.colorado.phet.platetectonics.control.DraggableTool2D;
import edu.colorado.phet.platetectonics.model.PlateTectonicsModel;
import edu.colorado.phet.platetectonics.model.ToolboxState;
import edu.colorado.phet.platetectonics.tabs.PlateMotionTab;
import edu.colorado.phet.platetectonics.tabs.PlateTectonicsTab;
import edu.colorado.phet.platetectonics.util.MortalSimpleObserver;
import edu.colorado.phet.platetectonics.util.MortalUpdateListener;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DensitySensorNode3D
extends ThreadedPlanarPiccoloNode
implements DraggableTool2D {
    public final ValueNotifier<DensitySensorNode3D> disposed = new ValueNotifier<DensitySensorNode3D>(this);
    private final LWJGLTransform modelViewTransform;
    private final PlateTectonicsTab tab;
    private final PlateTectonicsModel model;
    public Vector2F draggedPosition = new Vector2F();

    public DensitySensorNode3D(LWJGLTransform lWJGLTransform, final PlateTectonicsTab plateTectonicsTab, PlateTectonicsModel plateTectonicsModel) {
        super(new DensitySensorNode2D(lWJGLTransform.transformDeltaX(1000.0f), plateTectonicsTab){
            {
                super(f, plateTectonicsTab3);
                this.scale(DensitySensorNode3D.scaleMultiplier(plateTectonicsTab));
            }
        });
        this.modelViewTransform = lWJGLTransform;
        this.tab = plateTectonicsTab;
        this.model = plateTectonicsModel;
        plateTectonicsTab.zoomRatio.addObserver(new MortalSimpleObserver(plateTectonicsTab.zoomRatio, this.disposed){

            public void update() {
                Matrix4F matrix4F = Matrix4F.scaling(DensitySensorNode3D.this.getScale());
                Matrix4F matrix4F2 = Matrix4F.translation(DensitySensorNode3D.this.draggedPosition.x - DensitySensorNode3D.this.getSensorXOffset(), DensitySensorNode3D.this.draggedPosition.y, 0.0f);
                DensitySensorNode3D.this.transform.set(matrix4F2.times(matrix4F));
            }
        });
        this.setCursor(Cursor.getPredefinedCursor(12));
        plateTectonicsTab.beforeFrameRender.addUpdateListener(new MortalUpdateListener(plateTectonicsTab.beforeFrameRender, this.disposed){

            public void update() {
                DensitySensorNode3D.this.updateReadout();
            }
        }, true);
        this.addRepaintNotifier(plateTectonicsTab.beforeFrameRender);
        PlateTectonicsConstants.DIAL_HIGHLIGHT_COLOR.addObserver(new MortalSimpleObserver(PlateTectonicsConstants.DIAL_HIGHLIGHT_COLOR, this.disposed){

            public void update() {
                LWJGLUtils.invoke(new Runnable(){

                    public void run() {
                        DensitySensorNode3D.this.updateReadout();
                    }
                });
            }
        });
    }

    private float getScale() {
        return this.tab.getSceneDistanceZoomFactor() * 0.75f / 3.0f;
    }

    @Override
    public boolean allowsDrag(Vector2F vector2F) {
        Vector2F vector2F2 = new Vector2F(vector2F.x - this.draggedPosition.x + this.getSensorXOffset(), vector2F.y - this.draggedPosition.y);
        Vector2F vector2F3 = new Vector2F(vector2F2.getX() / this.getScale(), (float)this.getComponentHeight() - vector2F2.getY() / this.getScale());
        return true;
    }

    @Override
    public void dragDelta(Vector2F vector2F) {
        this.transform.prepend(Matrix4F.translation(vector2F.x, vector2F.y, 0.0f));
        this.draggedPosition = this.draggedPosition.plus(vector2F);
        this.updateReadout();
    }

    private void updateReadout() {
        Double d = this.getDensityValue();
        DensitySensorNode2D densitySensorNode2D = (DensitySensorNode2D)this.getNode();
        densitySensorNode2D.setDensity(d, this.tab.getTimeElapsed());
        this.repaint();
    }

    private Double getDensityValue() {
        Vector3F vector3F = this.getSensorModelPosition();
        double d = this.model.getDensity(vector3F.getX(), vector3F.getY());
        if (d < 50.0) {
            Vector3F vector3F2 = this.tab.getCameraPosition();
            Vector3F vector3F3 = this.getSensorViewPosition();
            Ray3F ray3F = new Ray3F(vector3F2, vector3F3.minus(vector3F2).normalized());
            d = this.model.rayTraceDensity(ray3F, this.modelViewTransform, this.tab.isWaterVisible());
        }
        return d;
    }

    @Override
    public Vector3F getSensorModelPosition() {
        return PlateTectonicsModel.convertToPlanar(this.modelViewTransform.inversePosition(this.getSensorViewPosition()));
    }

    @Override
    public Vector3F getSensorViewPosition() {
        return new Vector3F(this.draggedPosition.x, this.draggedPosition.y, 0.0f);
    }

    private float getSensorXOffset() {
        return (float)(((DensitySensorNode2D)this.getNode()).horizontalSensorOffset * (double)this.getScale() * (double)DensitySensorNode3D.scaleMultiplier(this.tab));
    }

    @Override
    public ParameterSet getCustomParameters() {
        return new ParameterSet(new Parameter((IParameterKey)ParameterKeys.value, this.getDensityValue()));
    }

    @Override
    public Property<Boolean> getInsideToolboxProperty(ToolboxState toolboxState) {
        return toolboxState.densitySensorInToolbox;
    }

    public Vector2F getInitialMouseOffset() {
        double d = this.getScale();
        return new Vector2F(0.0, DensitySensorNode2D.h / 3.0 * d);
    }

    @Override
    public IUserComponent getUserComponent() {
        return PlateTectonicsSimSharing.UserComponents.densityMeter;
    }

    @Override
    public void recycle() {
        super.recycle();
        this.getParent().removeChild(this);
        this.disposed.updateListeners();
    }

    private static int scaleMultiplier(PlateTectonicsTab plateTectonicsTab) {
        return plateTectonicsTab instanceof PlateMotionTab ? 3 : 1;
    }

    public static class DensitySensorNode2D
    extends SpeedometerSensorNode {
        public final double horizontalSensorOffset;
        public static double w;
        public static double h;
        private final PNode extraHolderNode = new PNode();
        private double p = 0.0;
        private double d = 0.0;
        private double k = 70.0;
        private double mass = 1.0;
        private double c = DampedMassSpringSystem.getCriticallyDampedDamping(this.mass, this.k);
        private final double ringOffset = 1.0;
        private final double ringWidth = 10.0;
        private final double ringInnerOffset = 11.0;

        public DensitySensorNode2D(float f, PlateTectonicsTab plateTectonicsTab) {
            super(ModelViewTransform.createIdentity(), new PointSensor<Double>(0.0, 0.0){
                {
                    this.value.set(new Option.Some<Double>(0.0));
                }
            }, PlateTectonicsResources.Strings.DENSITY_VIEW, 3500.0);
            w = this.getFullBounds().getWidth();
            h = this.getFullBounds().getHeight();
            this.addChild(this.extraHolderNode);
            this.scale(3.0f * f / 3.0f);
            this.horizontalSensorOffset = this.getFullBounds().getWidth() / 2.0;
            this.addInputEventListener(new LWJGLCursorHandler());
        }

        public void setDensity(double d, double d2) {
            this.extraHolderNode.removeAllChildren();
            final double d3 = -this.bodyNode.speedToAngle(0.0);
            final double d4 = -this.bodyNode.speedToAngle(3500.0);
            double d5 = Math.abs(d3 - d4) / 3500.0;
            double d6 = (-d4 + d3) / d5;
            DampedMassSpringSystem dampedMassSpringSystem = new DampedMassSpringSystem(this.mass, this.k, this.c, this.p - d, this.d);
            this.p = dampedMassSpringSystem.evaluatePosition(d2) + d;
            this.d = dampedMassSpringSystem.evaluateVelocity(d2);
            double d7 = this.p % d6;
            this.pointSensor.value.set(new Option.Some<Double>(d7));
            int n = (int)Math.floor(this.p / d6);
            if (n < 0) {
                n = 0;
                this.pointSensor.value.set(new Option.Some<Double>(0.0));
            }
            this.bodyNode.underTicksLayer.removeAllChildren();
            PhetPPath phetPPath = this.createRingNode(-this.bodyNode.speedToAngle(d7));
            this.bodyNode.underTicksLayer.addChild(phetPPath);
            this.extraHolderNode.removeAllChildren();
            int n2 = 0;
            while (n2 < n) {
                final int n3 = n2++;
                this.extraHolderNode.addChild(new SpeedometerNode("", 100.0, new Property<Option.Some<Double>>(new Option.Some<Double>(3500.0)), 3500.0){
                    {
                        super(string, d, observableProperty, d2);
                        this.setOffset(110 + n3 * 50, 0.0);
                        this.scale(0.4);
                        double d5 = 0.8;
                        final double d6 = d4 + 0.3;
                        this.underTicksLayer.addChild(DensitySensorNode2D.this.createRingNode(d4));
                        this.addChild(new PhetPPath(new Arc2D.Double(25.0, 25.0, 50.0, 50.0, Math.toDegrees(d3), Math.toDegrees(d6 - d3), 0), null, new BasicStroke(3.0f), Color.RED));
                        this.addChild(new PPath(){
                            {
                                GeneralPath generalPath = new GeneralPath();
                                double d2 = d6 - 0.1;
                                double d3 = d6 + 0.4;
                                generalPath.moveTo(Math.cos(d2) * 25.0, -Math.sin(d2) * 25.0);
                                generalPath.lineTo(Math.cos(d3) * 25.0 * 0.75, -Math.sin(d3) * 25.0 * 0.75);
                                generalPath.lineTo(Math.cos(d3) * 25.0 * 1.25, -Math.sin(d3) * 25.0 * 1.25);
                                this.setPathTo(generalPath);
                                this.setOffset(50.0, 50.0);
                                this.setPaint(Color.RED);
                                this.setStrokePaint(null);
                            }
                        });
                    }
                });
            }
        }

        private PhetPPath createRingNode(final double d) {
            final double d2 = -this.bodyNode.speedToAngle(0.0);
            Color color = PlateTectonicsConstants.DIAL_HIGHLIGHT_COLOR.get();
            Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 255);
            return new PhetPPath(new Area(new Ellipse2D.Double(1.0, 1.0, 98.0, 98.0)){
                {
                    super(shape);
                    this.subtract(new Area(new Ellipse2D.Double(11.0, 11.0, 78.0, 78.0)));
                    double d3 = (d - d2) % (Math.PI * 2);
                    this.intersect(new Area(new Arc2D.Double(0.0, 0.0, 100.0, 100.0, 180.0 * d2 / Math.PI, 180.0 * d3 / Math.PI, 2)));
                }
            }, color2, null, null);
        }
    }
}

