/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.control;

import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.components.SimSharingJSlider;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.lwjglphet.utils.LWJGLUtils;
import edu.colorado.phet.platetectonics.PlateTectonicsResources;
import edu.colorado.phet.platetectonics.PlateTectonicsSimSharing;
import edu.colorado.phet.platetectonics.model.CrustModel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.pswing.PSwing;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MyCrustPanel
extends PNode {
    private static final PhetFont sliderTitleFont = new PhetFont(14);
    private static final PhetFont limitFont = new PhetFont(10);
    private final SliderNode temperatureSlider;
    private final SliderNode compositionSlider;
    private final SliderNode thicknessSlider;

    public MyCrustPanel(CrustModel crustModel) {
        PText pText = new PText(PlateTectonicsResources.Strings.MY_CRUST){
            {
                this.setFont(new PhetFont(16, true));
            }
        };
        this.temperatureSlider = new SliderNode(PlateTectonicsSimSharing.UserComponents.temperatureSlider, PlateTectonicsResources.Strings.TEMPERATURE, PlateTectonicsResources.Strings.COOL, PlateTectonicsResources.Strings.WARM, crustModel.temperatureRatio, 0.0, 1.0);
        this.compositionSlider = new SliderNode(PlateTectonicsSimSharing.UserComponents.compositionSlider, PlateTectonicsResources.Strings.COMPOSITION, PlateTectonicsResources.Strings.MORE_IRON, PlateTectonicsResources.Strings.MORE_SILICA, crustModel.compositionRatio, 0.0, 1.0);
        this.thicknessSlider = new SliderNode(PlateTectonicsSimSharing.UserComponents.thicknessSlider, PlateTectonicsResources.Strings.THICKNESS, PlateTectonicsResources.Strings.THIN, PlateTectonicsResources.Strings.THICK, crustModel.thickness, 4000.0, 70000.0);
        pText.setOffset(((double)this.temperatureSlider.getSlider().getWidth() - pText.getFullBounds().getWidth()) / 2.0, 0.0);
        this.temperatureSlider.setOffset(0.0, pText.getFullBounds().getMaxY() + 10.0);
        this.compositionSlider.setOffset(0.0, this.temperatureSlider.getFullBounds().getMaxY() + 10.0);
        this.thicknessSlider.setOffset(0.0, this.compositionSlider.getFullBounds().getMaxY() + 10.0);
        this.addChild(pText);
        this.addChild(this.temperatureSlider);
        this.addChild(this.compositionSlider);
        this.addChild(this.thicknessSlider);
    }

    public void resetAll() {
        this.temperatureSlider.getProperty().reset();
        this.compositionSlider.getProperty().reset();
        this.thicknessSlider.getProperty().reset();
        final int n = this.temperatureSlider.getInitialValue();
        final int n2 = this.compositionSlider.getInitialValue();
        final int n3 = this.thicknessSlider.getInitialValue();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MyCrustPanel.this.temperatureSlider.setValue(n);
                MyCrustPanel.this.compositionSlider.setValue(n2);
                MyCrustPanel.this.thicknessSlider.setValue(n3);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SliderNode
    extends PNode {
        private JSlider slider;
        private final Property<Double> property;
        private final double min;
        private final double max;

        private SliderNode(IUserComponent iUserComponent, String string, String string2, String string3, final Property<Double> property, double d, double d2) {
            this.property = property;
            this.min = d;
            this.max = d2;
            PText pText = new PText(string){
                {
                    this.setFont(sliderTitleFont);
                }
            };
            PText pText2 = new PText(string2){
                {
                    this.setFont(limitFont);
                }
            };
            PText pText3 = new PText(string3){
                {
                    this.setFont(limitFont);
                }
            };
            this.slider = new SimSharingJSlider(iUserComponent, 0, 4096, this.getInitialValue()){
                {
                    this.setPaintTicks(true);
                }
            };
            PSwing pSwing = new PSwing(this.slider);
            pText.setOffset((pSwing.getFullBounds().getWidth() - pText.getFullBounds().getWidth()) / 2.0, 0.0);
            pSwing.setOffset(0.0, pText.getFullBounds().getMaxY());
            pText2.setOffset(-pText2.getFullBounds().getWidth() / 2.0, pSwing.getFullBounds().getMaxY() - 5.0);
            pText3.setOffset(pSwing.getFullBounds().getWidth() - pText3.getFullBounds().getWidth() / 2.0, pSwing.getFullBounds().getMaxY() - 5.0);
            this.addChild(pText);
            this.addChild(pText2);
            this.addChild(pText3);
            this.addChild(pSwing);
            this.slider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    final double d = SliderNode.this.getValue();
                    LWJGLUtils.invoke(new Runnable(){

                        public void run() {
                            property.set(d);
                        }
                    });
                }
            });
        }

        public int getInitialValue() {
            double d = (this.property.get() - this.min) / (this.max - this.min);
            return (int)(d * 4096.0);
        }

        private double getValue() {
            double d = (double)this.slider.getValue() / 4096.0;
            return this.min + d * (this.max - this.min);
        }

        public void setValue(int n) {
            this.slider.setValue(n);
        }

        public JSlider getSlider() {
            return this.slider;
        }

        public Property<Double> getProperty() {
            return this.property;
        }
    }
}

