/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.control;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.layout.HBox;
import edu.colorado.phet.common.piccolophet.nodes.layout.VBox;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.DefaultIconButton;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.PlayPauseButton;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.StepButton;
import edu.colorado.phet.common.piccolophet.nodes.slider.HSliderNode;
import edu.colorado.phet.lwjglphet.utils.GLSwingForwardingClock;
import edu.colorado.phet.lwjglphet.utils.LWJGLUtils;
import edu.colorado.phet.platetectonics.PlateTectonicsConstants;
import edu.colorado.phet.platetectonics.PlateTectonicsResources;
import edu.colorado.phet.platetectonics.PlateTectonicsSimSharing;
import edu.colorado.phet.platetectonics.model.TectonicsClock;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.text.DecimalFormat;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TectonicsTimeControl
extends PNode {
    private Property<Double> speedProperty = new Property<Double>(1.0);
    private final TectonicsClock lwjglClock;
    private final HBox container;

    public TectonicsTimeControl(final TectonicsClock tectonicsClock, final Property<Boolean> property) {
        this.lwjglClock = tectonicsClock;
        final GLSwingForwardingClock gLSwingForwardingClock = new GLSwingForwardingClock(tectonicsClock);
        final DecimalFormat decimalFormat = new DecimalFormat("0");
        final TimeSlider timeSlider = new TimeSlider(tectonicsClock, property);
        final PlayPauseButton playPauseButton = new PlayPauseButton(49){
            {
                super(n);
                this.setPlaying(!gLSwingForwardingClock.isPaused());
                this.addListener(new PlayPauseButton.Listener(){

                    public void playbackStateChanged() {
                        if (gLSwingForwardingClock.isPaused()) {
                            gLSwingForwardingClock.start();
                        } else {
                            gLSwingForwardingClock.pause();
                        }
                    }
                });
                tectonicsClock.addClockListener(new ClockAdapter(){

                    public void clockStarted(ClockEvent clockEvent) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                this.setPlaying(true);
                            }
                        });
                    }

                    public void clockPaused(ClockEvent clockEvent) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                this.setPlaying(false);
                            }
                        });
                    }

                    public void simulationTimeChanged(ClockEvent clockEvent) {
                        final boolean bl = TectonicsTimeControl.this.isAtTimeLimit();
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                this.setEnabled(!bl);
                                if (bl) {
                                    this.setPlaying(false);
                                }
                            }
                        });
                    }
                });
            }
        };
        final StepButton stepButton = new StepButton((int)(playPauseButton.getButtonDimension().width * 0.8)){
            {
                super(n);
                this.addListener(new DefaultIconButton.Listener(){

                    public void buttonPressed() {
                        gLSwingForwardingClock.stepClockWhilePaused();
                    }
                });
                tectonicsClock.addClockListener(new ClockAdapter(){

                    private boolean shouldBeEnabled() {
                        return tectonicsClock.isPaused() && !TectonicsTimeControl.this.isAtTimeLimit();
                    }

                    private void updateState() {
                        final boolean bl = this.shouldBeEnabled();
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                this.setEnabled(bl);
                            }
                        });
                    }

                    public void clockStarted(ClockEvent clockEvent) {
                        this.updateState();
                    }

                    public void clockPaused(ClockEvent clockEvent) {
                        this.updateState();
                    }

                    public void simulationTimeChanged(ClockEvent clockEvent) {
                        this.updateState();
                    }
                });
            }
        };
        this.container = new HBox(12.0, HBox.CENTER_ALIGNED, new VBox(VBox.CENTER_ALIGNED, new PText(PlateTectonicsResources.Strings.TIME_ELAPSED){
            {
                this.setFont(PlateTectonicsConstants.PANEL_TITLE_FONT);
            }
        }, new HBox(12.0, HBox.CENTER_ALIGNED, new PText("0"){
            {
                super(string);
                tectonicsClock.addClockListener(new ClockAdapter(){

                    public void simulationTimeChanged(ClockEvent clockEvent) {
                        final double d = tectonicsClock.getSimulationTime();
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                this.setText(decimalFormat.format(d));
                                this.repaint();
                            }
                        });
                    }
                });
            }
        }, new PText(PlateTectonicsResources.Strings.MILLION_YEARS){
            {
                this.setFont(new PhetFont(12));
            }
        })), timeSlider, playPauseButton, stepButton);
        this.addChild(this.container);
        property.addObserver(new SimpleObserver(){

            public void update() {
                final boolean bl = (Boolean)property.get();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        TectonicsTimeControl.this.setChild(timeSlider, bl);
                        TectonicsTimeControl.this.setChild(playPauseButton, bl);
                        TectonicsTimeControl.this.setChild(stepButton, bl);
                        TectonicsTimeControl.this.repaint();
                        final double d = (Double)TectonicsTimeControl.this.speedProperty.get();
                        LWJGLUtils.invoke(new Runnable(){

                            public void run() {
                                tectonicsClock.setTimeMultiplier(bl ? d : 1.0);
                            }
                        });
                    }
                });
            }
        });
    }

    private void setChild(PNode pNode, boolean bl) {
        if (this.container == null) {
            return;
        }
        if (bl && pNode.getParent() == null) {
            this.container.addChild(pNode);
        }
        if (!bl && pNode.getParent() != null) {
            this.container.removeChild(pNode);
        }
    }

    public void resetAll() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TectonicsTimeControl.this.speedProperty.reset();
            }
        });
    }

    private boolean isAtTimeLimit() {
        return this.lwjglClock.getSimulationTime() >= this.lwjglClock.getTimeLimit();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TimeSlider
    extends HSliderNode {
        public TimeSlider(final TectonicsClock tectonicsClock, Property<Boolean> property) {
            super(PlateTectonicsSimSharing.UserComponents.timeSpeedSlider, 0.1, 10.0, 5.0, 100.0, TectonicsTimeControl.this.speedProperty, new Property<Boolean>(true));
            this.addLabel(0.1, new PText(PlateTectonicsResources.Strings.TIME_SLOW));
            this.addLabel(10.0, new PText(PlateTectonicsResources.Strings.TIME_FAST));
            TectonicsTimeControl.this.speedProperty.addObserver(new SimpleObserver(){

                public void update() {
                    LWJGLUtils.invoke(new Runnable(){

                        public void run() {
                            tectonicsClock.setTimeMultiplier((Double)TectonicsTimeControl.this.speedProperty.get());
                        }
                    });
                }
            });
        }
    }
}

