/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.control;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.Matrix4F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.common.phetcommon.model.event.ValueNotifier;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.Parameter;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterKeys;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.common.piccolophet.nodes.LiquidExpansionThermometerNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.lwjglphet.LWJGLCursorHandler;
import edu.colorado.phet.lwjglphet.math.LWJGLTransform;
import edu.colorado.phet.lwjglphet.nodes.ThreadedPlanarPiccoloNode;
import edu.colorado.phet.platetectonics.PlateTectonicsSimSharing;
import edu.colorado.phet.platetectonics.control.DraggableTool2D;
import edu.colorado.phet.platetectonics.model.PlateTectonicsModel;
import edu.colorado.phet.platetectonics.model.ToolboxState;
import edu.colorado.phet.platetectonics.tabs.PlateMotionTab;
import edu.colorado.phet.platetectonics.tabs.PlateTectonicsTab;
import edu.colorado.phet.platetectonics.util.MortalSimpleObserver;
import edu.colorado.phet.platetectonics.util.MortalUpdateListener;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThermometerNode3D
extends ThreadedPlanarPiccoloNode
implements DraggableTool2D {
    public final ValueNotifier<ThermometerNode3D> disposed = new ValueNotifier<ThermometerNode3D>(this);
    private final LWJGLTransform modelViewTransform;
    private final PlateTectonicsTab tab;
    private final PlateTectonicsModel model;
    private final float sensorVerticalOffset;
    public Vector2F draggedPosition = new Vector2F();

    public ThermometerNode3D(LWJGLTransform lWJGLTransform, final PlateTectonicsTab plateTectonicsTab, PlateTectonicsModel plateTectonicsModel) {
        super(new ThermometerNode2D(lWJGLTransform.transformDeltaX(1000.0f)){
            {
                super(f);
                this.scale(ThermometerNode3D.scaleMultiplier(plateTectonicsTab));
            }
        });
        this.modelViewTransform = lWJGLTransform;
        this.tab = plateTectonicsTab;
        this.model = plateTectonicsModel;
        this.sensorVerticalOffset = (float)((ThermometerNode2D)this.getNode()).sensorVerticalOffset;
        plateTectonicsTab.zoomRatio.addObserver(new MortalSimpleObserver(plateTectonicsTab.zoomRatio, this.disposed){

            public void update() {
                Matrix4F matrix4F = Matrix4F.scaling(ThermometerNode3D.this.getScale());
                Matrix4F matrix4F2 = Matrix4F.translation(ThermometerNode3D.this.draggedPosition.x, ThermometerNode3D.this.draggedPosition.y - ThermometerNode3D.this.sensorVerticalOffset * ThermometerNode3D.this.getScale() * (float)ThermometerNode3D.scaleMultiplier(plateTectonicsTab), 0.0f);
                ThermometerNode3D.this.transform.set(matrix4F2.times(matrix4F));
                ((LiquidExpansionThermometerNode)ThermometerNode3D.this.getNode()).setTicks(10.0f / ThermometerNode3D.this.getTemperatureScale(), Color.BLACK, 1.0f);
            }
        });
        this.setCursor(Cursor.getPredefinedCursor(12));
        plateTectonicsModel.modelChanged.addUpdateListener(new MortalUpdateListener(plateTectonicsModel.modelChanged, this.disposed){

            public void update() {
                double d = ThermometerNode3D.this.getTemperatureValue();
                ThermometerNode3D.this.updateLiquidHeight(d);
            }
        }, true);
        this.addRepaintNotifier(plateTectonicsTab.beforeFrameRender);
    }

    private float getTemperatureScale() {
        return 1.0f;
    }

    private float getScale() {
        return this.tab.getSceneDistanceZoomFactor() / 3.0f;
    }

    @Override
    public boolean allowsDrag(Vector2F vector2F) {
        return true;
    }

    @Override
    public void dragDelta(Vector2F vector2F) {
        this.transform.prepend(Matrix4F.translation(vector2F.x, vector2F.y, 0.0f));
        this.draggedPosition = this.draggedPosition.plus(vector2F);
        double d = this.getTemperatureValue();
        this.updateLiquidHeight(d);
    }

    private void updateLiquidHeight(double d) {
        ThermometerNode2D thermometerNode2D = (ThermometerNode2D)this.getNode();
        thermometerNode2D.setTemperature(d);
        this.repaint();
    }

    private Double getTemperatureValue() {
        Vector3F vector3F = this.getSensorModelPosition();
        return this.model.getTemperature(vector3F.getX(), vector3F.getY());
    }

    @Override
    public Vector3F getSensorModelPosition() {
        return PlateTectonicsModel.convertToPlanar(this.modelViewTransform.inversePosition(this.getSensorViewPosition()));
    }

    @Override
    public Vector3F getSensorViewPosition() {
        return new Vector3F(this.draggedPosition.x, this.draggedPosition.y, 0.0f);
    }

    @Override
    public ParameterSet getCustomParameters() {
        return new ParameterSet(new Parameter((IParameterKey)ParameterKeys.value, this.getTemperatureValue()));
    }

    @Override
    public Property<Boolean> getInsideToolboxProperty(ToolboxState toolboxState) {
        return toolboxState.thermometerInToolbox;
    }

    public Vector2F getInitialMouseOffset() {
        double d = this.getScale();
        return new Vector2F(this.getNode().getFullBounds().getWidth() / 2.0 * d, 0.0);
    }

    @Override
    public IUserComponent getUserComponent() {
        return PlateTectonicsSimSharing.UserComponents.thermometer;
    }

    @Override
    public void recycle() {
        super.recycle();
        this.getParent().removeChild(this);
        this.disposed.updateListeners();
    }

    private static int scaleMultiplier(PlateTectonicsTab plateTectonicsTab) {
        return plateTectonicsTab instanceof PlateMotionTab ? 3 : 1;
    }

    public static class ThermometerNode2D
    extends LiquidExpansionThermometerNode {
        public final double sensorVerticalOffset;
        private final PNode extraThermometerHolderNode = new PNode();
        private static final PDimension THERMOMETER_DIMENSION = new PDimension(40.0, 120.0);

        public ThermometerNode2D(float f) {
            super(THERMOMETER_DIMENSION);
            double d = this.getFullBounds().getHeight() - this.getBulbDiameter() / 2.0;
            this.addChild(new PhetPPath(new DoubleGeneralPath(-8.0, d){
                {
                    this.lineToRelative(5.0, 5.0);
                    this.lineToRelative(0.0, -10.0);
                    this.lineToRelative(-5.0, 5.0);
                }
            }.getGeneralPath(), Color.RED, new BasicStroke(1.0f), Color.BLACK));
            this.addChild(this.extraThermometerHolderNode);
            this.scale(3.0f * f / 3.0f);
            this.sensorVerticalOffset = this.getBulbDiameter() / 2.0 * this.getScale();
            this.addInputEventListener(new LWJGLCursorHandler());
        }

        public void setTemperature(double d) {
            double d2 = d / 2000.0;
            int n = (int)Math.floor(d2);
            double d3 = MathUtil.clamp(0.2, new Function.LinearFunction(0.0, 1.0, 0.2, 0.9).evaluate(d2 % 1.0), 0.9);
            this.setLiquidHeight(d3);
            this.extraThermometerHolderNode.removeAllChildren();
            int n2 = 0;
            while (n2 < n) {
                final int n3 = n2++;
                this.extraThermometerHolderNode.addChild(new LiquidExpansionThermometerNode(THERMOMETER_DIMENSION){
                    {
                        super(pDimension);
                        this.setOffset(45 + n3 * 30, 0.0);
                        this.scale(0.4);
                        this.setLiquidHeight(0.9);
                    }
                });
            }
        }
    }
}

