/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.control;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2F;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.Parameter;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterKeys;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserActions;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.platetectonics.PlateTectonicsSimSharing;
import edu.colorado.phet.platetectonics.control.DraggableTool2D;
import edu.colorado.phet.platetectonics.model.ToolboxState;

public class ToolDragHandler {
    private boolean dragging = false;
    private DraggableTool2D tool;
    private Vector2F lastPosition;
    private ToolboxState toolboxState;

    public ToolDragHandler(ToolboxState toolboxState) {
        this.toolboxState = toolboxState;
    }

    public void mouseDownOnTool(DraggableTool2D draggableTool2D, Vector2F vector2F) {
        if (draggableTool2D.allowsDrag(vector2F)) {
            this.startDragging(draggableTool2D, vector2F);
        }
    }

    public void startDragging(DraggableTool2D draggableTool2D, Vector2F vector2F) {
        this.tool = draggableTool2D;
        this.lastPosition = new Vector2F(vector2F);
        this.dragging = true;
        draggableTool2D.dragDelta(new Vector2F(0.0f, 0.0f));
        SimSharingManager.sendUserMessage(draggableTool2D.getUserComponent(), UserComponentTypes.sprite, UserActions.startDrag, ToolDragHandler.getToolLocationParameterSet(draggableTool2D));
    }

    public void mouseUp(boolean bl) {
        if (this.dragging) {
            SimSharingManager.sendUserMessage(this.tool.getUserComponent(), UserComponentTypes.sprite, UserActions.endDrag, ToolDragHandler.getToolLocationParameterSet(this.tool));
            if (bl) {
                this.putToolBackInToolbox(this.tool);
            }
        }
        this.dragging = false;
    }

    public void mouseMove(Vector2F vector2F) {
        if (this.dragging) {
            this.tool.dragDelta(vector2F.minus(this.lastPosition));
            this.lastPosition = vector2F;
            SimSharingManager.sendUserMessage(this.tool.getUserComponent(), UserComponentTypes.sprite, UserActions.drag, ToolDragHandler.getToolLocationParameterSet(this.tool));
        }
    }

    public void putToolBackInToolbox(DraggableTool2D draggableTool2D) {
        draggableTool2D.recycle();
        draggableTool2D.getInsideToolboxProperty(this.toolboxState).set(true);
        SimSharingManager.sendUserMessage(draggableTool2D.getUserComponent(), UserComponentTypes.sprite, PlateTectonicsSimSharing.UserActions.putBackInToolbox);
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public DraggableTool2D getDraggedTool() {
        return this.tool;
    }

    private static ParameterSet getToolLocationParameterSet(DraggableTool2D draggableTool2D) {
        return new ParameterSet(new Parameter[]{new Parameter((IParameterKey)ParameterKeys.x, draggableTool2D.getSensorModelPosition().x), new Parameter((IParameterKey)ParameterKeys.y, draggableTool2D.getSensorModelPosition().y), new Parameter((IParameterKey)ParameterKeys.z, draggableTool2D.getSensorModelPosition().z)}).with(draggableTool2D.getCustomParameters());
    }
}

