/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.control;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.piccolophet.nodes.ControlPanelNode;
import edu.colorado.phet.common.piccolophet.nodes.kit.ZeroOffsetNode;
import edu.colorado.phet.lwjglphet.LWJGLTab;
import edu.colorado.phet.lwjglphet.nodes.OrthoPiccoloNode;
import edu.colorado.phet.lwjglphet.utils.LWJGLUtils;
import edu.colorado.phet.platetectonics.PlateTectonicsConstants;
import edu.colorado.phet.platetectonics.PlateTectonicsResources;
import edu.colorado.phet.platetectonics.control.DensitySensorNode3D;
import edu.colorado.phet.platetectonics.control.RulerNode3D;
import edu.colorado.phet.platetectonics.control.ThermometerNode3D;
import edu.colorado.phet.platetectonics.model.ToolboxState;
import edu.colorado.phet.platetectonics.tabs.PlateTectonicsTab;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PText;

public class ToolboxNode
extends OrthoPiccoloNode {
    public ToolboxNode(final PlateTectonicsTab plateTectonicsTab, final ToolboxState toolboxState) {
        super(new ControlPanelNode(new PNode(){
            {
                final ZeroOffsetNode zeroOffsetNode = new ZeroOffsetNode((PNode)new RulerNode3D.RulerNode2D(0.75f, plateTectonicsTab){
                    {
                        toolboxState.rulerInToolbox.addObserver(LWJGLUtils.swingObserver(new Runnable(){

                            public void run() {
                                this.setVisible(toolboxState.rulerInToolbox.get());
                            }
                        }));
                        this.addInputEventListener(new PBasicInputEventHandler(){

                            public void mousePressed(PInputEvent pInputEvent) {
                                LWJGLUtils.invoke(new Runnable(){

                                    public void run() {
                                        toolboxState.rulerInToolbox.set(false);
                                    }
                                });
                            }
                        });
                        this.scale(0.5);
                    }
                });
                this.addChild(zeroOffsetNode);
                final ZeroOffsetNode zeroOffsetNode2 = new ZeroOffsetNode((PNode)new ThermometerNode3D.ThermometerNode2D(0.75f)){
                    {
                        super(pNode);
                        this.setOffset(zeroOffsetNode.getFullBounds().getWidth() + 5.0, zeroOffsetNode.getFullBounds().getMaxY() - this.getFullBounds().getHeight());
                        toolboxState.thermometerInToolbox.addObserver(LWJGLUtils.swingObserver(new Runnable(){

                            public void run() {
                                this.setVisible(toolboxState.thermometerInToolbox.get());
                            }
                        }));
                        this.addInputEventListener(new PBasicInputEventHandler(){

                            public void mousePressed(PInputEvent pInputEvent) {
                                LWJGLUtils.invoke(new Runnable(){

                                    public void run() {
                                        toolboxState.thermometerInToolbox.set(false);
                                    }
                                });
                            }
                        });
                    }
                };
                this.addChild(zeroOffsetNode2);
                ZeroOffsetNode zeroOffsetNode3 = new ZeroOffsetNode((PNode)new DensitySensorNode3D.DensitySensorNode2D(0.75f, plateTectonicsTab)){
                    {
                        super(pNode);
                        this.setOffset(zeroOffsetNode2.getFullBounds().getMaxX() + 5.0, zeroOffsetNode.getFullBounds().getMaxY() - this.getFullBounds().getHeight());
                        toolboxState.densitySensorInToolbox.addObserver(LWJGLUtils.swingObserver(new Runnable(){

                            public void run() {
                                this.setVisible(toolboxState.densitySensorInToolbox.get());
                            }
                        }));
                        this.addInputEventListener(new PBasicInputEventHandler(){

                            public void mousePressed(PInputEvent pInputEvent) {
                                LWJGLUtils.invoke(new Runnable(){

                                    public void run() {
                                        toolboxState.densitySensorInToolbox.set(false);
                                    }
                                });
                            }
                        });
                    }
                };
                this.addChild(zeroOffsetNode3);
                this.addChild(new PText(PlateTectonicsResources.Strings.TOOLBOX){
                    {
                        super(string);
                        this.setFont(PlateTectonicsConstants.PANEL_TITLE_FONT);
                        this.setOffset(zeroOffsetNode.getFullBounds().getWidth() + 10.0, 0.0);
                    }
                });
            }
        }), (LWJGLTab)plateTectonicsTab, plateTectonicsTab.getCanvasTransform(), new Property<Vector2D>(new Vector2D()), plateTectonicsTab.mouseEventNotifier);
    }
}

