/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.control;

import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.piccolophet.nodes.slider.VSliderNode;
import edu.colorado.phet.lwjglphet.utils.SwingForwardingProperty;
import edu.colorado.phet.platetectonics.PlateTectonicsResources;
import edu.colorado.phet.platetectonics.PlateTectonicsSimSharing;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZoomPanel
extends PNode {
    private final SwingForwardingProperty<Double> swingZoomRatio;
    private final Property<Double> zoomRatio;

    public ZoomPanel(Property<Double> property) {
        this.zoomRatio = property;
        final PText pText = new PText(PlateTectonicsResources.Strings.ZOOM);
        this.swingZoomRatio = new SwingForwardingProperty<Double>(property);
        VSliderNode vSliderNode = new VSliderNode(PlateTectonicsSimSharing.UserComponents.zoomSlider, 0.0, 1.0, 6.0, 100.0, this.swingZoomRatio, new Property<Boolean>(true)){
            {
                super(iUserComponent, d, d2, d3, d4, settableProperty, observableProperty);
                this.setOffset((pText.getFullBounds().getWidth() - this.getFullBounds().getWidth()) / 2.0, pText.getFullBounds().getMaxY() + 10.0);
            }
        };
        this.addChild(pText);
        this.addChild(vSliderNode);
    }

    public void resetAll() {
        this.zoomRatio.reset();
        final double d = this.zoomRatio.get();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ZoomPanel.this.swingZoomRatio.set(d);
                ZoomPanel.this.repaint();
            }
        });
    }
}

