/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.model;

import edu.colorado.phet.common.phetcommon.math.Bounds3F;
import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.platetectonics.model.PlateTectonicsModel;
import edu.colorado.phet.platetectonics.model.Sample;
import edu.colorado.phet.platetectonics.model.Terrain;
import edu.colorado.phet.platetectonics.model.TerrainConnectorStrip;
import edu.colorado.phet.platetectonics.model.TerrainSample;
import edu.colorado.phet.platetectonics.model.TextureStrategy;
import edu.colorado.phet.platetectonics.model.regions.CrossSectionStrip;
import edu.colorado.phet.platetectonics.util.PiecewiseLinearFunction2D;
import edu.colorado.phet.platetectonics.util.Side;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrustModel
extends PlateTectonicsModel {
    private static final double LEFT_OCEANIC_ELEVATION = CrustModel.computeCrustElevation(7000.0, 3000.0);
    private static final double RIGHT_CONTINENTAL_ELEVATION = CrustModel.computeCrustElevation(45000.0, 2700.0);
    public final Property<Double> temperatureRatio = new Property<Double>(0.5);
    public final Property<Double> compositionRatio = new Property<Double>(0.5);
    public final Property<Double> thickness = new Property<Double>(20000.0);
    private final Terrain oceanicTerrain;
    private final Terrain middleTerrain;
    private final Terrain continentalTerrain;
    private final List<TerrainConnectorStrip> terrainConnectors = new ArrayList<TerrainConnectorStrip>();
    private double crustElevation = this.computeIdealCrustElevation();
    private double crustVelocity = 0.0;
    private static final int[] mantleDepthDensity = new int[]{0, 1020, 3, 2600, 15, 2900, 25, 3381, 71, 3376, 171, 3364, 220, 3436, 271, 3466, 371, 3526, 400, 3723, 471, 3813, 571, 3939, 670, 4381, 771, 4443, 871, 4503, 971, 4563, 1071, 4621, 1171, 4678, 1271, 4734, 1371, 4789, 1471, 4844, 1571, 4897, 1671, 4950, 1771, 5003, 1871, 5054, 1971, 5106, 2071, 5157, 2171, 5207, 2271, 5257, 2371, 5307, 2471, 5357, 2571, 5407, 2671, 5457, 2771, 5506, 2871, 5556, 2891, 5566};
    private CrossSectionStrip middleCrustStrip;
    private SimpleObserver middleUpdateObserver;
    private CrossSectionStrip middleMantleStrip;
    private static final Function.LinearFunction OUTER_CORE_DENSITY_FUNCTION = new Function.LinearFunction(-5180000.0, -2921000.0, 12800.0, 10000.0);
    private static final Function.LinearFunction INNER_CORE_DENSITY_FUNCTION = new Function.LinearFunction(-6371000.0, -5180000.0, 13100.0, 12800.0);
    private static PiecewiseLinearFunction2D simplifiedContinentalDifference = new PiecewiseLinearFunction2D(new Vector2D(0.0, 0.0), new Vector2D(40000.0, 500.0), new Vector2D(150000.0, 1250.0), new Vector2D(250000.0, 2000.0), new Vector2D(2700000.0, 3400.0), new Vector2D(2890000.0, 4000.0), new Vector2D(6371000.0, 5778.0));
    private static PiecewiseLinearFunction2D simplifiedOceanicDifference = new PiecewiseLinearFunction2D(new Vector2D(0.0, 0.0), new Vector2D(50000.0, 1000.0), new Vector2D(100000.0, 1500.0), new Vector2D(150000.0, 1600.0), new Vector2D(250000.0, 2000.0), new Vector2D(2700000.0, 3400.0), new Vector2D(2890000.0, 4000.0), new Vector2D(6371000.0, 5778.0));

    public CrustModel(final Bounds3F bounds3F) {
        super(bounds3F, new TextureStrategy(2.0E-5f));
        int n;
        this.oceanicTerrain = new Terrain(20, bounds3F.getMinZ(), bounds3F.getMaxZ()){
            {
                super(n, f, f2);
                for (int i = 49; i >= 0; --i) {
                    float f3 = (float)i / 49.0f;
                    f3 = (float)Math.pow(f3, 0.3);
                    final float f4 = -PlateTectonicsModel.MAX_FLAT_X + f3 * (-75000.0f - -PlateTectonicsModel.MAX_FLAT_X);
                    this.addColumn(Side.LEFT, f4, (List<TerrainSample>)new ArrayList<TerrainSample>(){
                        {
                            for (int i = 0; i < 20; ++i) {
                                float f2 = (float)i / 19.0f;
                                float f3 = bounds3F.getMinZ() + f2 * (bounds3F.getMaxZ() - bounds3F.getMinZ());
                                this.add(new TerrainSample((float)LEFT_OCEANIC_ELEVATION, CrustModel.this.getTextureStrategy().mapTop(new Vector2F(f4, f3))));
                            }
                        }
                    });
                }
            }
        };
        this.middleTerrain = new Terrain(20, bounds3F.getMinZ(), bounds3F.getMaxZ()){
            {
                super(n, f, f2);
                for (int i = 0; i < 50; ++i) {
                    float f3 = (float)i / 49.0f;
                    final float f4 = -75000.0f + f3 * 150000.0f;
                    this.addColumn(Side.RIGHT, f4, (List<TerrainSample>)new ArrayList<TerrainSample>(){
                        {
                            for (int i = 0; i < 20; ++i) {
                                float f2 = (float)i / 19.0f;
                                float f3 = bounds3F.getMinZ() + f2 * (bounds3F.getMaxZ() - bounds3F.getMinZ());
                                this.add(new TerrainSample((float)CrustModel.this.getCenterCrustElevation(), CrustModel.this.getTextureStrategy().mapTop(new Vector2F(f4, f3))));
                            }
                        }
                    });
                }
            }
        };
        this.continentalTerrain = new Terrain(20, bounds3F.getMinZ(), bounds3F.getMaxZ()){
            {
                super(n, f, f2);
                for (int i = 0; i < 50; ++i) {
                    float f3 = (float)i / 49.0f;
                    f3 = (float)(1.0 - Math.pow(1.0f - f3, 0.3));
                    final float f4 = 75000.0f + f3 * (PlateTectonicsModel.MAX_FLAT_X - 75000.0f);
                    this.addColumn(Side.RIGHT, f4, (List<TerrainSample>)new ArrayList<TerrainSample>(){
                        {
                            for (int i = 0; i < 20; ++i) {
                                float f2 = (float)i / 19.0f;
                                float f3 = bounds3F.getMinZ() + f2 * (bounds3F.getMaxZ() - bounds3F.getMinZ());
                                this.add(new TerrainSample((float)RIGHT_CONTINENTAL_ELEVATION, CrustModel.this.getTextureStrategy().mapTop(new Vector2F(f4, f3))));
                            }
                        }
                    });
                }
            }
        };
        this.addTerrain(this.oceanicTerrain);
        this.addTerrain(this.middleTerrain);
        this.addTerrain(this.continentalTerrain);
        TerrainConnectorStrip terrainConnectorStrip = new TerrainConnectorStrip(this.oceanicTerrain, this.middleTerrain, 10, bounds3F.getMinZ(), bounds3F.getMaxZ());
        this.terrainConnectors.add(terrainConnectorStrip);
        this.addTerrain(terrainConnectorStrip);
        TerrainConnectorStrip terrainConnectorStrip2 = new TerrainConnectorStrip(this.middleTerrain, this.continentalTerrain, 10, bounds3F.getMinZ(), bounds3F.getMaxZ());
        this.terrainConnectors.add(terrainConnectorStrip2);
        this.addTerrain(terrainConnectorStrip2);
        final float f = bounds3F.getMinY();
        Function1<Vector2F, Vector2F> function1 = new Function1<Vector2F, Vector2F>(){

            @Override
            public Vector2F apply(Vector2F vector2F) {
                return new Vector2F(vector2F.x, f);
            }
        };
        Vector2F[] vector2FArray = this.oceanicTerrain.getFrontVertices();
        Vector2F[] vector2FArray2 = CrustModel.map(vector2FArray, new Function1<Vector2F, Vector2F>(){

            @Override
            public Vector2F apply(Vector2F vector2F) {
                return new Vector2F(vector2F.x, (float)((double)vector2F.y - 7000.0));
            }
        }, new Vector2F[vector2FArray.length]);
        Vector2F[] vector2FArray3 = CrustModel.map(vector2FArray, function1, new Vector2F[vector2FArray.length]);
        Vector2F[] vector2FArray4 = this.continentalTerrain.getFrontVertices();
        Vector2F[] vector2FArray5 = CrustModel.map(vector2FArray4, new Function1<Vector2F, Vector2F>(){

            @Override
            public Vector2F apply(Vector2F vector2F) {
                return new Vector2F(vector2F.x, (float)((double)vector2F.y - 45000.0));
            }
        }, new Vector2F[vector2FArray4.length]);
        Vector2F[] vector2FArray6 = CrustModel.map(vector2FArray4, function1, new Vector2F[vector2FArray4.length]);
        final Vector2F[] vector2FArray7 = this.middleTerrain.getFrontVertices();
        final Vector2F[] vector2FArray8 = new Vector2F[vector2FArray7.length];
        Vector2F[] vector2FArray9 = CrustModel.map(vector2FArray7, function1, new Vector2F[vector2FArray7.length]);
        final Sample[] sampleArray = new Sample[vector2FArray7.length];
        final Sample[] sampleArray2 = new Sample[vector2FArray8.length];
        final Sample[] sampleArray3 = new Sample[vector2FArray8.length];
        final Sample[] sampleArray4 = new Sample[vector2FArray9.length];
        final Function1<Float, Float> function12 = new Function1<Float, Float>(){

            @Override
            public Float apply(Float f) {
                float f2 = (float)(-(((double)f.floatValue() - CrustModel.this.getCenterCrustElevation()) / CrustModel.this.thickness.get()));
                return Float.valueOf((float)((double)PlateTectonicsModel.ZERO_CELSIUS + (double)(f2 * 700.0f) * CrustModel.this.temperatureRatio.get()));
            }
        };
        for (int i = 0; i < vector2FArray7.length; ++i) {
            sampleArray[i] = new Sample(new Vector3F(), 0.0f, (float)this.getCenterCrustDensity(), new Vector2F());
            sampleArray2[i] = new Sample(new Vector3F(), 0.0f, (float)this.getCenterCrustDensity(), new Vector2F());
            sampleArray3[i] = new Sample(new Vector3F(), ZERO_CELSIUS + 700.0f, 3300.0f, new Vector2F());
            sampleArray4[i] = new Sample(new Vector3F(vector2FArray9[i].x, vector2FArray9[i].y, 0.0f), ZERO_CELSIUS + 700.0f, 3300.0f, this.getTextureStrategy().mapFront(vector2FArray9[i]));
        }
        this.middleUpdateObserver = new SimpleObserver(){

            public void update() {
                int n;
                System.arraycopy(CrustModel.this.middleTerrain.getFrontVertices(), 0, vector2FArray7, 0, vector2FArray7.length);
                float f = (float)CrustModel.this.getCenterCrustDensity();
                for (n = 0; n < vector2FArray7.length; ++n) {
                    vector2FArray8[n] = new Vector2F(vector2FArray7[n].getX(), (float)((double)vector2FArray7[n].getY() - CrustModel.this.thickness.get()));
                }
                for (n = 0; n < vector2FArray7.length; ++n) {
                    Vector3F vector3F = new Vector3F(vector2FArray7[n].x, vector2FArray7[n].y, 0.0f);
                    Vector3F vector3F2 = new Vector3F(vector2FArray8[n].x, vector2FArray8[n].y, 0.0f);
                    sampleArray[n].setPosition(vector3F);
                    sampleArray2[n].setPosition(vector3F2);
                    sampleArray[n].setTextureCoordinates(CrustModel.this.getTextureStrategy().mapFront(new Vector2F(vector2FArray7[n].x, 0.0f)));
                    Vector2F vector2F = new Vector2F((double)vector2FArray7[n].x, -CrustModel.this.thickness.get().doubleValue());
                    sampleArray2[n].setTextureCoordinates(CrustModel.this.getTextureStrategy().mapFront(vector2F));
                    sampleArray3[n].setPosition(vector3F2);
                    sampleArray3[n].setTextureCoordinates(CrustModel.this.getTextureStrategy().mapFront(vector2FArray8[n]));
                    sampleArray[n].setTemperature(((Float)function12.apply(Float.valueOf(vector2FArray7[n].y))).floatValue());
                    sampleArray2[n].setTemperature(((Float)function12.apply(Float.valueOf(vector2FArray8[n].y))).floatValue());
                    sampleArray[n].setDensity(f);
                    sampleArray2[n].setDensity(f);
                }
            }
        };
        this.temperatureRatio.addObserver(this.middleUpdateObserver, false);
        this.compositionRatio.addObserver(this.middleUpdateObserver, false);
        this.middleUpdateObserver.update();
        Vector2F[] vector2FArray10 = new Vector2F[vector2FArray3.length + vector2FArray9.length + vector2FArray6.length - 2];
        System.arraycopy(vector2FArray3, 0, vector2FArray10, 0, vector2FArray3.length);
        System.arraycopy(vector2FArray9, 0, vector2FArray10, vector2FArray3.length - 1, vector2FArray9.length);
        System.arraycopy(vector2FArray6, 0, vector2FArray10, vector2FArray3.length + vector2FArray9.length - 2, vector2FArray6.length);
        Vector2F[] vector2FArray11 = CrustModel.map(vector2FArray10, new Function1<Vector2F, Vector2F>(){

            @Override
            public Vector2F apply(Vector2F vector2F) {
                return new Vector2F(vector2F.x, -750000.0f);
            }
        }, new Vector2F[vector2FArray10.length]);
        Vector2F[] vector2FArray12 = CrustModel.map(vector2FArray10, new Function1<Vector2F, Vector2F>(){

            @Override
            public Vector2F apply(Vector2F vector2F) {
                return new Vector2F(vector2F.x, -2921000.0f);
            }
        }, new Vector2F[vector2FArray10.length]);
        Vector2F[] vector2FArray13 = CrustModel.map(vector2FArray10, new Function1<Vector2F, Vector2F>(){

            @Override
            public Vector2F apply(Vector2F vector2F) {
                return new Vector2F(vector2F.x, -5180000.0f);
            }
        }, new Vector2F[vector2FArray10.length]);
        Vector2F[] vector2FArray14 = CrustModel.map(vector2FArray13, new Function1<Vector2F, Vector2F>(){

            @Override
            public Vector2F apply(Vector2F vector2F) {
                return new Vector2F(vector2F.x, -6371000.0f);
            }
        }, new Vector2F[vector2FArray13.length]);
        Sample[] sampleArray5 = new Sample[vector2FArray.length];
        Sample[] sampleArray6 = new Sample[vector2FArray.length];
        for (int i = 0; i < vector2FArray.length; ++i) {
            sampleArray5[i] = new Sample(new Vector3F(vector2FArray[i].x, vector2FArray[i].y, 0.0f), ((Float)function12.apply(Float.valueOf(vector2FArray[i].y))).floatValue(), 3000.0f, this.getTextureStrategy().mapFront(vector2FArray[i]));
            sampleArray6[i] = new Sample(new Vector3F(vector2FArray2[i].x, vector2FArray2[i].y, 0.0f), ((Float)function12.apply(Float.valueOf(vector2FArray2[i].y))).floatValue(), 3000.0f, this.getTextureStrategy().mapFront(vector2FArray2[i]));
        }
        Object object = new CrossSectionStrip();
        for (n = 0; n < vector2FArray.length; ++n) {
            ((CrossSectionStrip)object).addPatch(Side.RIGHT, sampleArray5[n], sampleArray6[n]);
        }
        this.addStrip((CrossSectionStrip)object);
        sampleArray5 = new Sample[vector2FArray4.length];
        sampleArray6 = new Sample[vector2FArray4.length];
        object = new Function1<Float, Float>(){

            @Override
            public Float apply(Float f) {
                float f2 = (float)(-(((double)f.floatValue() - RIGHT_CONTINENTAL_ELEVATION) / 45000.0));
                return Float.valueOf(PlateTectonicsModel.ZERO_CELSIUS + f2 * 450.0f);
            }
        };
        for (n = 0; n < vector2FArray4.length; ++n) {
            sampleArray5[n] = new Sample(new Vector3F(vector2FArray4[n].x, vector2FArray4[n].y, 0.0f), ((Float)object.apply(Float.valueOf(vector2FArray4[n].y))).floatValue(), 2700.0f, this.getTextureStrategy().mapFront(vector2FArray4[n]));
            sampleArray6[n] = new Sample(new Vector3F(vector2FArray5[n].x, vector2FArray5[n].y, 0.0f), ((Float)object.apply(Float.valueOf(vector2FArray5[n].y))).floatValue(), 2700.0f, this.getTextureStrategy().mapFront(vector2FArray5[n]));
        }
        CrossSectionStrip crossSectionStrip = new CrossSectionStrip();
        for (int i = 0; i < vector2FArray4.length; ++i) {
            crossSectionStrip.addPatch(Side.RIGHT, sampleArray5[i], sampleArray6[i]);
        }
        this.addStrip(crossSectionStrip);
        this.middleCrustStrip = new CrossSectionStrip(){
            {
                for (int i = 0; i < vector2FArray7.length; ++i) {
                    this.addPatch(Side.RIGHT, sampleArray[i], sampleArray2[i]);
                }
            }
        };
        this.addStrip(this.middleCrustStrip);
        this.middleMantleStrip = new CrossSectionStrip(){
            {
                for (int i = 0; i < sampleArray3.length; ++i) {
                    this.addPatch(Side.RIGHT, sampleArray3[i], sampleArray4[i]);
                }
            }
        };
        this.addStrip(this.middleMantleStrip);
        this.addStrip(this.rectangularConstantStrip(vector2FArray2, vector2FArray3, 3300.0f, 3300.0f, ZERO_CELSIUS + 700.0f, ZERO_CELSIUS + 700.0f));
        this.addStrip(this.rectangularConstantStrip(vector2FArray5, vector2FArray6, 3300.0f, 3300.0f, ZERO_CELSIUS + 700.0f, ZERO_CELSIUS + 700.0f));
        this.addStrip(this.rectangularConstantStrip(vector2FArray10, vector2FArray11, CrustModel.getMantleDensity(f), CrustModel.getMantleDensity(-750000.0f), ZERO_CELSIUS + 700.0f, ZERO_CELSIUS + 1100.0f));
        this.addStrip(this.rectangularConstantStrip(vector2FArray11, vector2FArray12, CrustModel.getMantleDensity(-750000.0f), CrustModel.getMantleDensity(-2921000.0f), ZERO_CELSIUS + 1100.0f, ZERO_CELSIUS + 4000.0f));
        this.addStrip(this.rectangularConstantStrip(vector2FArray12, vector2FArray13, 10000.0f, 12800.0f, ZERO_CELSIUS + 4400.0f, 5778.0f));
        this.addStrip(this.rectangularConstantStrip(vector2FArray13, vector2FArray14, 12800.0f, 13100.0f, 5778.0f, 5778.0f));
        this.updateView();
    }

    @Override
    public void resetAll() {
        super.resetAll();
        this.thickness.reset();
        this.temperatureRatio.reset();
        this.compositionRatio.reset();
        this.crustElevation = this.computeIdealCrustElevation();
        this.crustVelocity = 0.0;
    }

    private CrossSectionStrip rectangularConstantStrip(final Vector2F[] vector2FArray, final Vector2F[] vector2FArray2, final float f, final float f2, final float f3, final float f4) {
        return new CrossSectionStrip(){
            {
                for (int i = 0; i < vector2FArray.length; ++i) {
                    this.addPatch(Side.RIGHT, new Sample(new Vector3F(vector2FArray[i].x, vector2FArray[i].y, 0.0f), f3, f, CrustModel.this.getTextureStrategy().mapFront(vector2FArray[i])), new Sample(new Vector3F(vector2FArray2[i].x, vector2FArray2[i].y, 0.0f), f4, f2, CrustModel.this.getTextureStrategy().mapFront(vector2FArray2[i])));
                }
            }
        };
    }

    public static float getMantleDensity(float f) {
        float f2 = -f;
        assert (f2 >= 0.0f);
        for (int i = 0; i < mantleDepthDensity.length; i += 2) {
            if (!(f2 < (float)(mantleDepthDensity[i] * 1000))) continue;
            if (i > 0) {
                float f3 = mantleDepthDensity[i - 2] * 1000;
                float f4 = mantleDepthDensity[i] * 1000;
                float f5 = mantleDepthDensity[i - 1];
                float f6 = mantleDepthDensity[i + 1];
                float f7 = (f2 - f3) / (f4 - f3);
                return f5 + f7 * (f6 - f5);
            }
            throw new RuntimeException("should not be reachable with first depth == 0");
        }
        return mantleDepthDensity[mantleDepthDensity.length - 1];
    }

    public static float getCoreDensity(float f) {
        if (f > -5180000.0f) {
            return (float)OUTER_CORE_DENSITY_FUNCTION.evaluate(f);
        }
        return (float)INNER_CORE_DENSITY_FUNCTION.evaluate(f);
    }

    public static float getMantleOrCoreDensity(double d) {
        if (d > -2921000.0) {
            return CrustModel.getMantleDensity((float)d);
        }
        return CrustModel.getCoreDensity((float)d);
    }

    private static <T, U> U[] map(T[] TArray, Function1<? super T, ? extends U> function1, U[] UArray) {
        assert (UArray.length >= TArray.length);
        for (int i = 0; i < TArray.length; ++i) {
            UArray[i] = function1.apply(TArray[i]);
        }
        return UArray;
    }

    @Override
    public void update(double d) {
        d *= 100.0;
        double d2 = this.computeIdealCrustElevation();
        double d3 = d2 - this.crustElevation;
        double d4 = 0.01;
        double d5 = 0.5 * d4 * d3 * d3;
        double d6 = 0.5 * this.crustVelocity * this.crustVelocity;
        double d7 = d5 + d6;
        this.crustElevation += this.crustVelocity * d;
        this.crustVelocity += d3 * d4 * d;
        this.crustVelocity /= Math.exp(d / 9.0);
        this.updateView();
    }

    private void updateView() {
        this.middleTerrain.setToFlatElevation((float)this.getCenterCrustElevation());
        this.middleTerrain.elevationChanged.updateListeners();
        for (TerrainConnectorStrip terrainConnectorStrip : this.terrainConnectors) {
            terrainConnectorStrip.update();
        }
        this.middleUpdateObserver.update();
        this.middleCrustStrip.update();
        this.middleMantleStrip.update();
        this.modelChanged.updateListeners();
    }

    private static double computeCrustElevation(double d, double d2) {
        return d * (1.0 - d2 / 3300.0) - 3500.0;
    }

    private double getCenterCrustDensity() {
        double d = 0.8 * (1.0 - this.compositionRatio.get()) + 0.1 * (1.0 - this.temperatureRatio.get());
        return 2600.0 + 700.0 * d;
    }

    public double getCenterCrustElevation() {
        return this.crustElevation;
    }

    private double computeIdealCrustElevation() {
        return CrustModel.computeCrustElevation(this.thickness.get(), this.getCenterCrustDensity());
    }

    public double getCenterCrustBottomY() {
        return this.getCenterCrustElevation() - this.thickness.get();
    }

    @Override
    public double getDensity(double d, double d2) {
        if (d < -75000.0) {
            if (d2 > 0.0) {
                return CrustModel.getAirDensity(d2);
            }
            if (d2 > LEFT_OCEANIC_ELEVATION) {
                return CrustModel.getWaterDensity(d2);
            }
            if (d2 > LEFT_OCEANIC_ELEVATION - 7000.0) {
                return 3000.0;
            }
            return CrustModel.getMantleOrCoreDensity(d2);
        }
        if (d > 75000.0) {
            if (d2 > RIGHT_CONTINENTAL_ELEVATION) {
                return CrustModel.getAirDensity(d2);
            }
            if (d2 > RIGHT_CONTINENTAL_ELEVATION - 45000.0) {
                return 2700.0;
            }
            return CrustModel.getMantleOrCoreDensity(d2);
        }
        if (d2 > this.getCenterCrustElevation()) {
            if (d2 > 0.0) {
                return CrustModel.getAirDensity(d2);
            }
            return CrustModel.getWaterDensity(d2);
        }
        if (d2 > this.getCenterCrustBottomY()) {
            return this.getCenterCrustDensity();
        }
        return CrustModel.getMantleOrCoreDensity(d2);
    }

    @Override
    public double getTemperature(double d, double d2) {
        Vector3F vector3F = new Vector3F((float)d, (float)d2, 0.0f);
        PlateTectonicsModel.HitResult hitResult = this.firstStripIntersection(vector3F);
        if (hitResult != null) {
            return hitResult.temperature;
        }
        if (d2 < 0.0) {
            return PlateTectonicsModel.getWaterTemperature(d2);
        }
        return PlateTectonicsModel.getAirTemperature(d2);
    }

    @Override
    public List<CrossSectionStrip> getStripsInOrder() {
        return this.getCrossSectionStrips();
    }
}

