/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.model;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.platetectonics.model.PlateMotionModel;
import edu.colorado.phet.platetectonics.model.PlateType;
import edu.colorado.phet.platetectonics.tabs.PlateMotionTab;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Handle {
    public final Property<Vector2F> orientation = new Property<Vector2F>(Vector2F.ZERO);
    public final Property<Boolean> active = new Property<Boolean>(false);
    public final boolean isRightHandle;
    private final PlateMotionTab tab;
    private final PlateMotionModel model;

    public Handle(final Property<Vector2F> property, final boolean bl, PlateMotionTab plateMotionTab) {
        this.isRightHandle = bl;
        this.tab = plateMotionTab;
        this.model = plateMotionTab.getPlateMotionModel();
        property.addObserver(new SimpleObserver(){

            public void update() {
                Handle.this.orientation.set(bl ? (Vector2F)property.get() : ((Vector2F)property.get()).negated());
            }
        });
        this.orientation.addObserver(new SimpleObserver(){

            public void update() {
                if (Handle.this.active.get().booleanValue()) {
                    property.set(bl ? Handle.this.orientation.get() : Handle.this.orientation.get().negated());
                }
            }
        });
    }

    public boolean isVisible() {
        boolean bl;
        boolean bl2 = bl = this.model.hasBothPlates.get() != false && this.tab.isAutoMode.get() == false;
        if (!bl) {
            return false;
        }
        PlateType plateType = (this.isRightHandle ? this.model.rightPlateType : this.model.leftPlateType).get();
        PlateType plateType2 = (this.isRightHandle ? this.model.leftPlateType : this.model.rightPlateType).get();
        return !(plateType.isContinental() && plateType2.isOceanic() || plateType == PlateType.YOUNG_OCEANIC && plateType2 == PlateType.OLD_OCEANIC);
    }

    public PlateMotionModel.MotionType getRightMotionType() {
        return this.isRightHandle ? PlateMotionModel.MotionType.DIVERGENT : PlateMotionModel.MotionType.CONVERGENT;
    }

    public PlateMotionModel.MotionType getLeftMotionType() {
        return this.isRightHandle ? PlateMotionModel.MotionType.CONVERGENT : PlateMotionModel.MotionType.DIVERGENT;
    }

    public void startArrowPress(PlateMotionModel.MotionType motionType) {
        if (this.model.motionType.get() == null) {
            if (motionType == PlateMotionModel.MotionType.TRANSFORM) {
                this.model.setTransformMotionCCW(!this.isRightHandle);
            }
            this.model.motionType.set(motionType);
        }
        if (motionType == PlateMotionModel.MotionType.TRANSFORM) {
            Vector2F vector2F = new Vector2F(0.0, 1.2566370801612687);
            if (this.model.isTransformMotionCCW()) {
                vector2F = vector2F.negated();
            }
            this.tab.motionVectorRight.set(vector2F);
        } else {
            Vector2F vector2F = new Vector2F(1.2566370801612687, 0.0);
            if (this.getRightMotionType() == motionType != this.isRightHandle) {
                vector2F = vector2F.negated();
            }
            this.tab.motionVectorRight.set(vector2F);
        }
    }

    public void endArrowPress() {
        this.tab.motionVectorRight.set(Vector2F.ZERO);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkInitialMotion(Vector3F vector3F) {
        if (!(vector3F.magnitude() > 5.0f)) return false;
        float f = vector3F.dot(Vector3F.X_UNIT);
        float f2 = Math.abs(vector3F.dot(Vector3F.Y_UNIT));
        if (this.model.allowsTransformMotion() && f2 > Math.abs(f)) {
            this.model.setTransformMotionCCW(!this.isRightHandle);
            this.model.motionType.set(PlateMotionModel.MotionType.TRANSFORM);
            return true;
        } else {
            boolean bl;
            boolean bl2 = bl = vector3F.x < 0.0f;
            if (this.model.allowsDivergentMotion() && bl != this.isRightHandle) {
                this.model.motionType.set(PlateMotionModel.MotionType.DIVERGENT);
                return true;
            } else {
                if (!this.model.allowsConvergentMotion() || bl != this.isRightHandle) return false;
                this.model.motionType.set(PlateMotionModel.MotionType.CONVERGENT);
            }
        }
        return true;
    }

    public void startHandleDrag() {
        this.active.set(true);
    }

    public void horizontalHandleDrag(float f) {
        this.tab.motionVectorRight.set(new Vector2F(this.isRightHandle ? f : -f, 0.0f));
    }

    public void verticalHandleDrag(float f) {
        this.tab.motionVectorRight.set(new Vector2F(0.0f, this.isRightHandle ? f : -f));
    }

    public void endHandleDrag() {
        this.active.set(false);
        this.tab.motionVectorRight.set(Vector2F.ZERO);
    }
}

