/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.model;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.common.phetcommon.model.event.ValueNotifier;
import edu.colorado.phet.common.phetcommon.util.FunctionalUtils;
import edu.colorado.phet.common.phetcommon.util.ObservableList;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.platetectonics.model.Sample;
import edu.colorado.phet.platetectonics.model.Terrain;
import edu.colorado.phet.platetectonics.model.TerrainSample;
import edu.colorado.phet.platetectonics.model.TextureStrategy;
import edu.colorado.phet.platetectonics.model.regions.Region;
import edu.colorado.phet.platetectonics.util.Side;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Plate {
    private Region crust;
    private Region lithosphere;
    private Region mantle;
    private Terrain terrain;
    public final ValueNotifier<Plate> disposed = new ValueNotifier<Plate>(this);
    public final ObservableList<Region> regions = new ObservableList();

    public void addCrust(Region region) {
        assert (this.crust == null);
        this.crust = region;
        this.regions.add(region);
    }

    public void addLithosphere(Region region) {
        assert (this.lithosphere == null);
        this.lithosphere = region;
        this.regions.add(region);
    }

    public void addMantle(Region region) {
        assert (this.mantle == null);
        this.mantle = region;
        this.regions.add(region);
    }

    public void addTerrain(final TextureStrategy textureStrategy, final int n, float f, float f2) {
        final Region region = this.crust == null ? this.mantle : this.crust;
        this.terrain = new Terrain(n, f, f2){
            {
                super(n5, f, f2);
                int n3 = 0;
                while (n3 < region.getTopBoundary().samples.size()) {
                    final float f3 = region.getTopBoundary().samples.get((int)n3).getPosition().x;
                    final int n4 = n3++;
                    this.addColumn(Side.RIGHT, f3, (List<TerrainSample>)new ArrayList<TerrainSample>(){
                        {
                            for (int i = 0; i < n; ++i) {
                                float f2 = ((Float)zPositions.get(i)).floatValue();
                                this.add(new TerrainSample(region.getTopBoundary().samples.get((int)n4).getPosition().y, textureStrategy.mapTop(new Vector2F(f3, f2))));
                            }
                        }
                    });
                }
            }
        };
    }

    public void shiftZ(float f) {
        for (Sample sample : this.getSamples()) {
            sample.setPosition(sample.getPosition().plus(new Vector3F(0.0f, 0.0f, f)));
        }
        this.getTerrain().shiftZ(f);
    }

    public List<Sample> getSamples() {
        return FunctionalUtils.unique(FunctionalUtils.flatten(FunctionalUtils.map(this.regions, new Function1<Region, Collection<? extends Sample>>(){

            @Override
            public Collection<? extends Sample> apply(Region region) {
                return region.getSamples();
            }
        })));
    }

    public Region getCrust() {
        return this.crust;
    }

    public Region getMantle() {
        return this.mantle;
    }

    public Region getLithosphere() {
        return this.lithosphere;
    }

    public Terrain getTerrain() {
        return this.terrain;
    }
}

