/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.model;

import edu.colorado.phet.common.phetcommon.math.Bounds3F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.common.phetcommon.model.event.Notifier;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ModelComponentTypes;
import edu.colorado.phet.common.phetcommon.simsharing.messages.Parameter;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.util.ObservableList;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.platetectonics.PlateTectonicsConstants;
import edu.colorado.phet.platetectonics.PlateTectonicsResources;
import edu.colorado.phet.platetectonics.PlateTectonicsSimSharing;
import edu.colorado.phet.platetectonics.model.PlateMotionPlate;
import edu.colorado.phet.platetectonics.model.PlateTectonicsModel;
import edu.colorado.phet.platetectonics.model.PlateType;
import edu.colorado.phet.platetectonics.model.Sample;
import edu.colorado.phet.platetectonics.model.SmokePuff;
import edu.colorado.phet.platetectonics.model.TectonicsClock;
import edu.colorado.phet.platetectonics.model.TerrainConnectorStrip;
import edu.colorado.phet.platetectonics.model.TextureStrategy;
import edu.colorado.phet.platetectonics.model.behaviors.CollidingBehavior;
import edu.colorado.phet.platetectonics.model.behaviors.OverridingBehavior;
import edu.colorado.phet.platetectonics.model.behaviors.RiftingBehavior;
import edu.colorado.phet.platetectonics.model.behaviors.SubductingBehavior;
import edu.colorado.phet.platetectonics.model.behaviors.TransformBehavior;
import edu.colorado.phet.platetectonics.model.labels.BoundaryLabel;
import edu.colorado.phet.platetectonics.model.labels.RangeLabel;
import edu.colorado.phet.platetectonics.model.labels.TextLabel;
import edu.colorado.phet.platetectonics.model.regions.Boundary;
import edu.colorado.phet.platetectonics.model.regions.CrossSectionStrip;
import edu.colorado.phet.platetectonics.util.MortalUpdateListener;
import edu.colorado.phet.platetectonics.util.Side;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlateMotionModel
extends PlateTectonicsModel {
    private PlateMotionPlate leftPlate;
    private PlateMotionPlate rightPlate;
    private final TectonicsClock clock;
    public final ObservableList<RangeLabel> rangeLabels = new ObservableList();
    public final ObservableList<BoundaryLabel> boundaryLabels = new ObservableList();
    public final ObservableList<TextLabel> textLabels = new ObservableList();
    public final Notifier<Side> frontBoundarySideNotifier = new Notifier();
    private TerrainConnectorStrip terrainConnector;
    public static final float SIMPLE_MANTLE_TOP_TEMP = ZERO_CELSIUS + 700.0f;
    public static final float SIMPLE_LITHOSPHERE_BOUNDARY_TEMP = ZERO_CELSIUS + 1100.0f;
    public static final float SIMPLE_MANTLE_BOTTOM_TEMP = ZERO_CELSIUS + 1300.0f;
    public static final float SIMPLE_CRUST_TOP_TEMP = ZERO_CELSIUS;
    public static final float SIMPLE_CRUST_BOTTOM_TEMP = ZERO_CELSIUS + 450.0f;
    public static final float SIMPLE_MAGMA_TEMP = ZERO_CELSIUS + 1300.0f;
    private boolean transformMotionCCW = true;
    public BoundaryLabel joiningBoundaryLabel;
    private final StripTracker stripTracker = new StripTracker();
    public ObservableList<SmokePuff> smokePuffs = new ObservableList();
    public final Property<PlateType> leftPlateType = new Property<Object>(null);
    public final Property<PlateType> rightPlateType = new Property<Object>(null);
    public final Property<MotionType> motionType = new Property<Object>(null);
    public final Property<MotionType> motionTypeIfStarted = new Property<MotionType>(MotionType.CONVERGENT);
    public final Property<Boolean> animationStarted = new Property<Boolean>(false);
    public final Property<Boolean> hasBothPlates = new Property<Boolean>(Boolean.valueOf(false)){
        {
            SimpleObserver simpleObserver = new SimpleObserver(){

                public void update() {
                    this.set(PlateMotionModel.this.hasLeftPlate() && PlateMotionModel.this.hasRightPlate());
                }
            };
            PlateMotionModel.this.leftPlateType.addObserver(simpleObserver);
            PlateMotionModel.this.rightPlateType.addObserver(simpleObserver);
        }
    };
    public final Property<Boolean> hasAnyPlates = new Property<Boolean>(Boolean.valueOf(false)){
        {
            SimpleObserver simpleObserver = new SimpleObserver(){

                public void update() {
                    this.set(PlateMotionModel.this.hasLeftPlate() || PlateMotionModel.this.hasRightPlate());
                }
            };
            PlateMotionModel.this.leftPlateType.addObserver(simpleObserver);
            PlateMotionModel.this.rightPlateType.addObserver(simpleObserver);
        }
    };

    public PlateMotionModel(TectonicsClock tectonicsClock, Bounds3F bounds3F) {
        super(bounds3F, new TextureStrategy(6.0E-6f));
        this.clock = tectonicsClock;
        this.resetPlates();
        this.resetTerrain();
        this.updateTerrain();
        this.updateStrips();
        this.rangeLabels.addElementRemovedObserver(new VoidFunction1<RangeLabel>(){

            @Override
            public void apply(RangeLabel rangeLabel) {
                rangeLabel.disposed.updateListeners();
            }
        });
        this.textLabels.addElementRemovedObserver(new VoidFunction1<TextLabel>(){

            @Override
            public void apply(TextLabel textLabel) {
                textLabel.disposed.updateListeners();
            }
        });
        this.boundaryLabels.addElementRemovedObserver(new VoidFunction1<BoundaryLabel>(){

            @Override
            public void apply(BoundaryLabel boundaryLabel) {
                boundaryLabel.disposed.updateListeners();
            }
        });
        this.animationStarted.addObserver(new SimpleObserver(){

            public void update() {
                if (PlateMotionModel.this.animationStarted.get().booleanValue()) {
                    PlateMotionModel.this.initializeBehaviors();
                }
            }
        });
        this.hasBothPlates.addObserver(new SimpleObserver(){

            public void update() {
                if (PlateMotionModel.this.allowsConvergentMotion()) {
                    PlateMotionModel.this.motionTypeIfStarted.set(MotionType.CONVERGENT);
                } else if (PlateMotionModel.this.allowsDivergentMotion()) {
                    PlateMotionModel.this.motionTypeIfStarted.set(MotionType.DIVERGENT);
                } else {
                    PlateMotionModel.this.motionTypeIfStarted.set(MotionType.TRANSFORM);
                }
                if (PlateMotionModel.this.hasBothPlates.get().booleanValue()) {
                    PlateMotionModel.this.addMantleLabel();
                    PlateMotionModel.this.addJoinedBoundary();
                }
            }
        });
    }

    private void addMantleLabel() {
        if (this.hasBothPlates.get().booleanValue()) {
            final Property<Vector3F> property = new Property<Vector3F>(new Vector3F(0.0f, -180000.0f, 0.0f));
            TextLabel textLabel = new TextLabel(property, PlateTectonicsResources.Strings.MANTLE);
            this.textLabels.add(textLabel);
            if (this.leftPlate.getBehavior() != null && this.leftPlate.getBehavior() instanceof CollidingBehavior) {
                final Sample sample = this.leftPlate.getLithosphere().getBottomBoundary().getEdgeSample(Side.RIGHT);
                float f = sample.getPosition().y;
                final float f2 = -180000.0f - f;
                this.modelChanged.addUpdateListener(new MortalUpdateListener(this.modelChanged, textLabel.disposed){

                    public void update() {
                        property.set(new Vector3F(0.0f, f2 + sample.getPosition().y, 0.0f));
                    }
                }, false);
            }
        }
    }

    private void initializeBehaviors() {
        ParameterSet parameterSet = new ParameterSet(new Parameter[]{new Parameter((IParameterKey)PlateTectonicsSimSharing.ParameterKeys.leftPlateType, this.leftPlateType.get().toString()), new Parameter((IParameterKey)PlateTectonicsSimSharing.ParameterKeys.rightPlateType, this.rightPlateType.get().toString())});
        switch (this.motionType.get()) {
            case TRANSFORM: {
                this.clock.setTimeLimit(25.0);
                this.leftPlate.setBehavior(new TransformBehavior(this.leftPlate, this.rightPlate, this.isTransformMotionCCW()));
                this.rightPlate.setBehavior(new TransformBehavior(this.rightPlate, this.leftPlate, !this.isTransformMotionCCW()));
                this.leftPlate.addMiddleSide(this.rightPlate);
                this.rightPlate.addMiddleSide(this.leftPlate);
                SimSharingManager.sendModelMessage(PlateTectonicsSimSharing.ModelComponents.motion, ModelComponentTypes.feature, PlateTectonicsSimSharing.ModelActions.transformMotion, parameterSet);
                break;
            }
            case CONVERGENT: {
                if (this.leftPlateType.get() == PlateType.CONTINENTAL && this.rightPlateType.get() == PlateType.CONTINENTAL) {
                    this.clock.setTimeLimit(35.0);
                    this.leftPlate.setBehavior(new CollidingBehavior(this.leftPlate, this.rightPlate));
                    this.rightPlate.setBehavior(new CollidingBehavior(this.rightPlate, this.leftPlate));
                    SimSharingManager.sendModelMessage(PlateTectonicsSimSharing.ModelComponents.motion, ModelComponentTypes.feature, PlateTectonicsSimSharing.ModelActions.continentalCollisionMotion, parameterSet);
                    break;
                }
                if (this.leftPlateType.get().isContinental() || this.rightPlateType.get() == PlateType.OLD_OCEANIC) {
                    this.clock.setTimeLimit(50.0);
                    this.leftPlate.setBehavior(new OverridingBehavior(this.leftPlate, this.rightPlate));
                    this.rightPlate.setBehavior(new SubductingBehavior(this.rightPlate, this.leftPlate));
                    this.rightPlate.getCrust().moveToFront();
                    this.frontBoundarySideNotifier.updateListeners(Side.RIGHT);
                    SimSharingManager.sendModelMessage(PlateTectonicsSimSharing.ModelComponents.motion, ModelComponentTypes.feature, PlateTectonicsSimSharing.ModelActions.rightPlateSubductingMotion, parameterSet);
                    break;
                }
                if (this.rightPlateType.get().isContinental() || this.leftPlateType.get() == PlateType.OLD_OCEANIC) {
                    this.clock.setTimeLimit(50.0);
                    this.leftPlate.setBehavior(new SubductingBehavior(this.leftPlate, this.rightPlate));
                    this.rightPlate.setBehavior(new OverridingBehavior(this.rightPlate, this.leftPlate));
                    this.leftPlate.getCrust().moveToFront();
                    this.frontBoundarySideNotifier.updateListeners(Side.LEFT);
                    SimSharingManager.sendModelMessage(PlateTectonicsSimSharing.ModelComponents.motion, ModelComponentTypes.feature, PlateTectonicsSimSharing.ModelActions.leftPlateSubductingMotion, parameterSet);
                    break;
                }
                assert (this.leftPlateType.get() == this.rightPlateType.get());
                throw new RuntimeException("behavior type not supported: " + (Object)((Object)this.leftPlateType.get()) + ", " + (Object)((Object)this.rightPlateType.get()));
            }
            case DIVERGENT: {
                this.clock.setTimeLimit(35.0);
                this.leftPlate.setBehavior(new RiftingBehavior(this.leftPlate, this.rightPlate));
                this.rightPlate.setBehavior(new RiftingBehavior(this.rightPlate, this.leftPlate));
                SimSharingManager.sendModelMessage(PlateTectonicsSimSharing.ModelComponents.motion, ModelComponentTypes.feature, PlateTectonicsSimSharing.ModelActions.divergentMotion, parameterSet);
            }
        }
        this.leftPlate.getBehavior().afterConstructionInit();
        this.rightPlate.getBehavior().afterConstructionInit();
        if (this.motionType.get() == MotionType.TRANSFORM) {
            this.textLabels.clear();
        } else if (this.textLabels.isEmpty() && this.hasBothPlates.get().booleanValue()) {
            this.addMantleLabel();
        } else {
            this.textLabels.clear();
            this.addMantleLabel();
        }
    }

    private void addJoinedBoundary() {
        this.joiningBoundaryLabel = new BoundaryLabel(new Boundary(){
            {
                this.addSample(Side.LEFT, PlateMotionModel.this.getPlate(Side.LEFT).getLithosphere().getBottomBoundary().getEdgeSample(Side.RIGHT));
                this.addSample(Side.RIGHT, PlateMotionModel.this.getPlate(Side.RIGHT).getLithosphere().getBottomBoundary().getEdgeSample(Side.LEFT));
            }
        }, Side.LEFT);
        this.boundaryLabels.add(this.joiningBoundaryLabel);
    }

    private void resetPlates() {
        if (this.leftPlate != null) {
            this.removePlate(this.leftPlate);
        }
        this.leftPlate = new PlateMotionPlate(this, this.getTextureStrategy(), Side.LEFT);
        if (this.rightPlate != null) {
            this.removePlate(this.rightPlate);
        }
        this.rightPlate = new PlateMotionPlate(this, this.getTextureStrategy(), Side.RIGHT);
        this.addPlate(this.leftPlate);
        this.addPlate(this.rightPlate);
    }

    public void resetTerrain() {
        float f = this.bounds.getMinZ();
        float f2 = this.bounds.getMaxZ();
        if (this.terrainConnector != null) {
            this.removeTerrain(this.terrainConnector);
        }
        this.terrainConnector = new TerrainConnectorStrip(this.leftPlate.getTerrain(), this.rightPlate.getTerrain(), 3, f, f2);
        this.addTerrain(this.terrainConnector);
    }

    public void rewind() {
        this.joiningBoundaryLabel = null;
        this.resetPlates();
        this.resetTerrain();
        this.rangeLabels.clear();
        this.boundaryLabels.clear();
        this.textLabels.clear();
        this.dropCrust(Side.LEFT, this.leftPlateType.get());
        this.dropCrust(Side.RIGHT, this.rightPlateType.get());
        this.addJoinedBoundary();
        this.initializeBehaviors();
        this.smokePuffs.clear();
    }

    public void newCrust() {
        this.resetEverythingExceptTime();
    }

    private void resetEverythingExceptTime() {
        super.resetAll();
        this.joiningBoundaryLabel = null;
        this.leftPlateType.reset();
        this.rightPlateType.reset();
        this.resetPlates();
        this.resetTerrain();
        this.motionType.reset();
        this.motionTypeIfStarted.reset();
        this.animationStarted.reset();
        this.updateStrips();
        this.updateTerrain();
        this.modelChanged.updateListeners();
        this.smokePuffs.clear();
        this.rangeLabels.clear();
        this.boundaryLabels.clear();
        this.textLabels.clear();
    }

    @Override
    public void resetAll() {
        this.clock.resetTimeLimit();
        this.clock.setTimeMultiplier(1.0);
        this.resetEverythingExceptTime();
    }

    public float getStartingX(Side side, int n) {
        assert (n >= 0);
        assert (n < 96);
        switch (side) {
            case LEFT: {
                return this.bounds.getMinX() + (this.bounds.getCenterX() - this.bounds.getMinX()) * (float)n / 95.0f;
            }
            case RIGHT: {
                return this.bounds.getCenterX() + (this.bounds.getMaxX() - this.bounds.getCenterX()) * (float)n / 95.0f;
            }
        }
        throw new RuntimeException("Side not found: " + (Object)((Object)side));
    }

    public void dropCrust(Side side, PlateType plateType) {
        PlateMotionPlate plateMotionPlate = this.getPlate(side);
        plateMotionPlate.droppedCrust(plateType);
        this.getPlateTypeProperty(side).set(plateType);
        this.updateStrips();
        plateMotionPlate.fullSyncTerrain();
        plateMotionPlate.randomizeTerrain();
        this.updateTerrain();
        this.updateStrips();
        this.modelChanged.updateListeners();
    }

    private void updateStrips() {
        for (CrossSectionStrip crossSectionStrip : this.getCrossSectionStrips()) {
            crossSectionStrip.update();
        }
    }

    private void updateTerrain() {
        this.terrainConnector.update();
    }

    public Property<PlateType> getPlateTypeProperty(Side side) {
        return side == Side.LEFT ? this.leftPlateType : this.rightPlateType;
    }

    public PlateType getPlateType(Side side) {
        return this.getPlateTypeProperty(side).get();
    }

    public PlateMotionPlate getPlate(Side side) {
        return side == Side.LEFT ? this.leftPlate : this.rightPlate;
    }

    public boolean hasPlate(Side side) {
        return this.getPlateType(side) != null;
    }

    public boolean hasLeftPlate() {
        return this.hasPlate(Side.LEFT);
    }

    public boolean hasRightPlate() {
        return this.hasPlate(Side.RIGHT);
    }

    @Override
    public void update(double d) {
        assert (!Double.isNaN(d));
        super.update(d);
        if (this.hasLeftPlate() && this.hasRightPlate()) {
            if (this.motionType.get() == null) {
                this.setTransformMotionCCW(false);
                this.motionType.set(this.motionTypeIfStarted.get());
            }
            this.animationStarted.set(true);
            this.leftPlate.getBehavior().stepInTime((float)d);
            this.rightPlate.getBehavior().stepInTime((float)d);
            this.updateStrips();
            this.updateTerrain();
        }
        this.modelChanged.updateListeners();
    }

    @Override
    public double getDensity(double d, double d2) {
        Vector3F vector3F = new Vector3F((float)d, (float)d2, 0.0f);
        PlateTectonicsModel.HitResult hitResult = this.firstStripIntersection(vector3F);
        if (hitResult != null) {
            return hitResult.density;
        }
        if (d2 < 0.0) {
            return PlateTectonicsModel.getWaterDensity(d2);
        }
        return PlateTectonicsModel.getAirDensity(d2);
    }

    @Override
    public double getTemperature(double d, double d2) {
        Vector3F vector3F = new Vector3F((float)d, (float)d2, 0.0f);
        PlateTectonicsModel.HitResult hitResult = this.firstStripIntersection(vector3F);
        if (hitResult != null) {
            return hitResult.temperature;
        }
        if (d2 < 0.0) {
            return PlateTectonicsModel.getWaterTemperature(d2);
        }
        return PlateTectonicsModel.getAirTemperature(d2);
    }

    public Bounds3F getLeftDropAreaBounds() {
        return Bounds3F.fromMinMax(this.bounds.getMinX(), this.bounds.getCenterX(), -10000.0f, 15000.0f, this.bounds.getMinZ(), this.bounds.getMaxZ());
    }

    public Bounds3F getRightDropAreaBounds() {
        return Bounds3F.fromMinMax(this.bounds.getCenterX(), this.bounds.getMaxX(), -10000.0f, 15000.0f, this.bounds.getMinZ(), this.bounds.getMaxZ());
    }

    public boolean allowsDivergentMotion() {
        return this.hasLeftPlate() && this.hasRightPlate() && this.leftPlateType.get().isContinental() == this.rightPlateType.get().isContinental();
    }

    public boolean allowsTransformMotion() {
        return this.hasLeftPlate() && this.hasRightPlate() && this.leftPlateType.get().isContinental() == this.rightPlateType.get().isContinental();
    }

    public boolean allowsConvergentMotion() {
        return this.hasLeftPlate() && this.hasRightPlate() && (this.leftPlateType.get() != this.rightPlateType.get() || this.leftPlateType.get().isContinental() && this.rightPlateType.get().isContinental());
    }

    public boolean isTransformMotionCCW() {
        return this.transformMotionCCW;
    }

    public void setTransformMotionCCW(boolean bl) {
        this.transformMotionCCW = bl;
    }

    @Override
    public List<CrossSectionStrip> getStripsInOrder() {
        return this.stripTracker.getStripsInOrder();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class MotionType
    extends Enum<MotionType> {
        public static final /* enum */ MotionType CONVERGENT = new MotionType(PlateTectonicsConstants.ARROW_CONVERGENT_FILL);
        public static final /* enum */ MotionType DIVERGENT = new MotionType(PlateTectonicsConstants.ARROW_DIVERGENT_FILL);
        public static final /* enum */ MotionType TRANSFORM = new MotionType(PlateTectonicsConstants.ARROW_TRANSFORM_FILL);
        public final Color color;
        private static final /* synthetic */ MotionType[] $VALUES;

        public static MotionType[] values() {
            return (MotionType[])$VALUES.clone();
        }

        private MotionType(Color color) {
            this.color = color;
        }

        static {
            $VALUES = new MotionType[]{CONVERGENT, DIVERGENT, TRANSFORM};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StripTracker {
        private final List<CrossSectionStrip> strips = new ArrayList<CrossSectionStrip>();

        private StripTracker() {
            final VoidFunction1<CrossSectionStrip> voidFunction1 = new VoidFunction1<CrossSectionStrip>(){

                @Override
                public void apply(CrossSectionStrip crossSectionStrip) {
                    StripTracker.this.strips.remove(crossSectionStrip);
                    StripTracker.this.strips.add(crossSectionStrip);
                }
            };
            PlateMotionModel.this.crossSectionStripAdded.addListener(new VoidFunction1<CrossSectionStrip>(){

                @Override
                public void apply(CrossSectionStrip crossSectionStrip) {
                    crossSectionStrip.moveToFrontNotifier.addListener(voidFunction1);
                    StripTracker.this.strips.add(crossSectionStrip);
                }
            });
            PlateMotionModel.this.crossSectionStripRemoved.addListener(new VoidFunction1<CrossSectionStrip>(){

                @Override
                public void apply(CrossSectionStrip crossSectionStrip) {
                    crossSectionStrip.moveToFrontNotifier.removeListener(voidFunction1);
                    StripTracker.this.strips.remove(crossSectionStrip);
                }
            });
        }

        public List<CrossSectionStrip> getStripsInOrder() {
            ArrayList<CrossSectionStrip> arrayList = new ArrayList<CrossSectionStrip>(this.strips);
            Collections.reverse(arrayList);
            return arrayList;
        }
    }
}

