/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.model;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.function.Function2;
import edu.colorado.phet.platetectonics.PlateTectonicsResources;
import edu.colorado.phet.platetectonics.model.Plate;
import edu.colorado.phet.platetectonics.model.PlateMotionModel;
import edu.colorado.phet.platetectonics.model.PlateType;
import edu.colorado.phet.platetectonics.model.Sample;
import edu.colorado.phet.platetectonics.model.TerrainSample;
import edu.colorado.phet.platetectonics.model.TextureStrategy;
import edu.colorado.phet.platetectonics.model.behaviors.PlateBehavior;
import edu.colorado.phet.platetectonics.model.behaviors.RiftingBehavior;
import edu.colorado.phet.platetectonics.model.behaviors.TransformBehavior;
import edu.colorado.phet.platetectonics.model.labels.BoundaryLabel;
import edu.colorado.phet.platetectonics.model.labels.RangeLabel;
import edu.colorado.phet.platetectonics.model.regions.Boundary;
import edu.colorado.phet.platetectonics.model.regions.Region;
import edu.colorado.phet.platetectonics.util.MortalUpdateListener;
import edu.colorado.phet.platetectonics.util.Side;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlateMotionPlate
extends Plate {
    private final PlateMotionModel model;
    private final TextureStrategy textureStrategy;
    private final Side side;
    private BoundaryLabel boundaryLabel;
    private PlateType plateType = null;
    private PlateBehavior behavior;

    public PlateMotionPlate(PlateMotionModel plateMotionModel, TextureStrategy textureStrategy, Side side) {
        this.model = plateMotionModel;
        this.textureStrategy = textureStrategy;
        this.side = side;
        this.addMantle(new Region(6, 96, new Function2<Integer, Integer, Sample>(){

            @Override
            public Sample apply(Integer n, Integer n2) {
                return PlateMotionPlate.this.createMantleSample(n2, n, 6, -10000.0f, -600000.0f, PlateMotionModel.SIMPLE_MANTLE_TOP_TEMP, PlateMotionModel.SIMPLE_MANTLE_BOTTOM_TEMP);
            }
        }));
        this.addTerrain(textureStrategy, 32, plateMotionModel.getBounds().getMinZ(), plateMotionModel.getBounds().getMaxZ());
        this.getTerrain().isWaterValid.set(false);
    }

    private Sample createMantleSample(int n, int n2, int n3, float f, float f2, float f3, float f4) {
        float f5 = this.model.getStartingX(this.side, n);
        float f6 = (float)n2 / (float)n3;
        float f7 = f + (f2 - f) * f6;
        float f8 = f3 + (f4 - f3) * f6;
        return new Sample(new Vector3F(f5, f7, 0.0f), f8, 3300.0f, this.textureStrategy.mapFront(new Vector2F(f5, f7)));
    }

    public void droppedCrust(PlateType plateType) {
        int n;
        this.plateType = plateType;
        final float f = plateType.getCrustTopY();
        final float f2 = plateType.getCrustBottomY();
        final float f3 = plateType.getLithosphereBottomY();
        final float f4 = plateType.getDensity();
        this.addLithosphere(new Region(2, 96, new Function2<Integer, Integer, Sample>(){

            @Override
            public Sample apply(Integer n, Integer n2) {
                return PlateMotionPlate.this.createMantleSample(n2, n, 2, f2, f3, PlateMotionModel.SIMPLE_MANTLE_TOP_TEMP, PlateMotionModel.SIMPLE_LITHOSPHERE_BOUNDARY_TEMP);
            }
        }));
        this.addCrust(new Region(2, 96, new Function2<Integer, Integer, Sample>(){

            @Override
            public Sample apply(Integer n, Integer n2) {
                float f5 = PlateMotionPlate.this.model.getStartingX(PlateMotionPlate.this.side, n2);
                float f22 = (float)n.intValue() / 2.0f;
                float f3 = f + (f2 - f) * f22;
                float f42 = PlateMotionPlate.getCrustTemperatureFromYRatio(f22);
                return new Sample(new Vector3F(f5, f3, 0.0f), f42, f4, PlateMotionPlate.this.textureStrategy.mapFront(new Vector2F(f5, f3)));
            }
        }));
        for (n = 0; n < this.getMantle().getBoundaries().size(); ++n) {
            Boundary boundary = this.getMantle().getBoundaries().get(n);
            for (int i = 0; i < boundary.samples.size(); ++i) {
                Sample sample = boundary.samples.get(i);
                Sample sample2 = this.createMantleSample(i, n, 6, f3, -600000.0f, PlateMotionModel.SIMPLE_LITHOSPHERE_BOUNDARY_TEMP, PlateMotionModel.SIMPLE_MANTLE_BOTTOM_TEMP);
                sample.setPosition(sample2.getPosition());
                sample.setTemperature(sample2.getTemperature());
                sample.setDensity(sample2.getDensity());
                sample.setTextureCoordinates(sample2.getTextureCoordinates());
            }
        }
        n = this.getCrust().getTopBoundary().samples.size() * (this.getSide() == Side.LEFT ? 5 : 1) / 6;
        int n2 = this.getCrust().getTopBoundary().samples.size() * (this.getSide() == Side.LEFT ? 4 : 2) / 6;
        this.model.rangeLabels.add(new RangeLabel(new BoundaryTrackingProperty(this.getCrust().getTopBoundary(), n), new BoundaryTrackingProperty(this.getCrust().getBottomBoundary(), n), plateType.getSpecificLabel(), this));
        this.model.rangeLabels.add(new RangeLabel(new BoundaryTrackingProperty(this.getCrust().getTopBoundary(), n2), new BoundaryTrackingProperty(this.getLithosphere().getBottomBoundary(), n2), PlateTectonicsResources.Strings.LITHOSPHERE, this));
        this.boundaryLabel = new BoundaryLabel(this.getLithosphere().getBottomBoundary(), this.side){

            public boolean isReversed() {
                if (PlateMotionPlate.this.behavior == null) {
                    return super.isReversed();
                }
                return PlateMotionPlate.this.behavior instanceof RiftingBehavior;
            }
        };
        this.model.boundaryLabels.add(this.boundaryLabel);
        this.getTerrain().isWaterValid.set(true);
    }

    public float getSimpleChunkWidth() {
        return this.model.getStartingX(Side.LEFT, 1) - this.model.getStartingX(Side.LEFT, 0);
    }

    public void addSection(final Side side, final PlateType plateType) {
        float f = this.model.getStartingX(side, 1) - this.model.getStartingX(side, 0);
        final float f2 = f * (float)side.getSign();
        final float f3 = plateType.getCrustTopY();
        final float f4 = plateType.getCrustBottomY();
        final float f5 = plateType.getLithosphereBottomY();
        float f6 = this.getCrust().getTopBoundary().getEdgeSample((Side)side).getPosition().x + f2;
        this.getCrust().addColumn(side, (List<Sample>)new ArrayList<Sample>(){
            {
                float f42 = f3;
                float f5 = f4;
                for (int i = 0; i < PlateMotionPlate.this.getCrust().getBoundaries().size(); ++i) {
                    Sample sample = PlateMotionPlate.this.getCrust().getBoundaries().get(i).getEdgeSample(side);
                    float f6 = (float)i / 2.0f;
                    float f7 = f42 + (f5 - f42) * f6;
                    float f8 = PlateMotionPlate.getCrustTemperatureFromYRatio(f6);
                    float f9 = sample.getPosition().x + f2;
                    this.add(new Sample(new Vector3F(f9, f7, 0.0f), f8, plateType.getDensity(), sample.getTextureCoordinates().plus(PlateMotionPlate.this.textureStrategy.mapFrontDelta(new Vector2F(f2, 0.0f)))));
                }
            }
        });
        this.getLithosphere().addColumn(side, (List<Sample>)new ArrayList<Sample>(){
            {
                float f42 = f4;
                float f52 = f5;
                for (int i = 0; i < PlateMotionPlate.this.getLithosphere().getBoundaries().size(); ++i) {
                    Sample sample = PlateMotionPlate.this.getLithosphere().getBoundaries().get(i).getEdgeSample(side);
                    float f6 = (float)i / 2.0f;
                    float f7 = f42 + (f52 - f42) * f6;
                    float f8 = PlateMotionPlate.getLithosphereTemperatureFromYRatio(f6);
                    float f9 = sample.getPosition().x + f2;
                    this.add(new Sample(new Vector3F(f9, f7, 0.0f), f8, 3300.0f, sample.getTextureCoordinates().plus(PlateMotionPlate.this.textureStrategy.mapFrontDelta(new Vector2F(f2, 0.0f)))));
                }
            }
        });
        this.getTerrain().addColumn(side, f6, (List<TerrainSample>)new ArrayList<TerrainSample>(){
            {
                for (int i = 0; i < PlateMotionPlate.this.getTerrain().getZSamples(); ++i) {
                    TerrainSample terrainSample = PlateMotionPlate.this.getTerrain().getSample(side.getIndex(PlateMotionPlate.this.getTerrain().getNumColumns()), i);
                    this.add(new TerrainSample(PlateMotionPlate.this.getCrust().getTopBoundary().getEdgeSample((Side)side).getPosition().y, terrainSample.getTextureCoordinates().plus(PlateMotionPlate.this.textureStrategy.mapTopDelta(new Vector2F(f2, 0.0f)))));
                }
            }
        });
    }

    public void removeSection(Side side) {
        this.getCrust().removeColumn(side);
        this.getLithosphere().removeColumn(side);
        this.getTerrain().removeColumn(side);
    }

    public void fullSyncTerrain() {
        for (int i = 0; i < this.getTerrain().getNumColumns(); ++i) {
            Vector3F vector3F = (this.plateType != null ? this.getCrust().getTopBoundary() : this.getMantle().getTopBoundary()).samples.get(i).getPosition();
            for (int j = 0; j < 32; ++j) {
                this.getTerrain().getSample(i, j).setElevation(vector3F.y);
            }
            this.getTerrain().xPositions.set(i, Float.valueOf(vector3F.x));
        }
        this.getTerrain().elevationChanged.updateListeners();
    }

    private static float getCrustTemperatureFromYRatio(float f) {
        return PlateMotionModel.SIMPLE_CRUST_TOP_TEMP + (PlateMotionModel.SIMPLE_CRUST_BOTTOM_TEMP - PlateMotionModel.SIMPLE_CRUST_TOP_TEMP) * f;
    }

    private static float getLithosphereTemperatureFromYRatio(float f) {
        return PlateMotionModel.SIMPLE_MANTLE_TOP_TEMP + (PlateMotionModel.SIMPLE_LITHOSPHERE_BOUNDARY_TEMP - PlateMotionModel.SIMPLE_MANTLE_TOP_TEMP) * f;
    }

    public void addMiddleSide(final Plate plate) {
        assert (this.getCrust() != null && this.getMantle() != null);
        this.regions.add(new Region(6, this.getTerrain().getNumRows(), new Function2<Integer, Integer, Sample>(){

            @Override
            public Sample apply(Integer n, Integer n2) {
                float f = 0.0f;
                Sample sample = PlateMotionPlate.this.getMantle().getBoundaries().get((int)n.intValue()).samples.get(0);
                float f2 = sample.getPosition().y;
                float f3 = PlateMotionPlate.this.getTerrain().zPositions.get(PlateMotionPlate.this.side == Side.LEFT ? PlateMotionPlate.this.getTerrain().getNumRows() - n2 - 1 : n2).floatValue();
                return new Sample(new Vector3F(f, f2, f3), sample.getTemperature(), sample.getDensity(), PlateMotionPlate.this.textureStrategy.mapFront(new Vector2F(f3 * (float)PlateMotionPlate.this.side.getSign(), f2)));
            }
        }));
        this.regions.add(new Region(2, this.getTerrain().getNumRows(), new Function2<Integer, Integer, Sample>(){

            @Override
            public Sample apply(Integer n, Integer n2) {
                float f = 0.0f;
                Sample sample = PlateMotionPlate.this.getLithosphere().getBoundaries().get((int)n.intValue()).samples.get(0);
                float f2 = sample.getPosition().y;
                float f3 = PlateMotionPlate.this.getTerrain().zPositions.get(PlateMotionPlate.this.side == Side.LEFT ? PlateMotionPlate.this.getTerrain().getNumRows() - n2 - 1 : n2).floatValue();
                return new Sample(new Vector3F(f, f2, f3), sample.getTemperature(), sample.getDensity(), PlateMotionPlate.this.textureStrategy.mapFront(new Vector2F(f3 * (float)PlateMotionPlate.this.side.getSign(), f2)));
            }
        }));
        int n = this.getSide().opposite().getIndex(this.getTerrain().getNumColumns());
        int n2 = this.getSide().getIndex(this.getTerrain().getNumColumns());
        float f = this.getCrust().getBottomBoundary().samples.get((int)0).getPosition().y;
        this.regions.add(new Region(2, this.getTerrain().getNumRows(), this.createMiddleCrustSampleFactory(plate)){
            {
                super(n, n2, function2);
                ((PlateMotionPlate)PlateMotionPlate.this).model.modelChanged.addUpdateListener(new MortalUpdateListener(((PlateMotionPlate)PlateMotionPlate.this).model.modelChanged, this.disposed){

                    public void update() {
                        Function2<Integer, Integer, Sample> function2 = PlateMotionPlate.this.createMiddleCrustSampleFactory(plate);
                        for (int i = 0; i < this.getBoundaries().size(); ++i) {
                            Boundary boundary = this.getBoundaries().get(i);
                            for (int j = 0; j < this.getTopBoundary().samples.size(); ++j) {
                                Sample sample = boundary.getSample(j);
                                Sample sample2 = function2.apply(i, j);
                                sample.setPosition(new Vector3F(sample.getPosition().x, sample2.getPosition().y, sample.getPosition().z));
                            }
                        }
                    }
                }, false);
            }
        });
    }

    public Function2<Integer, Integer, Sample> createMiddleCrustSampleFactory(final Plate plate) {
        final int n = this.getSide().opposite().getIndex(this.getTerrain().getNumColumns());
        final int n2 = this.getSide().getIndex(this.getTerrain().getNumColumns());
        final float f = this.getCrust().getBottomBoundary().samples.get((int)0).getPosition().y;
        return new Function2<Integer, Integer, Sample>(){

            @Override
            public Sample apply(Integer n4, Integer n22) {
                int n3 = PlateMotionPlate.this.getSide().getFromIndex(PlateMotionPlate.this.getTerrain().getNumRows(), n22);
                float f10 = PlateMotionPlate.this.getTerrain().getSample(n, n3).getElevation();
                float f2 = plate.getTerrain().getSample(n2, n3).getElevation();
                float f3 = Math.min(f10, f2);
                float f4 = (f3 - f) / (f10 - f);
                float f5 = 0.0f;
                Sample sample = PlateMotionPlate.this.getCrust().getBoundaries().get((int)n4.intValue()).samples.get(0);
                float f6 = (float)n4.intValue() / 2.0f;
                f6 = f6 * f4 + (1.0f - f4);
                float f7 = f10 + (f - f10) * f6;
                float f8 = PlateMotionPlate.this.getTerrain().zPositions.get(n3).floatValue();
                float f9 = PlateMotionPlate.getCrustTemperatureFromYRatio(f6);
                return new Sample(new Vector3F(f5, f7, f8), f9, sample.getDensity(), PlateMotionPlate.this.textureStrategy.mapFront(new Vector2F(f8 * (float)PlateMotionPlate.this.side.getSign(), f7)));
            }
        };
    }

    public PlateBehavior getBehavior() {
        return this.behavior;
    }

    public void setBehavior(PlateBehavior plateBehavior) {
        this.behavior = plateBehavior;
    }

    public Side getSide() {
        return this.side;
    }

    public int getSign() {
        return this.side.getSign();
    }

    public TextureStrategy getTextureStrategy() {
        return this.textureStrategy;
    }

    public PlateType getPlateType() {
        return this.plateType;
    }

    public PlateMotionModel getModel() {
        return this.model;
    }

    public BoundaryLabel getBoundaryLabel() {
        return this.boundaryLabel;
    }

    public void randomizeTerrain() {
        Random random = new Random(0L);
        float[] fArray = new float[this.getTerrain().getNumRows()];
        for (int i = 0; i < this.getTerrain().getNumRows(); ++i) {
            fArray[i] = random.nextFloat();
        }
        float f = this.getPlateType().isContinental() ? 2000.0f : 500.0f;
        float f2 = this.getPlateType().isContinental() ? -1000.0f : 0.0f;
        for (int i = 0; i < this.getTerrain().getNumColumns(); ++i) {
            float f3 = this.getTerrain().xPositions.get(i).floatValue();
            boolean bl = i == this.getSide().opposite().getIndex(this.getTerrain().getNumColumns());
            for (int j = 0; j < this.getTerrain().getNumRows(); ++j) {
                float f4 = this.getTerrain().zPositions.get(j).floatValue();
                float f5 = bl ? fArray[j] : random.nextFloat();
                float f6 = f5 * f + f2;
                TerrainSample terrainSample = this.getTerrain().getSample(i, j);
                terrainSample.setElevation(terrainSample.getElevation() + f6);
                terrainSample.setRandomElevationOffset(f6);
                if (j != this.getTerrain().getFrontZIndex()) continue;
                float f7 = this.getCrust().getTopElevation(i) + f6;
                this.getCrust().getTopBoundary().samples.get(i).setRandomTerrainOffset(f6);
                this.getCrust().layoutColumn(i, f7, this.getCrust().getBottomElevation(i), this.getTextureStrategy(), true);
            }
        }
        this.getTerrain().elevationChanged.updateListeners();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class BoundaryTrackingProperty
    extends Property<Vector3F> {
        public BoundaryTrackingProperty(final Boundary boundary, int n) {
            super(new Vector3F());
            final Sample sample = boundary.getSample(n);
            assert (sample != null);
            final float f = sample.getPosition().x;
            ((PlateMotionPlate)PlateMotionPlate.this).model.modelChanged.addUpdateListener(new MortalUpdateListener(((PlateMotionPlate)PlateMotionPlate.this).model.modelChanged, PlateMotionPlate.this.disposed){

                public void update() {
                    if (PlateMotionPlate.this.behavior instanceof RiftingBehavior || PlateMotionPlate.this.behavior instanceof TransformBehavior) {
                        BoundaryTrackingProperty.this.set(sample.getPosition());
                    } else {
                        BoundaryTrackingProperty.this.set(new Vector3F(f, boundary.getApproximateYFromX(f), 0.0f));
                    }
                }
            }, true);
        }
    }
}

