/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.model;

import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ClockListener;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.model.property.ChangeObserver;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ModelComponentTypes;
import edu.colorado.phet.platetectonics.PlateTectonicsSimSharing;
import java.util.ArrayList;
import java.util.List;

public class TectonicsClock
implements IClock {
    private double lastSimulationTime = 0.0;
    private double simulationTime = 0.0;
    private long lastWallTime = 0L;
    private long wallTime = 0L;
    private double timeMultiplier;
    private final List<ClockListener> listeners = new ArrayList<ClockListener>();
    private final Property<Boolean> running = new Property<Boolean>(false);
    private double timeLimit = Double.MAX_VALUE;

    public TectonicsClock(double d) {
        this.timeMultiplier = d;
        this.running.addObserver(new ChangeObserver<Boolean>(){

            @Override
            public void update(Boolean bl, Boolean bl2) {
                ClockEvent clockEvent = new ClockEvent(TectonicsClock.this);
                if (bl.booleanValue()) {
                    for (ClockListener clockListener : TectonicsClock.this.listeners) {
                        clockListener.clockStarted(clockEvent);
                    }
                } else {
                    for (ClockListener clockListener : TectonicsClock.this.listeners) {
                        clockListener.clockPaused(clockEvent);
                    }
                }
            }
        });
    }

    public synchronized void stepByWallSeconds(float f) {
        if (this.running.get().booleanValue()) {
            this.stepByWallSecondsForced(f);
        }
    }

    public synchronized void stepByWallSecondsForced(float f) {
        assert (!Float.isNaN(f));
        this.tick(f);
    }

    protected synchronized void tick(float f) {
        this.lastWallTime = this.wallTime;
        this.wallTime = System.currentTimeMillis();
        if (this.simulationTime >= this.timeLimit) {
            return;
        }
        double d = this.simulationTime + (double)f * this.timeMultiplier;
        if (d > this.timeLimit) {
            d = this.timeLimit;
            SimSharingManager.sendModelMessage(PlateTectonicsSimSharing.ModelComponents.time, ModelComponentTypes.feature, PlateTectonicsSimSharing.ModelActions.maximumTimeReached);
        }
        this.setSimulationTime(d);
        ClockEvent clockEvent = new ClockEvent(this);
        for (ClockListener clockListener : this.listeners) {
            clockListener.clockTicked(clockEvent);
        }
    }

    public synchronized void start() {
        this.running.set(true);
    }

    public synchronized void pause() {
        this.running.set(false);
    }

    public synchronized boolean isPaused() {
        return this.running.get() == false;
    }

    public synchronized boolean isRunning() {
        return this.running.get();
    }

    public synchronized void addClockListener(ClockListener clockListener) {
        this.listeners.add(clockListener);
    }

    public synchronized void resetSimulationTime() {
        this.setSimulationTime(0.0);
        ClockEvent clockEvent = new ClockEvent(this);
        for (ClockListener clockListener : this.listeners) {
            clockListener.simulationTimeReset(clockEvent);
        }
    }

    public synchronized double getSimulationTimeChange() {
        return this.simulationTime - this.lastSimulationTime;
    }

    public synchronized double getSimulationTime() {
        return this.simulationTime;
    }

    public synchronized void setSimulationTime(double d) {
        this.lastSimulationTime = this.simulationTime;
        this.simulationTime = d;
        ClockEvent clockEvent = new ClockEvent(this);
        for (ClockListener clockListener : this.listeners) {
            clockListener.simulationTimeChanged(clockEvent);
        }
    }

    public synchronized void stepClockWhilePaused() {
        this.tick(5.0f);
    }

    public synchronized void stepClockBackWhilePaused() {
        this.tick(5.0f);
    }

    public synchronized void setTimeMultiplier(double d) {
        this.timeMultiplier = d;
    }

    public double getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimit(double d) {
        this.timeLimit = d;
    }

    public void resetTimeLimit() {
        this.timeLimit = Double.MAX_VALUE;
    }
}

