/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.model;

import edu.colorado.phet.common.phetcommon.math.Ray3F;
import edu.colorado.phet.common.phetcommon.math.Triangle3F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.common.phetcommon.model.event.ValueNotifier;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.Option;
import edu.colorado.phet.lwjglphet.math.LWJGLTransform;
import edu.colorado.phet.platetectonics.model.PlateTectonicsModel;
import edu.colorado.phet.platetectonics.model.TerrainSample;
import edu.colorado.phet.platetectonics.model.TextureStrategy;
import edu.colorado.phet.platetectonics.util.Side;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Terrain {
    public final List<Float> xPositions = new ArrayList<Float>();
    public final List<Float> zPositions = new ArrayList<Float>();
    private final List<List<TerrainSample>> samples = new ArrayList<List<TerrainSample>>();
    public final ValueNotifier<Terrain> elevationChanged = new ValueNotifier<Terrain>(this);
    public final ValueNotifier<Terrain> columnsModified = new ValueNotifier<Terrain>(this);
    public final ValueNotifier<Terrain> disposed = new ValueNotifier<Terrain>(this);
    public final Property<Boolean> isWaterValid = new Property<Boolean>(true);
    private final int zSamples;

    public Terrain(int n, float f, float f2) {
        this.zSamples = n;
        for (int i = 0; i < n; ++i) {
            float f3 = (float)i / (float)(n - 1);
            this.zPositions.add(Float.valueOf(f + f3 * (f2 - f)));
        }
    }

    public int getFrontZIndex() {
        return this.zSamples - 1;
    }

    public int getNumColumns() {
        return this.samples.size();
    }

    public int getNumRows() {
        return this.zSamples;
    }

    public TerrainSample getSample(int n, int n2) {
        return this.samples.get(n).get(n2);
    }

    public int getNumberOfVertices() {
        return this.getNumColumns() * this.getNumRows();
    }

    public List<TerrainSample> getColumn(int n) {
        return this.samples.get(n);
    }

    public void addColumn(Side side, float f, List<TerrainSample> list) {
        assert (list.size() == this.zSamples);
        side.addToList(this.samples, list);
        side.addToList(this.xPositions, Float.valueOf(f));
        this.columnsModified.updateListeners();
    }

    public void removeColumn(Side side) {
        side.removeFromList(this.samples);
        side.removeFromList(this.xPositions);
        this.columnsModified.updateListeners();
    }

    public int getZSamples() {
        return this.zSamples;
    }

    public boolean hasWater() {
        return true;
    }

    public Vector2F[] getFrontVertices() {
        Vector2F[] vector2FArray = new Vector2F[this.getNumColumns()];
        int n = this.getFrontZIndex();
        for (int i = 0; i < this.getNumColumns(); ++i) {
            vector2FArray[i] = new Vector2F(this.xPositions.get(i).floatValue(), this.getSample(i, n).getElevation());
        }
        return vector2FArray;
    }

    public void setToFlatElevation(float f) {
        for (List<TerrainSample> list : this.samples) {
            for (TerrainSample terrainSample : list) {
                terrainSample.setElevation(f);
            }
        }
    }

    public void shiftColumnElevation(int n, float f) {
        for (TerrainSample terrainSample : this.getColumn(n)) {
            terrainSample.setElevation(terrainSample.getElevation() + f);
        }
    }

    public void shiftColumnXWithTexture(TextureStrategy textureStrategy, int n, float f) {
        this.xPositions.set(n, Float.valueOf(this.xPositions.get(n).floatValue() + f));
        for (TerrainSample terrainSample : this.getColumn(n)) {
            terrainSample.setTextureCoordinates(terrainSample.getTextureCoordinates().plus(textureStrategy.mapTopDelta(new Vector2F(f, 0.0f))));
        }
    }

    public void shiftZ(float f) {
        for (int i = 0; i < this.zPositions.size(); ++i) {
            this.zPositions.set(i, Float.valueOf(this.zPositions.get(i).floatValue() + f));
        }
    }

    public void setColumnElevation(int n, float f) {
        for (TerrainSample terrainSample : this.getColumn(n)) {
            terrainSample.setElevation(f);
        }
    }

    private Vector3F[] getViewSpaceRow(int n, Vector3F[] vector3FArray, LWJGLTransform lWJGLTransform) {
        Vector3F[] vector3FArray2 = new Vector3F[this.xPositions.size()];
        Vector3F vector3F = PlateTectonicsModel.getZRadialVector(this.zPositions.get(n).floatValue());
        for (int i = 0; i < this.xPositions.size(); ++i) {
            Vector3F vector3F2;
            float f = this.getSample(i, n).getElevation();
            Vector3F vector3F3 = PlateTectonicsModel.convertToRadial(vector3FArray[i], vector3F, f);
            vector3FArray2[i] = vector3F2 = lWJGLTransform.transformPosition(vector3F3);
        }
        return vector3FArray2;
    }

    public Option<Vector3F> intersectWithRay(Ray3F ray3F, LWJGLTransform lWJGLTransform) {
        int n;
        Vector3F[] vector3FArray = new Vector3F[this.xPositions.size()];
        for (n = 0; n < this.xPositions.size(); ++n) {
            vector3FArray[n] = PlateTectonicsModel.getXRadialVector(this.xPositions.get(n).floatValue());
        }
        n = this.zSamples - 1;
        Vector3F[] vector3FArray2 = this.getViewSpaceRow(n, vector3FArray, lWJGLTransform);
        while (n >= 1) {
            Vector3F[] vector3FArray3 = this.getViewSpaceRow(--n, vector3FArray, lWJGLTransform);
            for (int i = 1; i < this.xPositions.size(); ++i) {
                Vector3F vector3F = vector3FArray2[i - 1];
                Vector3F vector3F2 = vector3FArray3[i - 1];
                Vector3F vector3F3 = vector3FArray3[i];
                Vector3F vector3F4 = vector3FArray2[i];
                Option<Triangle3F.TriangleIntersectionResult> option = new Triangle3F(vector3F2, vector3F3, vector3F4).intersectWith(ray3F);
                if (option.isSome()) {
                    return new Option.Some<Vector3F>(option.get().point);
                }
                option = new Triangle3F(vector3F4, vector3F, vector3F2).intersectWith(ray3F);
                if (!option.isSome()) continue;
                return new Option.Some<Vector3F>(option.get().point);
            }
        }
        return new Option.None<Vector3F>();
    }
}

