/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.model;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2F;
import edu.colorado.phet.platetectonics.model.Terrain;
import edu.colorado.phet.platetectonics.model.TerrainSample;
import edu.colorado.phet.platetectonics.util.Side;
import java.util.ArrayList;
import java.util.List;

public class TerrainConnectorStrip
extends Terrain {
    private final Terrain left;
    private final Terrain right;
    private final int samples;
    private int leftXIndex;
    private final int rightXIndex = 0;

    public TerrainConnectorStrip(Terrain terrain, Terrain terrain2, int n, float f, float f2) {
        super(terrain.getNumRows(), f, f2);
        this.left = terrain;
        this.right = terrain2;
        this.samples = n;
        assert (terrain.getNumRows() == terrain2.getNumRows());
        this.update();
    }

    public void update() {
        this.leftXIndex = this.left.getNumColumns() - 1;
        Float f = this.left.xPositions.get(this.leftXIndex);
        Float f2 = this.right.xPositions.get(0);
        while (this.getNumColumns() > 0) {
            this.removeColumn(Side.RIGHT);
        }
        for (int i = 0; i < this.samples; ++i) {
            final float f3 = (float)i / (float)(this.samples - 1);
            this.addColumn(Side.RIGHT, f.floatValue() + f3 * (f2.floatValue() - f.floatValue()), (List<TerrainSample>)new ArrayList<TerrainSample>(){
                {
                    for (int i = 0; i < TerrainConnectorStrip.this.left.getNumRows(); ++i) {
                        float f2 = (float)i / (float)(TerrainConnectorStrip.this.left.getNumRows() - 1);
                        float f32 = TerrainConnectorStrip.this.left.getSample(TerrainConnectorStrip.this.leftXIndex, i).getElevation();
                        float f4 = TerrainConnectorStrip.this.right.getSample(0, i).getElevation();
                        float f5 = f32 + f3 * (f4 - f32);
                        this.add(new TerrainSample(f5, new Vector2F(f3 / 2.0f, f2 * 100.0f)));
                    }
                }
            });
        }
        if (!this.left.zPositions.get(0).equals(this.right.zPositions.get(0))) {
            List<Float> list = this.left.getSample(this.leftXIndex, 0).getElevation() > this.right.getSample(0, 0).getElevation() ? this.left.zPositions : this.right.zPositions;
            for (int i = 0; i < this.left.getNumRows(); ++i) {
                this.zPositions.set(i, list.get(i));
            }
        }
        this.columnsModified.updateListeners();
        this.elevationChanged.updateListeners();
    }

    public boolean hasWater() {
        return false;
    }
}

