/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.model.behaviors;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.platetectonics.model.PlateMotionPlate;
import edu.colorado.phet.platetectonics.model.Sample;
import edu.colorado.phet.platetectonics.model.TerrainSample;
import edu.colorado.phet.platetectonics.model.behaviors.PlateBehavior;
import edu.colorado.phet.platetectonics.model.regions.Boundary;
import edu.colorado.phet.platetectonics.model.regions.Region;
import edu.colorado.phet.platetectonics.util.Side;
import java.util.List;

public class CollidingBehavior
extends PlateBehavior {
    private float timeElapsed = 0.0f;

    public CollidingBehavior(PlateMotionPlate plateMotionPlate, PlateMotionPlate plateMotionPlate2) {
        super(plateMotionPlate, plateMotionPlate2);
        this.getLithosphere().moveToFront();
        this.getCrust().moveToFront();
        plateMotionPlate.getModel().frontBoundarySideNotifier.updateListeners(plateMotionPlate.getSide());
        this.moveMantleTopTo(0.0f);
    }

    public void stepInTime(float f) {
        int n;
        int n2;
        this.timeElapsed += f;
        this.createEarthEdges();
        float f2 = -this.plate.getSide().getSign();
        List<Sample> list = this.getTopCrustBoundary().samples;
        Boundary boundary = this.getLithosphere().getBottomBoundary();
        List<Sample> list2 = boundary.samples;
        float[] fArray = new float[list.size()];
        float[] fArray2 = new float[list.size()];
        float[] fArray3 = new float[list.size()];
        float[] fArray4 = new float[list2.size()];
        float[] fArray5 = new float[list.size() - 1];
        float[] fArray6 = new float[list.size()];
        for (n2 = 0; n2 < fArray.length; ++n2) {
            fArray[n2] = list.get((int)n2).getPosition().x;
            fArray3[n2] = list.get((int)n2).getPosition().y;
            fArray4[n2] = list2.get((int)n2).getPosition().y;
            fArray2[n2] = this.computeNewX(f, f2, fArray[n2]);
            if (n2 == 0) continue;
            fArray5[n2 - 1] = (fArray[n2] - fArray[n2 - 1]) * ((fArray3[n2 - 1] + fArray3[n2]) / 2.0f - (fArray4[n2 - 1] + fArray4[n2]) / 2.0f);
        }
        fArray6[0] = (fArray2[1] - fArray2[0]) / (fArray[1] - fArray[0]);
        fArray6[fArray6.length - 1] = (fArray2[fArray6.length - 1] - fArray2[fArray6.length - 2]) / (fArray[fArray6.length - 1] - fArray[fArray6.length - 2]);
        for (n2 = 1; n2 < fArray6.length - 1; ++n2) {
            float f3 = (fArray2[n2] - fArray2[n2 - 1]) / (fArray[n2] - fArray[n2 - 1]);
            float f4 = (fArray2[n2 + 1] - fArray2[n2]) / (fArray[n2 + 1] - fArray[n2]);
            fArray6[n2] = (f3 + f4) / 2.0f;
        }
        Region[] regionArray = new Region[]{this.getLithosphere(), this.getCrust()};
        int n3 = regionArray.length;
        for (int i = 0; i < n3; ++i) {
            Region region = regionArray[i];
            for (int j = 0; j < this.getCrust().getTopBoundary().samples.size(); ++j) {
                float f5 = (this.getCrust().getTopBoundary().samples.get((int)j).getPosition().y + this.getCrust().getBottomBoundary().samples.get((int)j).getPosition().y) / 2.0f;
                for (Boundary boundary2 : region.getBoundaries()) {
                    Sample sample = boundary2.samples.get(j);
                    Vector3F vector3F = sample.getPosition();
                    float f6 = vector3F.x;
                    float f7 = vector3F.y;
                    float f8 = f6 == 0.0f ? 0.0f : this.computeNewX(f, f2, f6);
                    float f9 = (f7 - f5) / fArray6[j] + f5;
                    float f10 = f9 - f7;
                    Vector3F vector3F2 = new Vector3F(f8 - f6, f10, 0.0f);
                    sample.setPosition(vector3F.plus(vector3F2));
                    if (boundary2 != this.getCrust().getTopBoundary()) continue;
                    this.getTerrain().xPositions.set(j, Float.valueOf(f8));
                    for (int k = 0; k < this.getTerrain().getNumRows(); ++k) {
                        TerrainSample terrainSample = this.getPlate().getTerrain().getSample(j, k);
                        terrainSample.setElevation(terrainSample.getElevation() + f10);
                    }
                }
            }
        }
        for (n = 0; n < this.getCrust().getTopBoundary().samples.size(); ++n) {
            for (n3 = 0; n3 < this.getTerrain().getNumRows(); ++n3) {
                TerrainSample terrainSample = this.getPlate().getTerrain().getSample(n, n3);
                float f11 = (float)MathUtil.clamp(0.0, (terrainSample.getElevation() - 6000.0f) / 7000.0f, 1.0);
                float f12 = f11 * terrainSample.getRandomElevationOffset();
                terrainSample.setElevation(terrainSample.getElevation() + (f12 *= f / 5.0f));
                if (n3 != this.getPlate().getTerrain().getFrontZIndex()) continue;
                Sample sample = this.getCrust().getTopBoundary().samples.get(n);
                sample.setPosition(sample.getPosition().plus(new Vector3F(0.0f, f12, 0.0f)));
            }
        }
        if (this.getSide() == Side.RIGHT) {
            for (n = 0; n < this.getPlate().getTerrain().getNumRows(); ++n) {
                float f13 = this.getOtherPlate().getTerrain().getSample(this.getOtherPlate().getTerrain().getNumColumns() - 1, n).getElevation();
                this.getTerrain().getSample(0, n).setElevation(f13);
                Sample sample = this.getPlate().getCrust().getTopBoundary().samples.get(0);
                sample.setPosition(new Vector3F(sample.getPosition().x, f13, sample.getPosition().z));
            }
        }
        this.getPlate().getTerrain().elevationChanged.updateListeners();
    }

    private float timeFormula(float f) {
        float f2 = 10.0f;
        return (float)((double)f2 * Math.log(f / f2 + 1.0f));
    }

    private float timeModification(float f) {
        float f2 = this.timeElapsed - f;
        float f3 = this.timeElapsed;
        return this.timeFormula(f3) - this.timeFormula(f2);
    }

    private float computeNewX(float f, float f2, float f3) {
        f = this.timeModification(f);
        assert (!Float.isNaN(f));
        float f4 = (float)((double)f3 * Math.exp(-f / 30.0f));
        float f5 = f2 * 30000.0f / 2.0f * f;
        float f6 = f4 - f3;
        float f7 = Math.min(1.0f, Math.abs(f3 / 600000.0f));
        f7 = (float)((double)f7 * 0.75);
        f4 = f3 + (1.0f - f7) * f6 + f7 * f5;
        assert (!Float.isNaN(f4));
        return f4;
    }
}

