/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.model.behaviors;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.FunctionalUtils;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.platetectonics.PlateTectonicsResources;
import edu.colorado.phet.platetectonics.model.PlateMotionModel;
import edu.colorado.phet.platetectonics.model.PlateMotionPlate;
import edu.colorado.phet.platetectonics.model.PlateType;
import edu.colorado.phet.platetectonics.model.Sample;
import edu.colorado.phet.platetectonics.model.TerrainSample;
import edu.colorado.phet.platetectonics.model.behaviors.PlateBehavior;
import edu.colorado.phet.platetectonics.model.labels.RangeLabel;
import edu.colorado.phet.platetectonics.model.regions.Boundary;
import edu.colorado.phet.platetectonics.model.regions.MagmaRegion;
import edu.colorado.phet.platetectonics.model.regions.Region;
import edu.colorado.phet.platetectonics.util.MortalUpdateListener;
import edu.colorado.phet.platetectonics.util.Side;
import java.util.HashSet;
import java.util.List;

public class RiftingBehavior
extends PlateBehavior {
    private float timeElapsed = 0.0f;
    private boolean addedLabels = false;

    public RiftingBehavior(PlateMotionPlate plateMotionPlate, PlateMotionPlate plateMotionPlate2) {
        super(plateMotionPlate, plateMotionPlate2);
        this.getLithosphere().moveToFront();
        this.getCrust().moveToFront();
        plateMotionPlate.getModel().frontBoundarySideNotifier.updateListeners(plateMotionPlate.getSide());
        this.moveMantleTopTo(PlateType.OLD_OCEANIC.getCrustTopY() - 1000.0f);
        this.magmaTarget = new Vector2F(0.0f, -500.0f);
        this.magmaSpeed = 15000.0f;
    }

    protected void onMagmaRemoved(MagmaRegion magmaRegion) {
        super.onMagmaRemoved(magmaRegion);
        this.addMagmaBlob(true, magmaRegion.position.get().minus(this.magmaTarget).magnitude());
    }

    public void addMagmaBlob(boolean bl) {
        this.addMagmaBlob(bl, 0.0f);
    }

    public void addMagmaBlob(boolean bl, float f) {
        float f2 = (float)(1.5707963267948966 + (Math.random() - 0.5) * 0.5);
        Vector2F vector2F = new Vector2F(Math.cos(f2), Math.sin(f2)).negated();
        Vector2F vector2F2 = new Vector2F(0.0f, -500.0f).plus(vector2F.times(bl ? 100000.0f - f : (float)(Math.random() * 100000.0)));
        this.addMagma(vector2F2);
    }

    public void stepInTime(float f) {
        this.timeElapsed += f;
        PlateMotionModel plateMotionModel = this.plate.getModel();
        if (plateMotionModel.boundaryLabels.contains(plateMotionModel.joiningBoundaryLabel)) {
            plateMotionModel.boundaryLabels.remove(plateMotionModel.joiningBoundaryLabel);
        }
        this.removeEarthEdges();
        if (this.plate.getSide() == Side.LEFT && this.magmaChamber == null && this.plate.getSide() == Side.LEFT) {
            this.magmaChamber = new MagmaRegion(this.plate.getTextureStrategy(), PlateType.YOUNG_OCEANIC.getCrustThickness() / 3.0f, 1.5707964f, 16, new Vector2F(0.0f, -500.0f));
            this.plate.regions.add(this.magmaChamber);
            this.magmaChamber.moveToFront();
            FunctionalUtils.repeat(new Runnable(){

                public void run() {
                    RiftingBehavior.this.addMagmaBlob(false);
                }
            }, 50);
        }
        final float f2 = this.getSide().getSign() * 120000;
        float f3 = this.getLithosphere().getBottomBoundary().getApproximateYFromX(f2);
        this.moveSpreading(f);
        float f4 = this.getLithosphere().getBottomBoundary().getApproximateYFromX(f2);
        if (!this.addedLabels && (double)this.timeElapsed > 8.43664) {
            this.addedLabels = true;
            this.plate.getModel().rangeLabels.add(new RangeLabel(new Property<Vector3F>(new Vector3F()){
                {
                    super(vector3F);
                    RiftingBehavior.this.plate.getModel().modelChanged.addUpdateListener(new MortalUpdateListener(RiftingBehavior.this.plate.getModel().modelChanged, RiftingBehavior.this.plate.disposed){

                        public void update() {
                            this.set(new Vector3F(f2, RiftingBehavior.this.getCrust().getTopBoundary().getApproximateYFromX(f2), 0.0f));
                        }
                    }, true);
                }
            }, new Property<Vector3F>(new Vector3F()){
                {
                    super(vector3F);
                    RiftingBehavior.this.plate.getModel().modelChanged.addUpdateListener(new MortalUpdateListener(RiftingBehavior.this.plate.getModel().modelChanged, RiftingBehavior.this.plate.disposed){

                        public void update() {
                            this.set(new Vector3F(f2, RiftingBehavior.this.getCrust().getBottomBoundary().getApproximateYFromX(f2), 0.0f));
                        }
                    }, true);
                }
            }, PlateTectonicsResources.Strings.YOUNG_OCEANIC_CRUST, this.plate));
        }
        if (this.plate.getSide() == Side.LEFT) {
            this.animateMagma(f);
        }
    }

    private void moveSpreading(float f) {
        Region[] regionArray;
        float f2 = this.plate.getSimpleChunkWidth();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        float f3 = 15000.0f * (float)this.plate.getSide().getSign() * f;
        for (Region region : regionArray = new Region[]{this.getPlate().getLithosphere(), this.getPlate().getCrust()}) {
            for (Sample sample : region.getSamples()) {
                sample.setPosition(sample.getPosition().plus(new Vector3F(f3, 0.0f, 0.0f)));
            }
        }
        for (int i = 0; i < this.getPlate().getCrust().getTopBoundary().samples.size(); ++i) {
            Sample sample = this.getPlate().getCrust().getTopBoundary().samples.get(i);
            TerrainSample terrainSample = this.getPlate().getTerrain().getSample(i, this.getPlate().getTerrain().getFrontZIndex());
            float f4 = this.getPlate().getTerrain().xPositions.get(i).floatValue();
            Vector3F vector3F = sample.getPosition().minus(new Vector3F(f4, terrainSample.getElevation(), 0.0f));
            for (int j = 0; j < this.getPlate().getTerrain().getNumRows(); ++j) {
                TerrainSample terrainSample2 = this.getPlate().getTerrain().getSample(i, j);
                terrainSample2.setElevation(terrainSample2.getElevation() + vector3F.y);
            }
            this.getPlate().getTerrain().xPositions.set(i, Float.valueOf(f4 + vector3F.x));
        }
        Object object = this.getSampleFromCenter(this.getCrust().getTopBoundary(), 0);
        Sample sample = this.getSampleFromCenter(this.getCrust().getTopBoundary(), 1);
        float f5 = Math.abs(sample.getPosition().x - ((Sample)object).getPosition().x);
        if ((double)f5 < (double)f2 * 1.001) {
            float f6 = ((Sample)object).getPosition().x;
            float f7 = sample.getPosition().x - f2 * (float)this.plate.getSide().getSign();
            if (f7 * (float)this.plate.getSign() < 0.0f) {
                f7 = 0.0f;
            }
            float f8 = f7 - f6;
            int n = this.plate.getSide().opposite().getIndex(this.getCrust().getTopBoundary().samples);
            this.shiftColumn(n, f8);
            if (f7 != 0.0f && this.getCrust().getTopBoundary().samples.get(n).getDensity() == PlateType.YOUNG_OCEANIC.getDensity()) {
                this.sinkOceanicCrust(Math.abs(f7) / 15000.0f, n);
                hashSet.add(n);
            }
        }
        object = this.plate.getSide().opposite();
        while ((double)(this.getSampleFromCenter((Boundary)this.getCrust().getTopBoundary(), (int)0).getPosition().x * (float)this.plate.getSide().getSign()) > 1.0E-4) {
            this.plate.addSection((Side)((Object)object), PlateType.YOUNG_OCEANIC);
            if (object == Side.LEFT) {
                HashSet hashSet2 = new HashSet(hashSet);
                hashSet.clear();
                for (Integer n : hashSet2) {
                    hashSet.add(n + 1);
                }
            }
            int n = ((Side)((Object)object)).getIndex(this.getCrust().getTopBoundary().samples);
            float f9 = -500.0f - PlateType.YOUNG_OCEANIC.getCrustThickness();
            this.getCrust().layoutColumn(n, -500.0f, f9, this.plate.getTextureStrategy(), true);
            this.getLithosphere().layoutColumn(n, f9, f9, this.plate.getTextureStrategy(), true);
            for (Region region : this.getLithosphereRegions()) {
                for (Boundary boundary : region.getBoundaries()) {
                    Sample sample2 = boundary.samples.get(n);
                    Vector2F vector2F = this.plate.getTextureStrategy().mapFront(new Vector2F(sample2.getPosition().x, sample2.getPosition().y));
                    sample2.setTextureCoordinates(new Vector2F(sample2.getTextureCoordinates().x, vector2F.y));
                }
            }
            for (TerrainSample terrainSample : this.getTerrain().getColumn(n)) {
                terrainSample.setElevation(-500.0f);
            }
            float f10 = this.getSampleFromCenter((Boundary)this.getCrust().getTopBoundary(), (int)0).getPosition().x;
            if (f10 * (float)this.plate.getSide().getSign() > 0.0f) {
                int n2 = ((Side)((Object)object)).getIndex(this.getCrust().getTopBoundary().samples);
                this.sinkOceanicCrust(Math.abs(f10) / 15000.0f, n2);
                hashSet.add(n2);
                continue;
            }
            List<Sample> list = this.getCrust().getTopBoundary().samples;
            int n3 = ((Side)((Object)object)).getIndex(list);
            this.shiftColumn(n3, -((Side)((Object)object)).getEnd(list).getPosition().x);
        }
        for (int i = 0; i < this.getNumCrustXSamples(); ++i) {
            Sample sample3 = this.getCrust().getTopBoundary().samples.get(i);
            if (sample3.getDensity() != PlateType.YOUNG_OCEANIC.getDensity() || sample3.getPosition().x == 0.0f || hashSet.contains(i)) continue;
            this.sinkOceanicCrust(f, i);
        }
        RiftingBehavior.recursiveSplitCall(new VoidFunction1<Float>(){

            @Override
            public void apply(Float f) {
                for (int i = 0; i < RiftingBehavior.this.getNumCrustXSamples(); ++i) {
                    Sample sample;
                    Sample sample2 = RiftingBehavior.this.getCrust().getTopBoundary().samples.get(i);
                    if (sample2.getDensity() != PlateType.CONTINENTAL.getDensity()) continue;
                    float f2 = sample2.getPosition().y - sample2.getRandomTerrainOffset();
                    int n = 1;
                    if (i > 0) {
                        sample = RiftingBehavior.this.getCrust().getTopBoundary().samples.get(i - 1);
                        f2 += sample.getPosition().y - sample.getRandomTerrainOffset();
                        ++n;
                    }
                    if (i < RiftingBehavior.this.getNumCrustXSamples() - 1) {
                        sample = RiftingBehavior.this.getCrust().getTopBoundary().samples.get(i + 1);
                        f2 += sample.getPosition().y - sample.getRandomTerrainOffset();
                        ++n;
                    }
                    f2 /= (float)n;
                    f2 += sample2.getRandomTerrainOffset();
                    float f3 = RiftingBehavior.this.getCrust().getTopElevation(i);
                    float f4 = RiftingBehavior.this.getCrust().getBottomElevation(i);
                    float f5 = RiftingBehavior.this.getLithosphere().getBottomElevation(i);
                    float f6 = f3 - f4;
                    float f7 = (f6 - 2.0f * (f3 - f2)) / f6;
                    if (f7 > 1.0f) {
                        f7 = 1.0f;
                    }
                    f7 = (float)Math.pow(f7, 2.0f * f.floatValue());
                    float f8 = (f3 + f4) / 2.0f;
                    float f9 = (f3 - f8) * f7 + f8;
                    float f10 = (f4 - f8) * f7 * f7 + f8;
                    float f11 = (f5 - f8) * f7 * f7 + f8;
                    RiftingBehavior.this.getCrust().layoutColumn(i, f9, f10, RiftingBehavior.this.plate.getTextureStrategy(), true);
                    RiftingBehavior.this.getLithosphere().layoutColumn(i, f10, f11, RiftingBehavior.this.plate.getTextureStrategy(), true);
                    RiftingBehavior.this.getTerrain().shiftColumnElevation(i, f9 - f3);
                }
            }
        }, f, 0.1f);
        this.getPlate().getTerrain().elevationChanged.updateListeners();
    }

    private void sinkOceanicCrust(float f, int n) {
        float f2 = -500.0f;
        float f3 = PlateType.OLD_OCEANIC.getCrustTopY();
        float f4 = this.getCrust().getTopElevation(n);
        float f5 = (f4 - f2) / (f3 - f2);
        float f6 = (float)Math.tan((double)f5 * 1.5707963267948966);
        float f7 = f6 + f * 4.0f;
        float f8 = (float)(Math.atan(f7) / 1.5707963267948966);
        assert (f5 >= 0.0f);
        assert (f5 <= 1.0f);
        assert (f6 >= 0.0f);
        assert (f8 >= 0.0f);
        assert (f8 <= 1.0f);
        float f9 = (1.0f - f8) * f2 + f8 * f3;
        float f10 = f9 - f4;
        for (Region region : this.getLithosphereRegions()) {
            for (Boundary boundary : region.getBoundaries()) {
                Sample sample = boundary.samples.get(n);
                sample.setPosition(sample.getPosition().plus(Vector3F.Y_UNIT.times(f10)));
            }
        }
        this.getTerrain().shiftColumnElevation(n, f10);
        float f11 = this.plate.getLithosphere().getTopElevation(n);
        f4 = this.plate.getLithosphere().getBottomElevation(n);
        f5 = 1.0f;
        f6 = PlateType.YOUNG_OCEANIC.getMantleLithosphereThickness();
        f7 = (f11 - f4) / f6;
        if (f7 > 1.0f) {
            f7 = 1.0f;
        }
        if (f7 < 0.0f) {
            f7 = 0.0f;
        }
        f8 = (float)Math.tan((double)f7 * 1.5707963267948966);
        f9 = f8 + f * f5;
        f10 = (float)(Math.atan(f9) / 1.5707963267948966);
        float f12 = f11 - f6 * f10;
        this.plate.getLithosphere().layoutColumn(n, f11, f12, this.plate.getTextureStrategy(), true);
    }

    private void shiftColumn(int n, float f) {
        for (Region region : this.getLithosphereRegions()) {
            for (Boundary boundary : region.getBoundaries()) {
                boundary.samples.get(n).shiftWithTexture(new Vector3F(f, 0.0f, 0.0f), this.plate.getTextureStrategy());
            }
        }
        this.getTerrain().shiftColumnXWithTexture(this.plate.getTextureStrategy(), n, f);
        this.getTerrain().columnsModified.updateListeners();
    }

    private Sample getSampleFromCenter(Boundary boundary, int n) {
        return boundary.getEdgeSample(this.getPlate().getSide().opposite(), n);
    }
}

