/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.model.behaviors;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.platetectonics.model.PlateMotionModel;
import edu.colorado.phet.platetectonics.model.PlateMotionPlate;
import edu.colorado.phet.platetectonics.model.PlateType;
import edu.colorado.phet.platetectonics.model.Sample;
import edu.colorado.phet.platetectonics.model.TerrainSample;
import edu.colorado.phet.platetectonics.model.behaviors.PlateBehavior;
import edu.colorado.phet.platetectonics.model.regions.Boundary;
import edu.colorado.phet.platetectonics.model.regions.Region;
import edu.colorado.phet.platetectonics.util.Side;

public class SubductingBehavior
extends PlateBehavior {
    private float timeElapsed = 0.0f;
    private int regionToTerrainOffset = 0;
    private final float y0 = this.plate.getPlateType().getCrustTopY() - this.plate.getPlateType().getLithosphereThickness() / 2.0f;
    private final float m = this.plate.getPlateType().getLithosphereThickness() / 2.0f;
    private final float cb = this.plate.getPlateType().getLithosphereThickness() / 2.0f - this.plate.getPlateType().getCrustThickness();
    private final float totalAngle = (float)(0.7853981633974483 * (this.plate.getPlateType() == PlateType.OLD_OCEANIC ? 1.2 : 0.8));
    private final float theta0 = this.totalAngle * 0.25f;
    private final float theta1 = this.totalAngle * 0.5f;
    private final float theta2 = this.totalAngle * 0.25f;
    private final float radius0 = 90000.0f;
    private final float radius1 = 40000.0f;
    private final float radius2 = 90000.0f;
    private final float t0 = 0.0f;
    private final float t1 = this.theta0 * 90000.0f;
    private final float t2 = this.t1 + this.theta1 * 40000.0f;
    private final float t3 = this.t2 + this.theta2 * 90000.0f;
    private final Vector2F center0 = new Vector2F(0.0f, this.y0 - 90000.0f);
    private static final Vector2F value_pd0 = new Vector2F(-1.0f, 0.0f);
    private final Vector2F center1 = this.p1(this.t1).plus(this.center0.minus(this.p1(this.t1)).normalized().times(40000.0f));
    private final Vector2F center2 = this.p2(this.t2).plus(this.center1.minus(this.p2(this.t2)).normalized().times(90000.0f));
    private final Vector2F dir4 = SubductingBehavior.vectorFromAngle((float)((double)this.totalAngle + Math.PI));
    private final Vector2F p3oft3 = this.p3(this.t3);

    public SubductingBehavior(PlateMotionPlate plateMotionPlate, PlateMotionPlate plateMotionPlate2) {
        super(plateMotionPlate, plateMotionPlate2);
    }

    public void afterConstructionInit() {
        super.afterConstructionInit();
        this.getLithosphere().moveToFront();
        this.getCrust().moveToFront();
        this.plate.getModel().frontBoundarySideNotifier.updateListeners(this.plate.getSide());
    }

    public void stepInTime(float f) {
        int n;
        this.timeElapsed += f;
        this.createEarthEdges();
        float f2 = 0.0f;
        int n2 = 0;
        ColumnResult[] columnResultArray = new ColumnResult[this.getNumCrustXSamples()];
        for (n = 0; n < this.getNumCrustXSamples(); ++n) {
            Vector2F vector2F = new Vector2F(this.getOffsetSize(), 0.0f);
            columnResultArray[n] = this.computeSubductingPosition(this.getT(n), vector2F);
        }
        for (n = 0; n < this.getNumCrustXSamples(); ++n) {
            int n3 = n + this.regionToTerrainOffset;
            if (n3 < 0 || n3 >= this.getNumTerrainXSamples()) continue;
            Sample sample = this.getCrust().getTopBoundary().samples.get(n);
            Vector2F object = new Vector2F(sample.getPosition().x, sample.getPosition().y);
            Vector2F vector2F = columnResultArray[n].crustTop;
            Vector2F vector2F2 = vector2F.minus(object);
            this.getTerrain().xPositions.set(n3, Float.valueOf(vector2F.x));
            for (TerrainSample terrainSample : this.getTerrain().getColumn(n3)) {
                terrainSample.setElevation(terrainSample.getElevation() + vector2F2.y);
            }
        }
        while (this.getOppositeSide().isToSideOf(this.getTerrain().xPositions.get(this.getCenterTerrainIndex(0)).floatValue(), 0.0f)) {
            if (this.getOppositeSide().isToSideOf(this.getTerrain().xPositions.get(this.getCenterTerrainIndex(1)).floatValue(), 0.0f)) {
                this.getTerrain().removeColumn(this.getOppositeSide());
                if (this.getSide() != Side.RIGHT) continue;
                --this.regionToTerrainOffset;
                continue;
            }
            float f3 = -this.getTerrain().xPositions.get(this.getCenterTerrainIndex(0)).floatValue();
            this.getTerrain().shiftColumnXWithTexture(this.plate.getTextureStrategy(), this.getCenterTerrainIndex(0), f3);
            break;
        }
        for (Region region : this.getLithosphereRegions()) {
            boolean bl = region == this.getCrust();
            for (int i = 0; i < this.getNumCrustXSamples(); ++i) {
                Vector2F vector2F = bl ? columnResultArray[i].crustTop : columnResultArray[i].crustBottom;
                Vector2F vector2F3 = bl ? columnResultArray[i].crustBottom : columnResultArray[i].lithosphereBottom;
                for (int j = 0; j < region.getBoundaries().size(); ++j) {
                    Boundary boundary = region.getBoundaries().get(j);
                    float f3 = (float)j / (float)(region.getBoundaries().size() - 1);
                    Sample sample = boundary.samples.get(i);
                    Vector3F vector3F = new Vector3F((1.0f - f3) * vector2F.x + f3 * vector2F3.x, (1.0f - f3) * vector2F.y + f3 * vector2F3.y, sample.getPosition().z);
                    sample.setPosition(vector3F);
                    if (vector3F.y < -100000.0f && vector3F.y > -150000.0f) {
                        f2 += vector3F.x;
                        ++n2;
                    }
                    if (!(vector3F.y < -150000.0f)) continue;
                    float f4 = sample.getTemperature();
                    float f5 = sample.getDensity();
                    float f6 = PlateMotionModel.SIMPLE_MANTLE_BOTTOM_TEMP;
                    float f7 = 3300.0f;
                    float f8 = (float)(1.0 - Math.exp(-f * 0.08f));
                    sample.setDensity(f5 * (1.0f - f8) + f7 * f8);
                    sample.setTemperature(f4 * (1.0f - f8) + f6 * f8);
                }
            }
        }
        float f10 = this.getBoundaryElevation();
        int n4 = this.getOppositeSide().getIndex(this.getNumTerrainXSamples());
        this.getTerrain().setColumnElevation(n4, f10);
        this.getPlate().getTerrain().elevationChanged.updateListeners();
    }

    public Vector2F getLowestMeltingLocation() {
        float f = Float.MAX_VALUE;
        Vector2F vector2F = null;
        for (Sample sample : this.getTopCrustBoundary().samples) {
            float f2 = sample.getPosition().y;
            if (!(f2 < -110000.0f) || !(f2 > -150000.0f) || !(f2 < f)) continue;
            f = f2;
            vector2F = new Vector2F(sample.getPosition().x, sample.getPosition().y);
        }
        return vector2F;
    }

    public Vector2F getHighestMeltingLocation() {
        float f = -3.4028235E38f;
        Vector2F vector2F = null;
        for (Sample sample : this.getTopCrustBoundary().samples) {
            float f2 = sample.getPosition().y;
            if (!(f2 < -100000.0f) || !(f2 > -150000.0f) || !(f2 > f)) continue;
            f = f2;
            vector2F = new Vector2F(sample.getPosition().x, sample.getPosition().y);
        }
        return vector2F;
    }

    private int getCenterTerrainIndex(int n) {
        return this.getOppositeSide().getFromIndex(this.getNumTerrainXSamples(), n);
    }

    public float getBoundaryElevation() {
        Sample sample = null;
        for (Sample sample2 : this.getCrust().getTopBoundary().samples) {
            if (sample2.getPosition().x == 0.0f) {
                return sample2.getPosition().y;
            }
            if (sample != null && sample2.getPosition().x * sample.getPosition().x < 0.0f) {
                return SubductingBehavior.yInterceptAtX0BetweenPoints(sample2.getPosition(), sample.getPosition());
            }
            sample = sample2;
        }
        System.out.println("WARNING: using overridden y-intercept value for boundary elevation in subduction case");
        return this.getOppositeSide().getEnd(this.getCrust().getTopBoundary().samples).getPosition().y;
    }

    private static float yInterceptAtX0BetweenPoints(Vector3F vector3F, Vector3F vector3F2) {
        return vector3F.y - vector3F.x * (vector3F2.y - vector3F.y) / (vector3F2.x - vector3F.x);
    }

    public float getT(int n) {
        float f = this.plate.getSimpleChunkWidth();
        float f2 = f * (float)(this.getSide() == Side.LEFT ? -(this.getNumCrustXSamples() - 1 - n) : -n);
        return f2 + this.timeElapsed * 15000.0f + this.getOffsetSize();
    }

    private float getOffsetSize() {
        float f = this.timeElapsed * 15000.0f * 0.4f * (this.plate.getPlateType() == PlateType.OLD_OCEANIC ? 1.7f : 1.0f);
        if (f > 32000.0f) {
            return 32000.0f;
        }
        float f2 = f / 32000.0f;
        float f3 = -f2 * f2 + 2.0f * f2;
        return f3 * 32000.0f;
    }

    private Vector2F p0(float f) {
        return new Vector2F(-f, this.y0);
    }

    private Vector2F pd0(float f) {
        return value_pd0;
    }

    private Vector2F p1(float f) {
        float f2 = (float)(1.5707963267948966 + (double)((f - 0.0f) / 90000.0f));
        return this.center0.plus(SubductingBehavior.vectorFromAngle(f2).times(90000.0f));
    }

    private Vector2F pd1(float f) {
        return SubductingBehavior.bottomFromTangent(this.p1(f).minus(this.center0).normalized());
    }

    private Vector2F p2(float f) {
        float f2 = (float)(1.5707963267948966 + (double)this.theta0 + (double)((f - this.t1) / 40000.0f));
        return this.center1.plus(SubductingBehavior.vectorFromAngle(f2).times(40000.0f));
    }

    private Vector2F pd2(float f) {
        return SubductingBehavior.bottomFromTangent(this.p2(f).minus(this.center1).normalized());
    }

    private Vector2F p3(float f) {
        float f2 = (float)(1.5707963267948966 + (double)this.theta0 + (double)this.theta1 + (double)((f - this.t2) / 90000.0f));
        return this.center2.plus(SubductingBehavior.vectorFromAngle(f2).times(90000.0f));
    }

    private Vector2F pd3(float f) {
        return SubductingBehavior.bottomFromTangent(this.p3(f).minus(this.center2).normalized());
    }

    private Vector2F p4(float f) {
        return this.p3oft3.plus(this.dir4.times(f - this.t3));
    }

    private Vector2F pd4(float f) {
        return this.dir4;
    }

    public ColumnResult computeSubductingPosition(float f, Vector2F vector2F) {
        Vector2F vector2F2;
        Vector2F vector2F3;
        if (f < 0.0f) {
            vector2F3 = this.p0(f);
            vector2F2 = this.pd0(f);
        } else if (f < this.t1) {
            vector2F3 = this.p1(f);
            vector2F2 = this.pd1(f);
        } else if (f < this.t2) {
            vector2F3 = this.p2(f);
            vector2F2 = this.pd2(f);
        } else if (f < this.t3) {
            vector2F3 = this.p3(f);
            vector2F2 = this.pd3(f);
        } else {
            vector2F3 = this.p4(f);
            vector2F2 = this.pd4(f);
        }
        Vector2F vector2F4 = SubductingBehavior.topFromTangent(vector2F2);
        vector2F3 = vector2F3.plus(vector2F);
        if (this.getSide() == Side.LEFT) {
            vector2F3 = new Vector2F(-vector2F3.x, vector2F3.y);
            vector2F4 = new Vector2F(-vector2F4.x, vector2F4.y);
        }
        return new ColumnResult(vector2F3.plus(vector2F4.times(this.m)), vector2F3.plus(vector2F4.times(this.cb)), vector2F3.plus(vector2F4.times(-this.m)), vector2F3);
    }

    private static Vector2F topFromTangent(Vector2F vector2F) {
        return new Vector2F(vector2F.y, -vector2F.x);
    }

    private static Vector2F bottomFromTangent(Vector2F vector2F) {
        return SubductingBehavior.topFromTangent(vector2F).negated();
    }

    private static Vector2F vectorFromAngle(float f) {
        return new Vector2F(Math.cos(f), Math.sin(f));
    }

    public static class ColumnResult {
        public final Vector2F crustTop;
        public final Vector2F crustBottom;
        public final Vector2F lithosphereBottom;
        public final Vector2F lithosphereCenter;

        public ColumnResult(Vector2F vector2F, Vector2F vector2F2, Vector2F vector2F3, Vector2F vector2F4) {
            this.crustTop = vector2F;
            this.crustBottom = vector2F2;
            this.lithosphereBottom = vector2F3;
            this.lithosphereCenter = vector2F4;
        }
    }
}

