/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.model.regions;

import edu.colorado.phet.platetectonics.model.Sample;
import edu.colorado.phet.platetectonics.util.Side;
import java.util.ArrayList;
import java.util.List;

public class Boundary {
    public List<Sample> samples = new ArrayList<Sample>();

    public void addSample(Side side, Sample sample) {
        side.addToList(this.samples, sample);
    }

    public void removeSample(Side side) {
        side.removeFromList(this.samples);
    }

    public void replaceSample(Sample sample, Sample sample2) {
        int n = this.samples.indexOf(sample);
        this.samples.remove(n);
        this.samples.add(n, sample2);
    }

    public Sample getSample(int n) {
        return this.samples.get(n);
    }

    public Sample getEdgeSample(Side side) {
        return side.getEnd(this.samples);
    }

    public Sample getEdgeSample(Side side, int n) {
        return side.getFromEnd(this.samples, n);
    }

    public float getApproximateYFromX(float f) {
        Sample sample;
        if (f <= this.getEdgeSample((Side)Side.LEFT).getPosition().x) {
            return this.getEdgeSample((Side)Side.LEFT).getPosition().y;
        }
        if (f >= this.getEdgeSample((Side)Side.RIGHT).getPosition().x) {
            return this.getEdgeSample((Side)Side.RIGHT).getPosition().y;
        }
        int n = 0;
        int n2 = this.samples.size() - 1;
        assert (n < n2);
        while (n + 1 != n2) {
            assert (n != n2);
            int n3 = (n + n2) / 2;
            sample = this.samples.get(n3);
            if (f >= sample.getPosition().x) {
                n = n3;
                continue;
            }
            n2 = n3;
        }
        Sample sample2 = this.samples.get(n);
        sample = this.samples.get(n2);
        float f2 = (f - sample2.getPosition().x) / (sample.getPosition().x - sample2.getPosition().x);
        return f2 * sample.getPosition().y + (1.0f - f2) * sample2.getPosition().y;
    }
}

