/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.model.regions;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.common.phetcommon.model.property.ChangeObserver;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.Function2;
import edu.colorado.phet.platetectonics.model.PlateMotionModel;
import edu.colorado.phet.platetectonics.model.Sample;
import edu.colorado.phet.platetectonics.model.TextureStrategy;
import edu.colorado.phet.platetectonics.model.regions.Region;

public class MagmaRegion
extends Region {
    public final Property<Float> alpha = new Property<Float>(Float.valueOf(1.0f));
    public final Property<Vector2F> position;

    public MagmaRegion(final TextureStrategy textureStrategy, final float f, final float f2, final int n, Vector2F vector2F) {
        super(1, n, new Function2<Integer, Integer, Sample>(){
            private Vector2F textureOffset = new Vector2F(Math.random(), Math.random());

            @Override
            public Sample apply(Integer n3, Integer n2) {
                float f3 = (float)n2.intValue() / (float)(n - 1);
                float f22 = (float)(n3 == 0 ? (double)(1.0f - f3) * Math.PI : (double)(1.0f - f3) * -Math.PI);
                Vector2F vector2F = MagmaRegion.computeTeardropShape(f22).times(f).getRotatedInstance(f2);
                return new Sample(new Vector3F(vector2F.x, vector2F.y, 0.0f), PlateMotionModel.SIMPLE_MAGMA_TEMP, 2000.0f, textureStrategy.mapFront(vector2F).plus(this.textureOffset));
            }
        });
        this.position = new Property<Vector2F>(vector2F);
        for (Sample sample : this.getSamples()) {
            sample.setPosition(sample.getPosition().plus(new Vector3F(vector2F.x, vector2F.y, 0.0f)));
        }
        this.position.addObserver(new ChangeObserver<Vector2F>(){

            @Override
            public void update(Vector2F vector2F, Vector2F vector2F2) {
                Vector3F vector3F = new Vector3F(vector2F.x - vector2F2.x, vector2F.y - vector2F2.y, 0.0f);
                for (Sample sample : MagmaRegion.this.getSamples()) {
                    sample.setPosition(sample.getPosition().plus(vector3F));
                }
            }
        });
        this.alpha.addObserver(new SimpleObserver(){

            public void update() {
                MagmaRegion.this.setAllAlphas(MagmaRegion.this.alpha.get().floatValue());
            }
        });
    }

    private static Vector2F computeTeardropShape(float f) {
        double d = 1.0 * Math.max(0.0, Math.cos(f));
        return new Vector2F(Math.cos(f) + d, Math.sin(f) * (1.0 - d * d)).minus(new Vector2F(2.0, 0.0));
    }
}

