/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.tabs;

import edu.colorado.phet.common.phetcommon.math.Bounds3F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.common.phetcommon.model.event.UpdateListener;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.ControlPanelNode;
import edu.colorado.phet.lwjglphet.LWJGLCanvas;
import edu.colorado.phet.lwjglphet.LWJGLTab;
import edu.colorado.phet.lwjglphet.nodes.GLNode;
import edu.colorado.phet.lwjglphet.nodes.OrthoPiccoloNode;
import edu.colorado.phet.platetectonics.PlateTectonicsResources;
import edu.colorado.phet.platetectonics.PlateTectonicsSimSharing;
import edu.colorado.phet.platetectonics.control.DraggableTool2D;
import edu.colorado.phet.platetectonics.control.LegendPanel;
import edu.colorado.phet.platetectonics.control.MyCrustPanel;
import edu.colorado.phet.platetectonics.control.ResetPanel;
import edu.colorado.phet.platetectonics.control.ViewOptionsPanel;
import edu.colorado.phet.platetectonics.control.ZoomPanel;
import edu.colorado.phet.platetectonics.model.CrustModel;
import edu.colorado.phet.platetectonics.model.PlateTectonicsModel;
import edu.colorado.phet.platetectonics.tabs.PlateTectonicsTab;
import edu.colorado.phet.platetectonics.view.ColorMode;
import edu.colorado.phet.platetectonics.view.PlateTectonicsView;
import edu.colorado.phet.platetectonics.view.labels.RangeLabelNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;
import java.util.ArrayList;

public class CrustTab
extends PlateTectonicsTab {
    private Property<Float> scaleProperty = new Property<Float>(Float.valueOf(1.0f));
    private final Property<Boolean> showLabels = new Property<Boolean>(false);
    private OrthoPiccoloNode optionsPiccoloNode;
    private MyCrustPanel myCrustPanel;
    private ZoomPanel zoomPanel;

    public CrustTab(LWJGLCanvas lWJGLCanvas) {
        super(lWJGLCanvas, PlateTectonicsResources.Strings.CRUST_TAB, 2.0f);
        this.zoomRatio.addObserver(new SimpleObserver(){

            public void update() {
                CrustTab.this.scaleProperty.set(Float.valueOf(CrustTab.this.getSceneDistanceZoomFactor()));
            }
        });
    }

    public void initialize() {
        super.initialize();
        this.getClock().start();
        Bounds3F bounds3F = Bounds3F.fromMinMax(-1500000.0f, 1500000.0f, -150000.0f, 15000.0f, -2000000.0f, 0.0f);
        this.setModel(new CrustModel(bounds3F));
        this.sceneLayer.addChild(new PlateTectonicsView(this.getModel(), this));
        final Function1<Vector3F, Vector3F> function1 = new Function1<Vector3F, Vector3F>(){

            @Override
            public Vector3F apply(Vector3F vector3F) {
                return CrustTab.this.getModelViewTransform().transformPosition(PlateTectonicsModel.convertToRadial(vector3F));
            }
        };
        GLNode gLNode = new GLNode(){
            {
                CrustTab.this.showLabels.addObserver(new SimpleObserver(){

                    public void update() {
                        this.setVisible((Boolean)CrustTab.this.showLabels.get());
                    }
                });
            }
        };
        this.sceneLayer.addChild(gLNode);
        gLNode.addChild(new RangeLabelNode(null, new Property<Vector3F>(new Vector3F()){
            {
                super(vector3F);
                CrustTab.this.beforeFrameRender.addUpdateListener(new UpdateListener(){

                    public void update() {
                        this.set(function1.apply(new Vector3F(-10000.0f, (float)CrustTab.this.getCrustModel().getCenterCrustElevation(), 0.0f)));
                    }
                }, true);
            }
        }, new Property<Vector3F>(new Vector3F()){
            {
                super(vector3F);
                CrustTab.this.beforeFrameRender.addUpdateListener(new UpdateListener(){

                    public void update() {
                        this.set(function1.apply(new Vector3F(-10000.0f, (float)CrustTab.this.getCrustModel().getCenterCrustBottomY(), 0.0f)));
                    }
                }, true);
            }
        }, PlateTectonicsResources.Strings.CRUST, this.scaleProperty, this.colorMode, true));
        Property<Vector3F> property = new Property<Vector3F>(new Vector3F()){
            {
                super(vector3F);
                CrustTab.this.beforeFrameRender.addUpdateListener(new UpdateListener(){

                    public void update() {
                        this.set(function1.apply(new Vector3F(0.0f, (float)CrustTab.this.getCrustModel().getCenterCrustBottomY(), 0.0f)));
                    }
                }, true);
            }
        };
        Property<Vector3F> property2 = new Property<Vector3F>((Vector3F)function1.apply(new Vector3F(0.0f, -750000.0f, 0.0f)));
        gLNode.addChild(new RangeLabelNode(null, property, property2, PlateTectonicsResources.Strings.MANTLE, this.scaleProperty, this.colorMode, true, this.getLabelPosition(property, property2, this.scaleProperty)));
        Property<Vector3F> property3 = new Property<Vector3F>((Vector3F)function1.apply(new Vector3F(150000.0f, -750000.0f, 0.0f)));
        Property<Vector3F> property4 = new Property<Vector3F>((Vector3F)function1.apply(new Vector3F(150000.0f, -2921000.0f, 0.0f)));
        gLNode.addChild(new RangeLabelNode(null, property3, property4, PlateTectonicsResources.Strings.LOWER_MANTLE, this.scaleProperty, this.colorMode, true, this.getLabelPosition(property3, property4, this.scaleProperty)));
        Property<Vector3F> property5 = new Property<Vector3F>((Vector3F)function1.apply(new Vector3F(-250000.0f, -2921000.0f, 0.0f)));
        Property<Vector3F> property6 = new Property<Vector3F>((Vector3F)function1.apply(new Vector3F(-250000.0f, -5180000.0f, 0.0f)));
        gLNode.addChild(new RangeLabelNode(null, property5, property6, PlateTectonicsResources.Strings.OUTER_CORE, this.scaleProperty, this.colorMode, false, this.getLabelPosition(property5, property6, this.scaleProperty)));
        Property<Vector3F> property7 = new Property<Vector3F>((Vector3F)function1.apply(new Vector3F(250000.0f, -5180000.0f, 0.0f)));
        Property<Vector3F> property8 = new Property<Vector3F>((Vector3F)function1.apply(new Vector3F(250000.0f, -6371000.0f, 0.0f)));
        gLNode.addChild(new RangeLabelNode(null, property7, property8, PlateTectonicsResources.Strings.INNER_CORE, this.scaleProperty, this.colorMode, false, this.getLabelPosition(property7, property8, this.scaleProperty)));
        this.myCrustPanel = new MyCrustPanel(this.getCrustModel());
        this.addGuiNode(new OrthoPiccoloNode(new ControlPanelNode((PNode)this.myCrustPanel), this, this.getCanvasTransform(), new Property<Vector2D>(new Vector2D()), this.mouseEventNotifier){
            {
                CrustTab.this.canvasSize.addObserver(new SimpleObserver(){

                    public void update() {
                        position.set(new Vector2D(Math.ceil((CrustTab.this.getStageSize().width - this.getComponentWidth()) / 2), 10.0));
                    }
                });
                this.updateOnEvent(CrustTab.this.beforeFrameRender);
                CrustTab.this.zoomRatio.addObserver(new SimpleObserver(){

                    public void update() {
                        this.setVisible((Double)CrustTab.this.zoomRatio.get() == 1.0);
                    }
                });
            }
        });
        this.zoomPanel = new ZoomPanel(this.zoomRatio);
        this.addGuiNode(new OrthoPiccoloNode(new ControlPanelNode((PNode)this.zoomPanel), this, this.getCanvasTransform(), new Property<Vector2D>(new Vector2D()), this.mouseEventNotifier){
            {
                CrustTab.this.canvasSize.addObserver(new SimpleObserver(){

                    public void update() {
                        position.set(new Vector2D(CrustTab.this.getStageSize().width - this.getComponentWidth() - 10, 10.0));
                    }
                });
                this.updateOnEvent(CrustTab.this.beforeFrameRender);
            }
        });
        this.optionsPiccoloNode = new OrthoPiccoloNode(new ControlPanelNode((PNode)new ViewOptionsPanel(this.showLabels, this.colorMode)), this, this.getCanvasTransform(), new Property<Vector2D>(new Vector2D()), this.mouseEventNotifier){
            {
                CrustTab.this.canvasSize.addObserver(new SimpleObserver(){

                    public void update() {
                        position.set(new Vector2D(CrustTab.this.getStageSize().width - this.getComponentWidth() - 10, CrustTab.this.getStageSize().height - this.getComponentHeight() - 10));
                    }
                });
                this.updateOnEvent(CrustTab.this.beforeFrameRender);
            }
        };
        this.addGuiNode(this.optionsPiccoloNode);
        OrthoPiccoloNode orthoPiccoloNode = new OrthoPiccoloNode(new ResetPanel(this, new Runnable(){

            public void run() {
                CrustTab.this.resetAll();
            }
        }), this, this.getCanvasTransform(), new Property<Vector2D>(new Vector2D()), this.mouseEventNotifier){
            {
                this.onResize.addUpdateListener(new UpdateListener(){

                    public void update() {
                        double d = ((Vector2D)CrustTab.this.toolboxNode.position.get()).getX() + (double)CrustTab.this.toolboxNode.getComponentWidth();
                        position.set(new Vector2D((int)(d + 10.0), CrustTab.this.getStageSize().height - this.getComponentHeight() - 25));
                    }
                }, true);
                this.updateOnEvent(CrustTab.this.beforeFrameRender);
            }
        };
        this.addGuiNode(orthoPiccoloNode);
        this.addGuiNode(new LegendPiccoloNode(ColorMode.DENSITY, (float)((Vector2D)this.optionsPiccoloNode.position.get()).getX()));
        this.addGuiNode(new LegendPiccoloNode(ColorMode.TEMPERATURE, (float)((Vector2D)this.optionsPiccoloNode.position.get()).getX()));
        this.guiLayer.addChild(new OrthoPiccoloNode(new PText(PlateTectonicsResources.Strings.OCEANIC_CRUST){
            {
                this.setFont(new PhetFont(16, true));
            }
        }, this, this.getCanvasTransform(), new Property<Vector2D>(new Vector2D(30.0, this.getStageSize().getHeight() * 0.38)), this.mouseEventNotifier){
            {
                CrustTab.this.zoomRatio.addObserver(new SimpleObserver(){

                    public void update() {
                        this.setVisible((Double)CrustTab.this.zoomRatio.get() == 1.0);
                    }
                });
            }
        });
        this.guiLayer.addChild(new OrthoPiccoloNode(new PText(PlateTectonicsResources.Strings.CONTINENTAL_CRUST){
            {
                this.setFont(new PhetFont(16, true));
            }
        }, this, this.getCanvasTransform(), new Property<Vector2D>(new Vector2D()), this.mouseEventNotifier){
            {
                this.position.set(new Vector2D(CrustTab.this.getStageSize().getWidth() - (double)this.getComponentWidth() - 30.0, CrustTab.this.getStageSize().getHeight() * 0.38));
                CrustTab.this.zoomRatio.addObserver(new SimpleObserver(){

                    public void update() {
                        this.setVisible((Double)CrustTab.this.zoomRatio.get() == 1.0);
                    }
                });
            }
        });
        this.guiLayer.addChild(this.createFPSReadout(Color.BLACK));
        this.zoomRatio.addObserver(new SimpleObserver(){

            public void update() {
                for (GLNode gLNode : new ArrayList<GLNode>(CrustTab.this.toolLayer.getChildren())) {
                    DraggableTool2D draggableTool2D = (DraggableTool2D)((Object)gLNode);
                    if (CrustTab.this.isToolInBounds(draggableTool2D)) continue;
                    CrustTab.this.toolDragHandler.putToolBackInToolbox(draggableTool2D);
                }
            }
        });
    }

    public void resetAll() {
        super.resetAll();
        this.showLabels.reset();
        this.myCrustPanel.resetAll();
        this.zoomPanel.resetAll();
    }

    public boolean isWaterVisible() {
        return true;
    }

    public CrustModel getCrustModel() {
        return (CrustModel)this.getModel();
    }

    public IUserComponent getUserComponent() {
        return PlateTectonicsSimSharing.UserComponents.crustTab;
    }

    private class LegendPiccoloNode
    extends OrthoPiccoloNode {
        public LegendPiccoloNode(final ColorMode colorMode, final float f) {
            super(new ControlPanelNode((PNode)new LegendPanel(colorMode)), (LWJGLTab)CrustTab.this, CrustTab.this.getCanvasTransform(), new Property<Vector2D>(new Vector2D()), CrustTab.this.mouseEventNotifier);
            CrustTab.this.canvasSize.addObserver(new SimpleObserver(){

                public void update() {
                    LegendPiccoloNode.this.position.set(new Vector2D(f - (float)LegendPiccoloNode.this.getComponentWidth() - 20.0f, CrustTab.this.getStageSize().height - LegendPiccoloNode.this.getComponentHeight() - 10));
                }
            });
            CrustTab.this.colorMode.addObserver(new SimpleObserver(){

                public void update() {
                    LegendPiccoloNode.this.setVisible(CrustTab.this.colorMode.get() == colorMode);
                }
            });
        }
    }
}

