/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.util;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PiecewiseLinearFunction2D
implements Function1<Double, Double> {
    private List<Vector2D> points = new ArrayList<Vector2D>();

    public PiecewiseLinearFunction2D(Vector2D ... vector2DArray) {
        for (Vector2D vector2D : vector2DArray) {
            this.points.add(vector2D);
        }
    }

    @Override
    public Double apply(Double d) {
        for (int i = 0; i < this.points.size() - 1; ++i) {
            if (!(this.points.get(i + 1).getX() > d)) continue;
            return this.evaluateAtSegment(i, d);
        }
        return this.evaluateAtSegment(this.points.size() - 2, d);
    }

    private double evaluateAtSegment(int n, double d) {
        Vector2D vector2D = this.points.get(n);
        Vector2D vector2D2 = this.points.get(n + 1);
        double d2 = vector2D2.getX() - vector2D.getX();
        double d3 = vector2D2.getY() - vector2D.getY();
        double d4 = (d - vector2D.getX()) / d2;
        return vector2D.getY() + d4 * d3;
    }
}

