/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.view;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.lwjglphet.GLOptions;
import edu.colorado.phet.lwjglphet.math.LWJGLTransform;
import edu.colorado.phet.lwjglphet.nodes.GLNode;
import edu.colorado.phet.platetectonics.model.PlateTectonicsModel;
import edu.colorado.phet.platetectonics.model.Sample;
import edu.colorado.phet.platetectonics.model.regions.CrossSectionStrip;
import edu.colorado.phet.platetectonics.util.MortalSimpleObserver;
import edu.colorado.phet.platetectonics.util.MortalUpdateListener;
import edu.colorado.phet.platetectonics.view.ColorMode;
import edu.colorado.phet.platetectonics.view.materials.EarthTexture;
import java.awt.Color;
import java.nio.FloatBuffer;
import java.util.ListIterator;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrossSectionStripNode
extends GLNode {
    private LWJGLTransform modelViewTransform;
    private Property<ColorMode> colorMode;
    public final CrossSectionStrip strip;
    private int capacity = 0;
    private FloatBuffer positionBuffer;
    private FloatBuffer textureBuffer;
    private FloatBuffer colorBuffer;
    private boolean checkDepth = true;
    private boolean transparencyInitialized = false;

    public CrossSectionStripNode(LWJGLTransform lWJGLTransform, Property<ColorMode> property, final CrossSectionStrip crossSectionStrip) {
        this.modelViewTransform = lWJGLTransform;
        this.colorMode = property;
        this.strip = crossSectionStrip;
        crossSectionStrip.alpha.addObserver(new MortalSimpleObserver(crossSectionStrip.alpha, crossSectionStrip.disposed){

            public void update() {
                if (!CrossSectionStripNode.this.transparencyInitialized && crossSectionStrip.alpha.get().floatValue() != 1.0f) {
                    CrossSectionStripNode.this.transparencyInitialized = true;
                    CrossSectionStripNode.this.requireEnabled(3042);
                }
            }
        });
        crossSectionStrip.changed.addUpdateListener(new MortalUpdateListener(crossSectionStrip.changed, crossSectionStrip.disposed){

            public void update() {
                CrossSectionStripNode.this.updatePosition();
            }
        }, true);
        property.addObserver(new MortalSimpleObserver(property, crossSectionStrip.disposed){

            public void update() {
                CrossSectionStripNode.this.updatePosition();
            }
        });
        crossSectionStrip.moveToFrontNotifier.addUpdateListener(new MortalUpdateListener(crossSectionStrip.moveToFrontNotifier, crossSectionStrip.disposed){

            public void update() {
                CrossSectionStripNode.this.checkDepth = false;
            }
        }, false);
    }

    private void checkSize() {
        int n = Math.max(10, this.strip.getNumberOfVertices());
        if (this.capacity < n) {
            this.capacity = n;
            this.positionBuffer = BufferUtils.createFloatBuffer(n * 3);
            this.textureBuffer = BufferUtils.createFloatBuffer(n * 2);
            this.colorBuffer = BufferUtils.createFloatBuffer(n * 4);
        }
    }

    public void updatePosition() {
        this.checkSize();
        this.positionBuffer.clear();
        this.textureBuffer.clear();
        this.colorBuffer.clear();
        ListIterator<Sample> listIterator = this.strip.topPoints.listIterator();
        ListIterator<Sample> listIterator2 = this.strip.bottomPoints.listIterator();
        while (listIterator.hasNext()) {
            this.addSamplePoint((Sample)listIterator.next());
            this.addSamplePoint((Sample)listIterator2.next());
        }
    }

    private void addSamplePoint(Sample sample) {
        Color color = this.colorMode.get().getMaterial().getColor(sample.getDensity(), sample.getTemperature(), new Vector2F(sample.getPosition().x, sample.getPosition().y), this.strip.alpha.get().floatValue());
        Vector3F vector3F = this.modelViewTransform.transformPosition(PlateTectonicsModel.convertToRadial(sample.getPosition()));
        this.colorBuffer.put(color.getComponents(new float[4]));
        this.textureBuffer.put(new float[]{sample.getTextureCoordinates().x, sample.getTextureCoordinates().y});
        this.positionBuffer.put(new float[]{vector3F.x, vector3F.y, vector3F.z});
    }

    @Override
    public void renderSelf(GLOptions gLOptions) {
        super.renderSelf(gLOptions);
        if (gLOptions.shouldSendTexture()) {
            GL11.glEnableClientState(32888);
            this.textureBuffer.rewind();
            GL11.glTexCoordPointer(2, 0, this.textureBuffer);
        }
        GL11.glEnableClientState(32886);
        this.colorBuffer.rewind();
        GL11.glColorPointer(4, 0, this.colorBuffer);
        GL11.glEnableClientState(32884);
        this.positionBuffer.rewind();
        GL11.glVertexPointer(3, 0, this.positionBuffer);
        if (!this.checkDepth) {
            GL11.glDepthFunc(519);
        }
        EarthTexture.begin();
        GL11.glDrawArrays(5, 0, this.strip.getNumberOfVertices());
        EarthTexture.end();
        if (!this.checkDepth) {
            GL11.glDepthFunc(513);
        }
        GL11.glDisableClientState(32884);
        if (gLOptions.shouldSendTexture()) {
            GL11.glDisableClientState(32888);
        }
        GL11.glDisableClientState(32886);
        GL11.glDisableClientState(32884);
    }
}

