/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.view;

import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.lwjglphet.GLOptions;
import edu.colorado.phet.lwjglphet.math.LWJGLTransform;
import edu.colorado.phet.lwjglphet.nodes.GLNode;
import edu.colorado.phet.platetectonics.model.PlateTectonicsModel;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public abstract class GridStripNode
extends GLNode {
    private final LWJGLTransform modelViewTransform;
    private int capacity = 0;
    private int lastNumXSamples = 0;
    private FloatBuffer positionBuffer;
    private FloatBuffer normalBuffer;
    private IntBuffer indexBuffer;
    private Vector3F[] positionArray;
    private boolean computeNormals = true;

    public GridStripNode(LWJGLTransform lWJGLTransform) {
        this.modelViewTransform = lWJGLTransform;
    }

    public abstract int getNumberOfVertices();

    public abstract int getNumColumns();

    public abstract int getNumRows();

    public abstract float getXPosition(int var1);

    public abstract float getZPosition(int var1);

    public abstract float getElevation(int var1, int var2);

    public void setCapacity(int n) {
        this.capacity = n;
        this.positionBuffer = BufferUtils.createFloatBuffer(n * 3);
        this.normalBuffer = BufferUtils.createFloatBuffer(n * 3);
        int n2 = this.getNumRows();
        int n3 = this.getNumColumns();
        int n4 = (n2 - 1) * n3 * 2 + (n2 - 2) * 2;
        this.indexBuffer = BufferUtils.createIntBuffer(n4);
        this.lastNumXSamples = 0;
    }

    private void checkSize() {
        int n = Math.max(10, this.getNumberOfVertices());
        if (this.capacity < n) {
            this.setCapacity(n);
        }
    }

    protected void updatePosition() {
        int n;
        this.checkSize();
        int n2 = this.getNumColumns();
        int n3 = this.getNumRows();
        if (this.lastNumXSamples != n2) {
            this.updateIndexBuffer(n2, n3);
        }
        this.positionBuffer.clear();
        this.normalBuffer.clear();
        if (this.isComputeNormals()) {
            this.positionArray = new Vector3F[n2 * n3];
        }
        Vector3F[] vector3FArray = new Vector3F[n2];
        Vector3F[] vector3FArray2 = new Vector3F[n3];
        for (n = 0; n < n2; ++n) {
            vector3FArray[n] = PlateTectonicsModel.getXRadialVector(this.getXPosition(n));
        }
        for (n = 0; n < n3; ++n) {
            vector3FArray2[n] = PlateTectonicsModel.getZRadialVector(this.getZPosition(n));
        }
        for (n = 0; n < n3; ++n) {
            Vector3F vector3F = vector3FArray2[n];
            for (int i = 0; i < n2; ++i) {
                float f = this.getElevation(i, n);
                Vector3F vector3F2 = PlateTectonicsModel.convertToRadial(vector3FArray[i], vector3F, f);
                Vector3F vector3F3 = this.modelViewTransform.transformPosition(vector3F2);
                if (this.isComputeNormals()) {
                    this.positionArray[n * n2 + i] = vector3F3;
                }
                this.positionBuffer.put(new float[]{vector3F3.x, vector3F3.y, vector3F3.z});
            }
        }
        if (this.isComputeNormals()) {
            for (n = 0; n < n3; ++n) {
                for (int i = 0; i < n2; ++i) {
                    Vector3F vector3F = this.getArrayNormal(n, i);
                    this.normalBuffer.put(new float[]{vector3F.x, vector3F.y, vector3F.z});
                }
            }
        }
    }

    private Vector3F getArrayPosition(int n, int n2) {
        return this.positionArray[n * this.getNumColumns() + n2];
    }

    private Vector3F getArrayNormal(int n, int n2) {
        Vector3F vector3F;
        Vector3F vector3F2;
        Vector3F vector3F3;
        Vector3F vector3F4;
        Vector3F vector3F5 = this.getArrayPosition(n, n2);
        if (n > 0) {
            vector3F4 = this.getArrayPosition(n - 1, n2).minus(vector3F5);
            vector3F3 = n < this.getNumRows() - 1 ? this.getArrayPosition(n + 1, n2).minus(vector3F5) : vector3F4.negated();
        } else {
            vector3F3 = this.getArrayPosition(n + 1, n2).minus(vector3F5);
            vector3F4 = vector3F3.negated();
        }
        if (n2 > 0) {
            vector3F2 = this.getArrayPosition(n, n2 - 1).minus(vector3F5);
            vector3F = n2 < this.getNumColumns() - 1 ? this.getArrayPosition(n, n2 + 1).minus(vector3F5) : vector3F2.negated();
        } else {
            vector3F = this.getArrayPosition(n, n2 + 1).minus(vector3F5);
            vector3F2 = vector3F.negated();
        }
        Vector3F vector3F6 = new Vector3F();
        try {
            vector3F6 = vector3F6.plus(vector3F.cross(vector3F4).normalized());
            vector3F6 = vector3F6.plus(vector3F4.cross(vector3F2).normalized());
            vector3F6 = vector3F6.plus(vector3F2.cross(vector3F3).normalized());
            vector3F6 = vector3F6.plus(vector3F3.cross(vector3F).normalized());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return new Vector3F(0.0f, 0.0f, 1.0f);
        }
        return vector3F6.normalized();
    }

    private void updateIndexBuffer(int n, int n2) {
        this.indexBuffer.clear();
        int n3 = 0;
        for (int i = 0; i < n2 - 1; ++i) {
            int n4 = i * n;
            if (i != 0) {
                this.indexBuffer.put(n4 + n - 1);
                this.indexBuffer.put(n4);
                n3 += 2;
            }
            for (int j = 0; j < n; ++j) {
                this.indexBuffer.put(n4 + j);
                this.indexBuffer.put(n4 + n + j);
                n3 += 2;
            }
        }
        this.indexBuffer.limit(n3);
    }

    protected void preRender(GLOptions gLOptions) {
        super.preRender(gLOptions);
        this.positionBuffer.rewind();
        this.normalBuffer.rewind();
        this.indexBuffer.rewind();
        GL11.glEnableClientState(32884);
        if (gLOptions.shouldSendNormals() && this.isComputeNormals()) {
            GL11.glEnableClientState(32885);
            GL11.glNormalPointer(0, this.normalBuffer);
        }
        GL11.glVertexPointer(3, 0, this.positionBuffer);
    }

    public void renderSelf(GLOptions gLOptions) {
        super.renderSelf(gLOptions);
        GL11.glDrawElements(5, this.indexBuffer);
    }

    protected void postRender(GLOptions gLOptions) {
        super.postRender(gLOptions);
        GL11.glDisableClientState(32884);
        if (gLOptions.shouldSendNormals() && this.isComputeNormals()) {
            GL11.glDisableClientState(32885);
        }
    }

    public boolean isComputeNormals() {
        return this.computeNormals;
    }

    public void setComputeNormals(boolean bl) {
        this.computeNormals = bl;
    }
}

