/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.view;

import edu.colorado.phet.common.phetcommon.math.Matrix4F;
import edu.colorado.phet.common.phetcommon.math.PlaneF;
import edu.colorado.phet.common.phetcommon.math.Ray3F;
import edu.colorado.phet.common.phetcommon.math.Triangle3F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.Option;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.lwjglphet.GLOptions;
import edu.colorado.phet.lwjglphet.materials.ColorMaterial;
import edu.colorado.phet.lwjglphet.math.Arrow2F;
import edu.colorado.phet.lwjglphet.math.LWJGLTransform;
import edu.colorado.phet.lwjglphet.nodes.ArrowNode;
import edu.colorado.phet.lwjglphet.nodes.GLNode;
import edu.colorado.phet.lwjglphet.shapes.GridMesh;
import edu.colorado.phet.platetectonics.model.Handle;
import edu.colorado.phet.platetectonics.model.PlateMotionModel;
import edu.colorado.phet.platetectonics.model.PlateTectonicsModel;
import edu.colorado.phet.platetectonics.tabs.PlateMotionTab;
import java.util.Arrays;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.Sphere;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandleNode
extends GLNode {
    private static int radialColumns = 30;
    private static int rows = 30;
    private Vector3F[] handlePositions;
    private GridMesh handleMesh;
    private final Handle handle;
    private final Property<Vector3F> offset;
    private final PlateMotionTab tab;
    private final LWJGLTransform transform = new LWJGLTransform();
    private PlateMotionModel model;
    private final HandleArrowNode backArrow;
    private final HandleArrowNode rightArrow;
    private final HandleArrowNode leftArrow;
    private final HandleArrowNode frontArrow;
    private Ray3F startRay = null;

    public HandleNode(final Handle handle, Property<Vector3F> property, final PlateMotionTab plateMotionTab) {
        this.handle = handle;
        this.offset = property;
        this.tab = plateMotionTab;
        this.model = plateMotionTab.getPlateMotionModel();
        this.requireEnabled(3042);
        SimpleObserver simpleObserver = new SimpleObserver(){

            public void update() {
                HandleNode.this.setVisible(handle.isVisible());
            }
        };
        plateMotionTab.getPlateMotionModel().hasBothPlates.addObserver(simpleObserver);
        plateMotionTab.isAutoMode.addObserver(simpleObserver);
        this.handlePositions = new Vector3F[radialColumns * 2];
        this.updateLocations();
        this.handleMesh = new GridMesh(2, radialColumns, this.handlePositions){
            {
                this.requireEnabled(2896);
                this.requireEnabled(2903);
                this.requireEnabled(2884);
            }

            protected void preRender(GLOptions gLOptions) {
                super.preRender(gLOptions);
                GL11.glColorMaterial(1028, 4609);
            }
        };
        this.addChild(this.handleMesh);
        final Property<PlateMotionModel.MotionType> property2 = plateMotionTab.getPlateMotionModel().motionType;
        this.backArrow = new HandleArrowNode(PlateMotionModel.MotionType.TRANSFORM, 1.5707963267948966){

            protected boolean shouldBeVisible() {
                return property2.get() == PlateMotionModel.MotionType.TRANSFORM && handle.isRightHandle == HandleNode.this.model.isTransformMotionCCW();
            }
        };
        this.addChild(this.backArrow);
        this.rightArrow = new HandleArrowNode(handle.getRightMotionType(), 0.0){

            protected boolean shouldBeVisible() {
                if (this.getArrowMotionType() == PlateMotionModel.MotionType.DIVERGENT) {
                    return property2.get() == null && plateMotionTab.getPlateMotionModel().allowsDivergentMotion() || property2.get() == PlateMotionModel.MotionType.DIVERGENT;
                }
                return property2.get() == null && plateMotionTab.getPlateMotionModel().allowsConvergentMotion() || property2.get() == PlateMotionModel.MotionType.CONVERGENT;
            }
        };
        this.addChild(this.rightArrow);
        this.leftArrow = new HandleArrowNode(handle.getLeftMotionType(), Math.PI){

            protected boolean shouldBeVisible() {
                if (this.getArrowMotionType() == PlateMotionModel.MotionType.DIVERGENT) {
                    return property2.get() == null && plateMotionTab.getPlateMotionModel().allowsDivergentMotion() || property2.get() == PlateMotionModel.MotionType.DIVERGENT;
                }
                return property2.get() == null && plateMotionTab.getPlateMotionModel().allowsConvergentMotion() || property2.get() == PlateMotionModel.MotionType.CONVERGENT;
            }
        };
        this.addChild(this.leftArrow);
        this.frontArrow = new HandleArrowNode(PlateMotionModel.MotionType.TRANSFORM, -1.5707963267948966){

            protected boolean shouldBeVisible() {
                return property2.get() == null && plateMotionTab.getPlateMotionModel().allowsTransformMotion() || property2.get() == PlateMotionModel.MotionType.TRANSFORM && handle.isRightHandle != HandleNode.this.model.isTransformMotionCCW();
            }
        };
        this.addChild(this.frontArrow);
        property.addObserver(new SimpleObserver(){

            public void update() {
                HandleNode.this.updateLocations();
            }
        });
        handle.orientation.addObserver(new SimpleObserver(){

            public void update() {
                HandleNode.this.updateTransform(handle.orientation.get().x, handle.orientation.get().y);
            }
        });
    }

    public void updateTransform(float f, float f2) {
        this.transform.set(Matrix4F.rotationZ(-f).times(Matrix4F.rotationX(f2)));
        this.updateLocations();
    }

    private Vector3F yzHit(Ray3F ray3F) {
        return new PlaneF(new Vector3F(1.0f, 0.0f, 0.0f), this.offset.get().getX()).intersectWithRay(ray3F);
    }

    private Vector3F xyHit(Ray3F ray3F) {
        return new PlaneF(new Vector3F(0.0f, 0.0f, 1.0f), this.offset.get().getZ()).intersectWithRay(ray3F);
    }

    public void startArrowPress(Ray3F ray3F) {
        PlateMotionModel.MotionType motionType = this.rayIntersectsArrow(ray3F).get();
        this.handle.startArrowPress(motionType);
    }

    public void endArrowPress() {
        this.handle.endArrowPress();
    }

    public void startHandleDrag(Ray3F ray3F) {
        this.startRay = ray3F;
        this.handle.startHandleDrag();
    }

    public void dragHandle(Ray3F ray3F) {
        boolean bl;
        if (this.model.motionType.get() == null && !(bl = this.handle.checkInitialMotion(this.xyHit(ray3F).minus(this.xyHit(this.startRay))))) {
            return;
        }
        assert (this.model.motionType.get() != null);
        boolean bl2 = bl = this.model.motionType.get() != PlateMotionModel.MotionType.TRANSFORM;
        if (bl) {
            this.handle.horizontalHandleDrag(this.getHorizontalAngle(ray3F));
        } else {
            this.handle.verticalHandleDrag(this.getVerticalAngle(ray3F));
        }
    }

    private float getHorizontalAngle(Ray3F ray3F) {
        Vector3F vector3F = this.xyHit(ray3F);
        Vector3F vector3F2 = this.xyHit(this.startRay);
        Vector3F vector3F3 = this.getBase();
        Vector3F vector3F4 = vector3F.minus(vector3F3);
        Vector3F vector3F5 = vector3F2.minus(vector3F3);
        float f = (float)((double)Math.signum(vector3F4.x - vector3F5.x) * Math.min(1.2566370801612687, Math.acos(vector3F4.normalized().dot(vector3F5.normalized()))));
        switch (this.model.motionType.get()) {
            case CONVERGENT: {
                if (this.handle.isRightHandle) {
                    f = Math.min(0.0f, f);
                    break;
                }
                f = Math.max(0.0f, f);
                break;
            }
            case DIVERGENT: {
                if (this.handle.isRightHandle) {
                    f = Math.max(0.0f, f);
                    break;
                }
                f = Math.min(0.0f, f);
                break;
            }
        }
        return f;
    }

    private float getVerticalAngle(Ray3F ray3F) {
        Vector3F vector3F = this.yzHit(ray3F);
        Vector3F vector3F2 = this.yzHit(this.startRay);
        Vector3F vector3F3 = this.getBase();
        Vector3F vector3F4 = vector3F.minus(vector3F3);
        Vector3F vector3F5 = vector3F2.minus(vector3F3);
        float f = (float)Math.min(1.2566370801612687, Math.acos(vector3F4.normalized().dot(vector3F5.normalized())));
        if (vector3F4.z < vector3F5.z) {
            f = 0.0f;
        }
        return f;
    }

    public void endHandleDrag() {
        this.handle.endHandleDrag();
    }

    public boolean rayIntersectsHandle(Ray3F ray3F) {
        float f;
        Ray3F ray3F2 = new Ray3F(ray3F.pos.minus(this.getBallCenter()).times(0.125f), ray3F.dir);
        Vector3F vector3F = ray3F2.pos;
        float f2 = ray3F2.dir.dot(vector3F);
        float f3 = 4.0f * f2 * f2 - 4.0f * ((f = vector3F.magnitudeSquared()) - 1.0f);
        return f3 >= 0.0f;
    }

    public Option<PlateMotionModel.MotionType> rayIntersectsArrow(Ray3F ray3F) {
        for (HandleArrowNode handleArrowNode : Arrays.asList(this.frontArrow, this.leftArrow, this.rightArrow, this.backArrow)) {
            if (!handleArrowNode.isVisible() || !this.rayIntersectsArrow(ray3F, handleArrowNode)) continue;
            return new Option.Some<PlateMotionModel.MotionType>(handleArrowNode.getArrowMotionType());
        }
        return new Option.None<PlateMotionModel.MotionType>();
    }

    private boolean rayIntersectsArrow(Ray3F ray3F, ArrowNode arrowNode) {
        Ray3F ray3F2 = arrowNode.getGlobalTransform().inverseRay(ray3F);
        for (Triangle3F triangle3F : arrowNode.getTriangles()) {
            Option<Triangle3F.TriangleIntersectionResult> option = triangle3F.intersectWith(ray3F2);
            if (!option.isSome()) continue;
            return true;
        }
        return false;
    }

    private void updateLocations() {
        for (int i = 0; i < radialColumns; ++i) {
            float f = (float)i / (float)(radialColumns - 1);
            float f2 = (float)Math.sin(Math.PI * 2 * (double)f);
            float f3 = (float)Math.cos(Math.PI * 2 * (double)f);
            this.handlePositions[i] = this.convertToRadial(this.transform.transformPosition(new Vector3F(f2 * 4.0f, 40.0f, f3 * 4.0f)).plus(this.offset.get()));
            this.handlePositions[HandleNode.radialColumns + i] = this.convertToRadial(this.transform.transformPosition(new Vector3F(f2 * 4.0f, 0.0f, f3 * 4.0f)).plus(this.offset.get()));
        }
        if (this.handleMesh != null) {
            this.handleMesh.updateGeometry(this.handlePositions);
        }
    }

    private Vector3F convertToRadial(Vector3F vector3F) {
        Vector3F vector3F2 = this.tab.getModelViewTransform().inversePosition(vector3F);
        Vector3F vector3F3 = PlateTectonicsModel.convertToRadial(vector3F2);
        Vector3F vector3F4 = this.tab.getModelViewTransform().transformPosition(vector3F3);
        return vector3F4;
    }

    @Override
    public void renderSelf(GLOptions gLOptions) {
        super.renderSelf(gLOptions);
        GL11.glPushMatrix();
        Vector3F vector3F = this.getBallCenter();
        GL11.glTranslatef(vector3F.x, vector3F.y, vector3F.z);
        GL11.glEnable(2903);
        GL11.glColorMaterial(1028, 4609);
        GL11.glEnable(2884);
        GL11.glEnable(2896);
        GL11.glColor4f(0.6f, 0.0f, 0.0f, 1.0f);
        new Sphere().draw(8.0f, 25, 25);
        GL11.glDisable(2896);
        GL11.glDisable(2929);
        GL11.glColor4f(1.0f, 0.0f, 0.0f, 0.4f);
        new Sphere().draw(8.0f, 25, 25);
        GL11.glEnable(2929);
        GL11.glDisable(2903);
        GL11.glDisable(2884);
        GL11.glPopMatrix();
        this.handleMesh.setMaterial(new ColorMaterial(1.0f, 1.0f, 1.0f, 0.2f));
        GL11.glFrontFace(2304);
        this.handleMesh.render(gLOptions);
        GL11.glFrontFace(2305);
        this.handleMesh.setMaterial(new ColorMaterial(1.0f, 1.0f, 1.0f, 0.4f));
    }

    private Vector3F getBallCenter() {
        return this.convertToRadial(this.transform.transformPosition(new Vector3F(0.0f, 40.0f, 0.0f)).plus(this.offset.get()));
    }

    private Vector3F getBase() {
        return this.convertToRadial(this.offset.get());
    }

    private abstract class HandleArrowNode
    extends ArrowNode {
        private final PlateMotionModel.MotionType motionType;

        protected abstract boolean shouldBeVisible();

        public HandleArrowNode(PlateMotionModel.MotionType motionType, double d) {
            super(new Arrow2F(new Vector2F(5.0f, 0.0f), new Vector2F(50.0f, 0.0f), 14.0f, 14.0f, 8.0f));
            this.motionType = motionType;
            this.setFillMaterial(new ColorMaterial(motionType.color));
            this.setStrokeMaterial(new ColorMaterial(0.0f, 0.0f, 0.0f, 1.0f));
            Vector3F vector3F = ((Vector3F)HandleNode.this.offset.get()).plus(Vector3F.Y_UNIT.times(57.0f));
            Vector3F vector3F2 = HandleNode.this.convertToRadial(vector3F);
            this.translate(vector3F2.x, vector3F2.y, vector3F2.z);
            this.rotate(Vector3F.Y_UNIT, (float)d);
            Vector3F vector3F3 = vector3F.plus(Matrix4F.rotation(Vector3F.Y_UNIT, (float)d).times(new Vector3F(45.0f, 0.0f, 0.0f)));
            Vector3F vector3F4 = HandleNode.this.convertToRadial(vector3F3);
            Vector3F vector3F5 = vector3F4.minus(vector3F2).normalized();
            float f = (float)Math.atan2(vector3F5.getY(), Math.sqrt(vector3F5.x * vector3F5.x + vector3F5.z * vector3F5.z));
            if (motionType == PlateMotionModel.MotionType.TRANSFORM && d < 0.0) {
                f = -0.06283186f;
            }
            this.rotate(Vector3F.Z_UNIT, f);
            SimpleObserver simpleObserver = new SimpleObserver(){

                public void update() {
                    HandleArrowNode.this.setVisible(HandleArrowNode.this.shouldBeVisible());
                }
            };
            ((HandleNode)HandleNode.this).tab.getPlateMotionModel().motionType.addObserver(simpleObserver);
            ((HandleNode)HandleNode.this).tab.getPlateMotionModel().hasBothPlates.addObserver(simpleObserver);
        }

        public PlateMotionModel.MotionType getArrowMotionType() {
            return this.motionType;
        }
    }
}

